/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.localserver.LocalServerTestBase;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestClientRequestExecution
extends LocalServerTestBase {
    @Test
    public void testAutoGeneratedHeaders() throws Exception {
        this.serverBootstrap.registerHandler("*", (HttpRequestHandler)new SimpleService());
        HttpRequestInterceptor interceptor = new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                request.addHeader("my-header", "stuff");
            }
        };
        HttpRequestRetryHandler requestRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                return true;
            }
        };
        this.httpclient = this.clientBuilder.addInterceptorFirst(interceptor).setRequestExecutor((HttpRequestExecutor)new FaultyHttpRequestExecutor("Oppsie")).setRetryHandler(requestRetryHandler).build();
        HttpHost target = this.start();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("/");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Header[] myheaders = reqWrapper.getHeaders("my-header");
        Assert.assertNotNull((Object)myheaders);
        Assert.assertEquals((long)1L, (long)myheaders.length);
    }

    @Test(expected=ClientProtocolException.class)
    public void testNonRepeatableEntity() throws Exception {
        this.serverBootstrap.registerHandler("*", (HttpRequestHandler)new SimpleService());
        HttpRequestRetryHandler requestRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                return true;
            }
        };
        this.httpclient = this.clientBuilder.setRequestExecutor((HttpRequestExecutor)new FaultyHttpRequestExecutor("a message showing that this failed")).setRetryHandler(requestRetryHandler).build();
        HttpHost target = this.start();
        HttpClientContext context = HttpClientContext.create();
        HttpPost httppost = new HttpPost("/");
        httppost.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}), -1L));
        try {
            this.httpclient.execute(target, (HttpRequest)httppost, (HttpContext)context);
        }
        catch (ClientProtocolException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof NonRepeatableRequestException));
            NonRepeatableRequestException nonRepeat = (NonRepeatableRequestException)ex.getCause();
            Assert.assertTrue((boolean)(nonRepeat.getCause() instanceof IOException));
            Assert.assertEquals((Object)"a message showing that this failed", (Object)nonRepeat.getCause().getMessage());
            throw ex;
        }
    }

    @Test
    public void testNonCompliantURI() throws Exception {
        this.serverBootstrap.registerHandler("*", (HttpRequestHandler)new SimpleService());
        HttpHost target = this.start();
        HttpClientContext context = HttpClientContext.create();
        BasicHttpRequest request = new BasicHttpRequest("GET", "blah.:.blah.:.");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)request, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        HttpRequest reqWrapper = context.getRequest();
        Assert.assertEquals((Object)"blah.:.blah.:.", (Object)reqWrapper.getRequestLine().getUri());
    }

    @Test
    public void testRelativeRequestURIWithFragment() throws Exception {
        this.serverBootstrap.registerHandler("*", (HttpRequestHandler)new SimpleService());
        HttpHost target = this.start();
        HttpGet httpget = new HttpGet("/stuff#blahblah");
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest request = context.getRequest();
        Assert.assertEquals((Object)"/stuff", (Object)request.getRequestLine().getUri());
    }

    @Test
    public void testAbsoluteRequestURIWithFragment() throws Exception {
        this.serverBootstrap.registerHandler("*", (HttpRequestHandler)new SimpleService());
        HttpHost target = this.start();
        URI uri = new URIBuilder().setHost(target.getHostName()).setPort(target.getPort()).setScheme(target.getSchemeName()).setPath("/stuff").setFragment("blahblah").build();
        HttpGet httpget = new HttpGet(uri);
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpget, (HttpContext)context);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest request = context.getRequest();
        Assert.assertEquals((Object)"/stuff", (Object)request.getRequestLine().getUri());
        List redirectLocations = context.getRedirectLocations();
        URI location = URIUtils.resolve((URI)uri, (HttpHost)target, (List)redirectLocations);
        Assert.assertEquals((Object)uri, (Object)location);
    }

    private static class FaultyHttpRequestExecutor
    extends HttpRequestExecutor {
        private static final String MARKER = "marker";
        private final String failureMsg;

        public FaultyHttpRequestExecutor(String failureMsg) {
            this.failureMsg = failureMsg;
        }

        public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
            HttpResponse response = super.execute(request, conn, context);
            Object marker = context.getAttribute(MARKER);
            if (marker == null) {
                context.setAttribute(MARKER, (Object)Boolean.TRUE);
                throw new IOException(this.failureMsg);
            }
            return response;
        }
    }

    private static class SimpleService
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setStatusCode(200);
            StringEntity entity = new StringEntity("Whatever");
            response.setEntity((HttpEntity)entity);
        }
    }
}

