/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.appserver.jetty;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.Logger;

public class Log4j2Logger
extends AbstractLogger {
    private static final String PARENT_FQCN = AbstractLogger.class.getName();
    static final String FQCN = Log4j2Logger.class.getName();
    private final ExtendedLogger logger;
    private final String name;

    public Log4j2Logger() {
        this("");
    }

    public Log4j2Logger(String name) {
        this.name = name;
        this.logger = PrivateManager.getLogger(name);
    }

    public void debug(String msg, Object ... args) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, null, msg, args);
    }

    public void debug(String msg, Throwable thrown) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, null, msg, thrown);
    }

    public void debug(Throwable thrown) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, null, null, thrown);
    }

    public String getName() {
        return this.name;
    }

    public void ignore(Throwable ignored) {
    }

    public void info(String msg, Object ... args) {
        this.logger.logIfEnabled(FQCN, Level.INFO, null, msg, args);
    }

    public void info(String msg, Throwable thrown) {
        this.logger.logIfEnabled(FQCN, Level.INFO, null, msg, thrown);
    }

    public void info(Throwable thrown) {
        this.logger.logIfEnabled(FQCN, Level.INFO, null, null, thrown);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    protected Logger newLogger(String fullname) {
        return new Log4j2Logger(fullname);
    }

    public void setDebugEnabled(boolean enabled) {
        this.warn("setDebugEnabled not implemented", new Object[0]);
    }

    public void warn(String msg, Object ... args) {
        this.logger.logIfEnabled(FQCN, Level.WARN, null, msg, args);
    }

    public void warn(String msg, Throwable thrown) {
        this.logger.logIfEnabled(FQCN, Level.WARN, null, msg, thrown);
    }

    public void warn(Throwable thrown) {
        this.logger.logIfEnabled(FQCN, Level.WARN, null, null, thrown);
    }

    private static class PrivateManager
    extends LogManager {
        private PrivateManager() {
        }

        public static LoggerContext getContext() {
            ClassLoader cl = AbstractLogger.class.getClassLoader();
            return PrivateManager.getContext((String)PARENT_FQCN, (ClassLoader)cl, (boolean)false);
        }

        public static ExtendedLogger getLogger(String name) {
            return PrivateManager.getContext().getLogger(name);
        }
    }
}

