/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import org.apache.commons.lang.SystemUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.enforcer.DefaultEnforcementRuleHelper;
import org.apache.maven.plugins.enforcer.EnforcerExpressionEvaluator;
import org.apache.maven.plugins.enforcer.RequireJavaVersion;
import org.apache.maven.plugins.enforcer.RequireOS;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Mojo(name="display-info", threadSafe=true)
public class DisplayInfoMojo
extends AbstractMojo
implements Contextualizable {
    @Component(role=PathTranslator.class)
    protected PathTranslator translator;
    @Component
    protected MavenSession session;
    @Component
    protected MavenProject project;
    protected PlexusContainer container;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public void execute() throws MojoExecutionException {
        try {
            EnforcerExpressionEvaluator evaluator = new EnforcerExpressionEvaluator(this.session, this.translator, this.project);
            DefaultEnforcementRuleHelper helper = new DefaultEnforcementRuleHelper(this.session, (ExpressionEvaluator)evaluator, this.getLog(), this.container);
            RuntimeInformation rti = (RuntimeInformation)helper.getComponent(RuntimeInformation.class);
            this.getLog().info((CharSequence)("Maven Version: " + rti.getApplicationVersion()));
            this.getLog().info((CharSequence)("JDK Version: " + SystemUtils.JAVA_VERSION + " normalized as: " + RequireJavaVersion.normalizeJDKVersion((String)SystemUtils.JAVA_VERSION_TRIMMED)));
            RequireOS os = new RequireOS();
            os.displayOSInfo(this.getLog(), true);
        }
        catch (ComponentLookupException e) {
            this.getLog().warn((CharSequence)("Unable to Lookup component: " + e.getLocalizedMessage()));
        }
    }
}

