/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.exec;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TeeOutputStream
extends FilterOutputStream {
    private final ByteArrayOutputStream bout = new ByteArrayOutputStream(8192);
    private final byte[] indent;
    private int last = 10;

    public TeeOutputStream(OutputStream out) {
        this(out, "    ");
    }

    public TeeOutputStream(OutputStream out, String i) {
        super(out);
        this.indent = i.getBytes();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int x = 0; x < len; ++x) {
            int c = b[off + x];
            if (this.last == 10 || this.last == 13 && c != 10) {
                this.out.write(b, off, x);
                this.bout.write(b, off, x);
                this.out.write(this.indent);
                off += x;
                len -= x;
                x = 0;
            }
            this.last = c;
        }
        this.out.write(b, off, len);
        this.bout.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.last == 10 || this.last == 13 && b != 10) {
            this.out.write(this.indent);
        }
        this.out.write(b);
        this.bout.write(b);
        this.last = b;
    }

    public String toString() {
        return this.bout.toString();
    }

    public String getContent() {
        return this.bout.toString();
    }
}

