/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.exposers;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import org.apache.commons.collections.bag.HashBag;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.identification.JarIdentification;
import org.apache.maven.shared.jar.identification.JarIdentificationExposer;
import org.apache.maven.shared.utils.StringUtils;

public class TimestampExposer
implements JarIdentificationExposer {
    public void expose(JarIdentification identification, JarAnalyzer jarAnalyzer) {
        List entries = jarAnalyzer.getEntries();
        SimpleDateFormat tsformat = new SimpleDateFormat("yyyyMMdd", Locale.US);
        HashBag timestamps = new HashBag();
        for (JarEntry entry : entries) {
            long time = entry.getTime();
            String timestamp = tsformat.format(new Date(time));
            timestamps.add((Object)timestamp);
        }
        Iterator it = timestamps.iterator();
        String ts = "";
        int tsmax = 0;
        while (it.hasNext()) {
            String timestamp = (String)it.next();
            int count = timestamps.getCount((Object)timestamp);
            if (count <= tsmax) continue;
            ts = timestamp;
            tsmax = count;
        }
        if (StringUtils.isNotEmpty((String)ts)) {
            identification.addVersion(ts);
        }
    }
}

