/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader;

import java.util.ArrayList;
import java.util.Arrays;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;

public class ClassDescriptorHelper {
    public static FieldDescriptor[] getFullFields(ClassDescriptor classDescriptor) throws MappingException {
        ClassDescriptor baseClassDescriptor = classDescriptor.getExtends();
        ArrayList<FieldDescriptor> fullFields = new ArrayList<FieldDescriptor>();
        if (baseClassDescriptor != null) {
            ClassDescriptor origin = baseClassDescriptor;
            while (origin.getExtends() != null) {
                origin = origin.getExtends();
            }
            FieldDescriptor[] fullBaseFieldDescriptors = ClassDescriptorHelper.getFullFields(baseClassDescriptor);
            FieldDescriptor[] currentFields = classDescriptor.getFields();
            for (FieldDescriptor baseFieldDescriptor : fullBaseFieldDescriptors) {
                fullFields.add(baseFieldDescriptor);
            }
            for (FieldDescriptor currentFieldDescriptor : currentFields) {
                fullFields.add(currentFieldDescriptor);
            }
        } else {
            FieldDescriptor[] fieldDescriptors = ((ClassDescriptorImpl)classDescriptor).getFields();
            fullFields.addAll(Arrays.asList(fieldDescriptors));
        }
        return fullFields.toArray(new FieldDescriptor[fullFields.size()]);
    }

    public static FieldDescriptor[] getIdFields(ClassDescriptor classDescriptor) throws MappingException {
        ClassDescriptor base = classDescriptor;
        while (base.getExtends() != null) {
            base = base.getExtends();
        }
        FieldDescriptor[] identities = ((ClassDescriptorImpl)base).getIdentities();
        if (identities == null || identities.length == 0) {
            throw new MappingException("Identity is null!");
        }
        return identities;
    }
}

