/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.HashSet;
import java.util.Set;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.xml.NamespacesStack;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AnyNode2SAX2 {
    private AnyNode _node;
    private ContentHandler _handler;
    private Set<AnyNode> _elements = new HashSet<AnyNode>();
    private NamespacesStack namespacesStack;

    public AnyNode2SAX2() {
        this(null, null);
    }

    public AnyNode2SAX2(AnyNode node) {
        this(node, null);
    }

    public AnyNode2SAX2(AnyNode node, NamespacesStack namespacesStack) {
        this._node = node;
        this.namespacesStack = namespacesStack != null ? namespacesStack : new NamespacesStack();
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("AnyNode2SAX2#setContentHandler 'null' value for handler");
        }
        this._handler = handler;
    }

    public static void fireEvents(AnyNode node, ContentHandler handler) throws SAXException {
        AnyNode2SAX2.fireEvents(node, handler, null);
    }

    public static void fireEvents(AnyNode node, ContentHandler handler, NamespacesStack namespacesStack) throws SAXException {
        AnyNode2SAX2 eventProducer = new AnyNode2SAX2(node, namespacesStack);
        eventProducer.setContentHandler(handler);
        if (node != null && namespacesStack != null && node.getNamespacePrefix() != null && namespacesStack.getNamespaceURI(node.getNamespacePrefix()) == null) {
            handler.startPrefixMapping(node.getNamespacePrefix(), node.getNamespaceURI());
        }
        eventProducer.start();
    }

    public void start() throws SAXException {
        if (this._node == null || this._handler == null) {
            return;
        }
        this.processAnyNode(this._node, this._handler);
    }

    private void processAnyNode(AnyNode node, ContentHandler handler) throws SAXException {
        String value;
        if (this._node == null || this._handler == null) {
            throw new IllegalArgumentException();
        }
        if (!this._elements.add(node)) {
            return;
        }
        if (node.getNodeType() == 1) {
            int len;
            AnyNode tempNode;
            String name = node.getLocalName();
            String prefix = null;
            for (tempNode = node.getFirstNamespace(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                String value2;
                prefix = tempNode.getNamespacePrefix();
                if (prefix == null) {
                    prefix = "";
                }
                if ((value2 = tempNode.getNamespaceURI()) == null) {
                    value2 = "";
                }
                handler.startPrefixMapping(prefix, value2);
                if (value2 == null || value2.length() <= 0) continue;
                this.namespacesStack.addNamespace(prefix, value2);
            }
            AttributesImpl atts = new AttributesImpl();
            String xmlName = null;
            String value3 = null;
            String attUri = null;
            String attPrefix = null;
            for (tempNode = node.getFirstAttribute(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                String localName = xmlName = tempNode.getLocalName();
                attUri = tempNode.getNamespaceURI();
                if (attUri != null) {
                    attPrefix = this.namespacesStack.getNamespacePrefix(attUri);
                } else {
                    attUri = "";
                }
                if (attPrefix != null && attPrefix.length() > 0) {
                    xmlName = attPrefix + ':' + xmlName;
                }
                value3 = tempNode.getStringValue();
                atts.addAttribute(attUri, localName, xmlName, "CDATA", value3);
            }
            String nsPrefix = node.getNamespacePrefix();
            String nsURI = node.getNamespaceURI();
            String qName = null;
            if (nsURI != null && nsURI.length() > 0) {
                String tempPrefix = this.namespacesStack.getNamespacePrefix(nsURI);
                if (tempPrefix != null) {
                    nsPrefix = tempPrefix;
                } else {
                    this.namespacesStack.addNamespace(nsPrefix, nsURI);
                }
            } else {
                nsURI = "";
            }
            qName = nsPrefix != null ? ((len = nsPrefix.length()) > 0 ? nsPrefix + ':' + name : name) : name;
            try {
                handler.startElement(nsURI, name, qName, atts);
            }
            catch (SAXException sx) {
                throw new SAXException(sx);
            }
            for (tempNode = node.getFirstChild(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                this.namespacesStack.addNewNamespaceScope();
                this.processAnyNode(tempNode, handler);
            }
            try {
                handler.endElement(nsURI, name, qName);
                this.namespacesStack.removeNamespaceScope();
                for (tempNode = node.getFirstNamespace(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                    prefix = tempNode.getNamespacePrefix();
                    if (prefix == null) {
                        prefix = "";
                    }
                    handler.endPrefixMapping(prefix);
                }
            }
            catch (SAXException sx) {
                throw new SAXException(sx);
            }
        }
        if (node.getNodeType() == 6 && (value = node.getStringValue()) != null && value.length() > 0) {
            char[] chars = value.toCharArray();
            try {
                handler.characters(chars, 0, chars.length);
            }
            catch (SAXException sx) {
                throw new SAXException(sx);
            }
        }
    }
}

