/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import org.cyclonedx.model.formulation.common.AbstractType;
import org.cyclonedx.model.formulation.common.EnvVariableChoice;
import org.cyclonedx.model.formulation.common.ResourceReferenceChoice;
import org.cyclonedx.util.deserializer.DeserializerUtils;

public abstract class AbstractDataTypeDeserializer<T extends AbstractType>
extends JsonDeserializer<T> {
    protected final ObjectMapper objectMapper = new ObjectMapper();

    protected void setEnvironmentVars(JsonNode node, AbstractType data) throws JsonProcessingException {
        JsonNode nodes = node.get("environmentVars");
        ArrayList<EnvVariableChoice> environmentVars = new ArrayList<EnvVariableChoice>();
        if (nodes != null) {
            ArrayNode environmentVarsNode = DeserializerUtils.getArrayNode(nodes, this.objectMapper);
            for (JsonNode envVarNode : environmentVarsNode) {
                EnvVariableChoice envVar = (EnvVariableChoice)this.objectMapper.treeToValue((TreeNode)envVarNode, EnvVariableChoice.class);
                environmentVars.add(envVar);
            }
        }
        data.setEnvironmentVars(environmentVars);
    }

    protected void setReference(JsonNode node, String fieldName, AbstractType type) throws JsonProcessingException {
        if (node.has(fieldName)) {
            JsonNode fieldNode = node.get(fieldName);
            ResourceReferenceChoice reference = (ResourceReferenceChoice)this.objectMapper.treeToValue((TreeNode)fieldNode, ResourceReferenceChoice.class);
            if ("source".equals(fieldName)) {
                type.setSource(reference);
            } else if ("target".equals(fieldName)) {
                type.setTarget(reference);
            }
        }
    }

    protected void setSourceAndTarget(JsonNode node, AbstractType type) throws JsonProcessingException {
        this.setReference(node, "source", type);
        this.setReference(node, "target", type);
    }
}

