/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cyclonedx.model.ReleaseNotes;
import org.cyclonedx.model.Source;
import org.cyclonedx.util.deserializer.DeserializerUtils;

public class ResolvesDeserializer
extends JsonDeserializer<List<ReleaseNotes.Resolves>> {
    private final ObjectMapper mapper = new ObjectMapper();

    public List<ReleaseNotes.Resolves> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        return this.parseResolvesNode(node.has("issue") ? node.get("issue") : node);
    }

    private List<ReleaseNotes.Resolves> parseResolvesNode(JsonNode node) {
        ArrayList<ReleaseNotes.Resolves> resolvesList = new ArrayList<ReleaseNotes.Resolves>();
        ArrayNode nodes = DeserializerUtils.getArrayNode(node, this.mapper);
        for (JsonNode resolvesNode : nodes) {
            resolvesList.add(this.parseResolves(resolvesNode));
        }
        return resolvesList;
    }

    private ReleaseNotes.Resolves parseResolves(JsonNode node) {
        ReleaseNotes.Resolves resolves = new ReleaseNotes.Resolves();
        if (node.has("type")) {
            resolves.setType(ReleaseNotes.Resolves.Type.valueOf(node.get("type").asText().toUpperCase()));
        }
        if (node.has("id")) {
            resolves.setId(node.get("id").asText());
        }
        if (node.has("name")) {
            resolves.setName(node.get("name").asText());
        }
        if (node.has("description")) {
            resolves.setDescription(node.get("description").asText());
        }
        if (node.has("source")) {
            Source source = (Source)this.mapper.convertValue((Object)node.get("source"), Source.class);
            resolves.setSource(source);
        }
        if (node.has("references")) {
            resolves.setReferences(this.parseReferences(node.get("references")));
        }
        return resolves;
    }

    private List<String> parseReferences(JsonNode referencesNode) {
        ArrayList<String> references = new ArrayList<String>();
        if (referencesNode.isArray()) {
            for (JsonNode refNode : referencesNode) {
                references.add(refNode.asText());
            }
        } else {
            references.add(referencesNode.get("url").asText());
        }
        return references;
    }
}

