/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import org.cyclonedx.model.formulation.common.InputType;
import org.cyclonedx.util.serializer.AbstractDataTypeSerializer;

public class InputTypeSerializer
extends AbstractDataTypeSerializer<InputType> {
    private final boolean isXml;

    public InputTypeSerializer(boolean isXml) {
        this(null, isXml);
    }

    public InputTypeSerializer(Class<InputType> t, boolean isXml) {
        super(t);
        this.isXml = isXml;
    }

    public void serialize(InputType value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            this.createInputChoice(value, (JsonGenerator)xmlGenerator);
        } else {
            this.createInputChoice(value, jsonGenerator);
        }
    }

    private void createInputChoice(InputType input, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        if (input.getResource() != null) {
            jsonGenerator.writeFieldName("resource");
            jsonGenerator.writeObject((Object)input.getResource());
        } else if (input.getParameters() != null && !input.getParameters().isEmpty()) {
            jsonGenerator.writeFieldName("parameters");
            jsonGenerator.writeObject(input.getParameters());
        } else if (input.getEnvironmentVars() != null && !input.getEnvironmentVars().isEmpty()) {
            this.parseEnvironmentVars(jsonGenerator, input.getEnvironmentVars());
        } else if (input.getData() != null) {
            jsonGenerator.writeFieldName("data");
            jsonGenerator.writeObject((Object)input.getData());
        }
        this.writeField(jsonGenerator, "source", input.getSource());
        this.writeField(jsonGenerator, "target", input.getTarget());
        this.writeField(jsonGenerator, "properties", input.getProperties());
        jsonGenerator.writeEndObject();
    }

    public Class<InputType> handledType() {
        return InputType.class;
    }
}

