/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ehcache.config.Eviction;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourceType;
import org.ehcache.config.SizedResourcePool;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.EhcachePrefixLoggerFactory;
import org.ehcache.core.collections.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.events.NullStoreEventDispatcher;
import org.ehcache.core.events.StoreEventDispatcher;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.store.tiering.LowerCachingTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.core.statistics.OperationStatistic;
import org.ehcache.core.statistics.TierOperationOutcomes;
import org.ehcache.impl.internal.events.ThreadLocalStoreEventDispatcher;
import org.ehcache.impl.internal.store.offheap.AbstractOffHeapStore;
import org.ehcache.impl.internal.store.offheap.EhcacheConcurrentOffHeapClockCache;
import org.ehcache.impl.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.ehcache.impl.internal.store.offheap.HeuristicConfiguration;
import org.ehcache.impl.internal.store.offheap.OffHeapStoreUtils;
import org.ehcache.impl.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.impl.internal.store.offheap.SwitchableEvictionAdvisor;
import org.ehcache.impl.internal.store.offheap.factories.EhcacheSegmentFactory;
import org.ehcache.impl.internal.store.offheap.portability.OffHeapValueHolderPortability;
import org.ehcache.impl.internal.store.offheap.portability.SerializerPortability;
import org.ehcache.impl.store.BaseStore;
import org.ehcache.spi.resilience.StoreAccessException;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.slf4j.Logger;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.paging.UpfrontAllocatingPageSource;
import org.terracotta.offheapstore.storage.OffHeapBufferStorageEngine;
import org.terracotta.offheapstore.storage.PointerSize;
import org.terracotta.offheapstore.util.Factory;

public class OffHeapStore<K, V>
extends AbstractOffHeapStore<K, V> {
    private final SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final long sizeInBytes;
    private volatile EhcacheConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> map;

    public OffHeapStore(Store.Configuration<K, V> config, TimeSource timeSource, StoreEventDispatcher<K, V> eventDispatcher, long sizeInBytes, StatisticsService statisticsService) {
        super(config, timeSource, eventDispatcher, statisticsService);
        EvictionAdvisor evictionAdvisor = config.getEvictionAdvisor();
        this.evictionAdvisor = evictionAdvisor != null ? OffHeapStore.wrap(evictionAdvisor) : OffHeapStore.wrap(Eviction.noAdvice());
        this.keySerializer = config.getKeySerializer();
        this.valueSerializer = config.getValueSerializer();
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    protected String getStatisticsTag() {
        return "OffHeap";
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return Collections.emptyList();
    }

    private EhcacheConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> createBackingMap(long size, Serializer<K> keySerializer, Serializer<V> valueSerializer, SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor) {
        HeuristicConfiguration config = new HeuristicConfiguration(size);
        UpfrontAllocatingPageSource source = new UpfrontAllocatingPageSource(OffHeapStoreUtils.getBufferSource(), config.getMaximumSize(), config.getMaximumChunkSize(), config.getMinimumChunkSize());
        SerializerPortability<K> keyPortability = new SerializerPortability<K>(keySerializer);
        OffHeapValueHolderPortability<V> valuePortability = this.createValuePortability(valueSerializer);
        Factory storageEngineFactory = OffHeapBufferStorageEngine.createFactory((PointerSize)PointerSize.INT, (PageSource)source, (int)config.getSegmentDataPageSize(), keyPortability, valuePortability, (boolean)false, (boolean)true);
        EhcacheSegmentFactory<K, OffHeapValueHolder<V>> segmentFactory = new EhcacheSegmentFactory<K, OffHeapValueHolder<V>>((PageSource)source, storageEngineFactory, config.getInitialSegmentTableSize(), evictionAdvisor, this.mapEvictionListener);
        return new EhcacheConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>>(evictionAdvisor, segmentFactory, config.getConcurrency());
    }

    @Override
    protected EhcacheOffHeapBackingMap<K, OffHeapValueHolder<V>> backingMap() {
        return this.map;
    }

    @Override
    protected SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor() {
        return this.evictionAdvisor;
    }

    @ServiceDependencies(value={TimeSourceService.class, SerializationProvider.class})
    public static class Provider
    extends BaseStore.BaseStoreProvider
    implements AuthoritativeTier.Provider,
    LowerCachingTier.Provider,
    Store.ElementalProvider {
        private final Logger logger = EhcachePrefixLoggerFactory.getLogger(Provider.class);
        private final Set<Store<?, ?>> createdStores = Collections.newSetFromMap(new ConcurrentWeakIdentityHashMap());
        private final Map<OffHeapStore<?, ?>, OperationStatistic<?>[]> tierOperationStatistics = new ConcurrentWeakIdentityHashMap();

        protected ResourceType<SizedResourcePool> getResourceType() {
            return ResourceType.Core.OFFHEAP;
        }

        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
            return resourceTypes.equals(Collections.singleton(ResourceType.Core.OFFHEAP)) ? 1 : 0;
        }

        public int rankAuthority(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
            return this.rank(resourceTypes, serviceConfigs);
        }

        public int rankLowerCachingTier(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
            return this.rank(resourceTypes, serviceConfigs);
        }

        public <K, V> OffHeapStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
            OffHeapStore<K, V> store = this.createStoreInternal(storeConfig, new ThreadLocalStoreEventDispatcher(storeConfig.getDispatcherConcurrency()), serviceConfigs);
            this.tierOperationStatistics.put(store, new OperationStatistic[]{this.createTranslatedStatistic(store, "get", TierOperationOutcomes.GET_TRANSLATION, "get"), this.createTranslatedStatistic(store, "eviction", TierOperationOutcomes.EVICTION_TRANSLATION, "eviction")});
            return store;
        }

        private <K, V> OffHeapStore<K, V> createStoreInternal(Store.Configuration<K, V> storeConfig, StoreEventDispatcher<K, V> eventDispatcher, ServiceConfiguration<?, ?> ... serviceConfigs) {
            if (this.getServiceProvider() == null) {
                throw new NullPointerException("ServiceProvider is null in OffHeapStore.Provider.");
            }
            TimeSource timeSource = ((TimeSourceService)this.getServiceProvider().getService(TimeSourceService.class)).getTimeSource();
            SizedResourcePool offHeapPool = (SizedResourcePool)storeConfig.getResourcePools().getPoolForResource(this.getResourceType());
            if (!(offHeapPool.getUnit() instanceof MemoryUnit)) {
                throw new IllegalArgumentException("OffHeapStore only supports resources with memory unit");
            }
            MemoryUnit unit = (MemoryUnit)offHeapPool.getUnit();
            OffHeapStore<K, V> offHeapStore = new OffHeapStore<K, V>(storeConfig, timeSource, eventDispatcher, unit.toBytes(offHeapPool.getSize()), (StatisticsService)this.getServiceProvider().getService(StatisticsService.class));
            this.createdStores.add(offHeapStore);
            return offHeapStore;
        }

        public void releaseStore(Store<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            OffHeapStore offHeapStore = (OffHeapStore)resource;
            Provider.close(offHeapStore);
            this.getStatisticsService().ifPresent(s -> s.cleanForNode((Object)offHeapStore));
            this.tierOperationStatistics.remove(offHeapStore);
        }

        static void close(OffHeapStore<?, ?> resource) {
            EhcacheConcurrentOffHeapClockCache localMap = resource.map;
            if (localMap != null) {
                resource.map = null;
                localMap.destroy();
            }
        }

        public void initStore(Store<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            Provider.init((OffHeapStore)resource);
        }

        static <K, V> void init(OffHeapStore<K, V> resource) {
            resource.map = resource.createBackingMap(resource.sizeInBytes, resource.keySerializer, resource.valueSerializer, resource.evictionAdvisor);
        }

        @Override
        public void stop() {
            try {
                this.createdStores.clear();
            }
            finally {
                super.stop();
            }
        }

        public <K, V> AuthoritativeTier<K, V> createAuthoritativeTier(Set<ResourceType<?>> resourceTypes, Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
            OffHeapStore<K, V> authoritativeTier = this.createStoreInternal(storeConfig, new ThreadLocalStoreEventDispatcher(storeConfig.getDispatcherConcurrency()), serviceConfigs);
            this.tierOperationStatistics.put(authoritativeTier, new OperationStatistic[]{this.createTranslatedStatistic(authoritativeTier, "get", TierOperationOutcomes.GET_AND_FAULT_TRANSLATION, "getAndFault"), this.createTranslatedStatistic(authoritativeTier, "eviction", TierOperationOutcomes.EVICTION_TRANSLATION, "eviction")});
            return authoritativeTier;
        }

        public void releaseAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.releaseStore((Store<?, ?>)resource);
        }

        public void initAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.initStore((Store<?, ?>)resource);
        }

        public <K, V> LowerCachingTier<K, V> createCachingTier(Set<ResourceType<?>> resourceTypes, Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
            OffHeapStore<K, V> lowerCachingTier = this.createStoreInternal(storeConfig, NullStoreEventDispatcher.nullStoreEventDispatcher(), serviceConfigs);
            this.tierOperationStatistics.put(lowerCachingTier, new OperationStatistic[]{this.createTranslatedStatistic(lowerCachingTier, "get", TierOperationOutcomes.GET_AND_REMOVE_TRANSLATION, "getAndRemove"), this.createTranslatedStatistic(lowerCachingTier, "eviction", TierOperationOutcomes.EVICTION_TRANSLATION, "eviction")});
            return lowerCachingTier;
        }

        public void releaseCachingTier(LowerCachingTier<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            this.flushToLowerTier((OffHeapStore)resource);
            this.releaseStore((Store)resource);
        }

        private void flushToLowerTier(OffHeapStore<Object, ?> offheapStore) {
            StoreAccessException lastFailure = null;
            int failureCount = 0;
            for (Object key : offheapStore.backingMap().keySet()) {
                try {
                    offheapStore.invalidate(key);
                }
                catch (StoreAccessException cae) {
                    lastFailure = cae;
                    ++failureCount;
                    this.logger.warn("Error flushing '{}' to lower tier", key, (Object)cae);
                }
            }
            if (lastFailure != null) {
                throw new RuntimeException("Failed to flush some mappings to lower tier, " + failureCount + " could not be flushed. This error represents the last failure.", lastFailure);
            }
        }

        public void initCachingTier(LowerCachingTier<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            Provider.init((OffHeapStore)resource);
        }
    }
}

