/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared.store;

import java.util.Collection;
import java.util.Set;
import org.ehcache.CachePersistenceException;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.store.Store;
import org.ehcache.impl.internal.store.shared.AbstractPartition;
import org.ehcache.impl.internal.store.shared.AbstractSharedTierProvider;
import org.ehcache.impl.internal.store.shared.store.StorePartition;
import org.ehcache.spi.persistence.PersistableResourceService;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.service.MaintainableService;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceProvider;

public class SharedStoreProvider
extends AbstractSharedTierProvider
implements Store.Provider,
PersistableResourceService {
    public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
        return this.rank(Store.class, resourceTypes);
    }

    public <K, V> Store<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
        ResourceType.SharedResource<?> resourceType = SharedStoreProvider.assertResourceIsShareable(storeConfig.getResourcePools().getResourceTypeSet());
        String alias = this.extractAlias(serviceConfigs);
        return this.sharedStorageProvider.partition(alias, resourceType.getResourceType(), storeConfig, (id, store, storage) -> {
            StorePartition partition = new StorePartition((ResourceType<?>)resourceType.getResourceType(), id, storeConfig.getKeyType(), storeConfig.getValueType(), store);
            this.associateStoreStatsWithPartition(store, partition);
            return partition;
        });
    }

    public void releaseStore(Store<?, ?> resource) {
        AbstractPartition partition = (AbstractPartition)resource;
        this.sharedStorageProvider.releasePartition(partition);
    }

    public void initStore(Store<?, ?> resource) {
    }

    public boolean handlesResourceType(ResourceType<?> resourceType) {
        if (resourceType instanceof ResourceType.SharedResource) {
            return this.sharedStorageProvider.supports(Store.class, ((ResourceType.SharedResource)resourceType).getResourceType());
        }
        return false;
    }

    public PersistableResourceService.PersistenceSpaceIdentifier<?> getPersistenceSpaceIdentifier(String name, ResourcePool resource) throws CachePersistenceException {
        return new SharedPersistentSpaceIdentifier(name, resource);
    }

    public PersistableResourceService.PersistenceSpaceIdentifier<?> getSharedPersistenceSpaceIdentifier(ResourcePool resource) {
        throw new UnsupportedOperationException();
    }

    public void releasePersistenceSpaceIdentifier(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier) throws CachePersistenceException {
        SharedPersistentSpaceIdentifier sharedSpaceIdentifier = (SharedPersistentSpaceIdentifier)identifier;
        if (!sharedSpaceIdentifier.getResource().isPersistent()) {
            ResourceType.SharedResource type = (ResourceType.SharedResource)sharedSpaceIdentifier.getResource().getType();
            this.sharedStorageProvider.destroyPartition(type.getResourceType(), sharedSpaceIdentifier.getName());
        }
    }

    public StateRepository getStateRepositoryWithin(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier, String name) throws CachePersistenceException {
        SharedPersistentSpaceIdentifier sharedSpaceIdentifier = (SharedPersistentSpaceIdentifier)identifier;
        ResourceType.SharedResource type = (ResourceType.SharedResource)sharedSpaceIdentifier.getResource().getType();
        return this.sharedStorageProvider.stateRepository(type.getResourceType(), sharedSpaceIdentifier.getName());
    }

    public void destroy(String name) throws CachePersistenceException {
        this.sharedStorageProvider.destroyPartition(name);
    }

    public void destroyAll() {
    }

    public void startForMaintenance(ServiceProvider<? super MaintainableService> serviceProvider, MaintainableService.MaintenanceScope maintenanceScope) {
        this.start(serviceProvider);
    }

    public static class SharedPersistentSpaceIdentifier
    implements PersistableResourceService.PersistenceSpaceIdentifier<SharedStoreProvider> {
        private final String name;
        private final ResourcePool resource;

        SharedPersistentSpaceIdentifier(String name, ResourcePool resource) {
            this.name = name;
            this.resource = resource;
        }

        public Class<SharedStoreProvider> getServiceType() {
            return SharedStoreProvider.class;
        }

        public String getName() {
            return this.name;
        }

        public ResourcePool getResource() {
            return this.resource;
        }
    }
}

