package org.hibernate.validator.internal.util.logging;

import java.util.Locale;
import java.io.Serializable;
import java.lang.String;

/**
 * Warning this class consists of generated code.
 */
public class Messages_$bundle implements Messages, Serializable {
    private static final long serialVersionUID = 1L;
    protected Messages_$bundle() {}
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String mustNotBeNull0$str() {
        return "must not be null.";
    }
    @Override
    public final String mustNotBeNull() {
        return mustNotBeNull0$str();
    }
    protected String mustNotBeNull1$str() {
        return "%s must not be null.";
    }
    @Override
    public final String mustNotBeNull(final String parameterName) {
        return String.format(getLoggingLocale(), mustNotBeNull1$str(), parameterName);
    }
    protected String parameterMustNotBeNull$str() {
        return "The parameter \"%s\" must not be null.";
    }
    @Override
    public final String parameterMustNotBeNull(final String parameterName) {
        return String.format(getLoggingLocale(), parameterMustNotBeNull$str(), parameterName);
    }
    protected String parameterMustNotBeEmpty$str() {
        return "The parameter \"%s\" must not be empty.";
    }
    @Override
    public final String parameterMustNotBeEmpty(final String parameterName) {
        return String.format(getLoggingLocale(), parameterMustNotBeEmpty$str(), parameterName);
    }
    protected String beanTypeCannotBeNull$str() {
        return "The bean type cannot be null.";
    }
    @Override
    public final String beanTypeCannotBeNull() {
        return beanTypeCannotBeNull$str();
    }
    protected String propertyPathCannotBeNull$str() {
        return "null is not allowed as property path.";
    }
    @Override
    public final String propertyPathCannotBeNull() {
        return propertyPathCannotBeNull$str();
    }
    protected String propertyNameMustNotBeEmpty$str() {
        return "The property name must not be empty.";
    }
    @Override
    public final String propertyNameMustNotBeEmpty() {
        return propertyNameMustNotBeEmpty$str();
    }
    protected String groupMustNotBeNull$str() {
        return "null passed as group name.";
    }
    @Override
    public final String groupMustNotBeNull() {
        return groupMustNotBeNull$str();
    }
    protected String beanTypeMustNotBeNull$str() {
        return "The bean type must not be null when creating a constraint mapping.";
    }
    @Override
    public final String beanTypeMustNotBeNull() {
        return beanTypeMustNotBeNull$str();
    }
    protected String methodNameMustNotBeNull$str() {
        return "The method name must not be null.";
    }
    @Override
    public final String methodNameMustNotBeNull() {
        return methodNameMustNotBeNull$str();
    }
    protected String validatedObjectMustNotBeNull$str() {
        return "The object to be validated must not be null.";
    }
    @Override
    public final String validatedObjectMustNotBeNull() {
        return validatedObjectMustNotBeNull$str();
    }
    protected String validatedMethodMustNotBeNull$str() {
        return "The method to be validated must not be null.";
    }
    @Override
    public final String validatedMethodMustNotBeNull() {
        return validatedMethodMustNotBeNull$str();
    }
    protected String classCannotBeNull$str() {
        return "The class cannot be null.";
    }
    @Override
    public final String classCannotBeNull() {
        return classCannotBeNull$str();
    }
    protected String classIsNull$str() {
        return "Class is null.";
    }
    @Override
    public final String classIsNull() {
        return classIsNull$str();
    }
    protected String validatedConstructorMustNotBeNull$str() {
        return "The constructor to be validated must not be null.";
    }
    @Override
    public final String validatedConstructorMustNotBeNull() {
        return validatedConstructorMustNotBeNull$str();
    }
    protected String validatedParameterArrayMustNotBeNull$str() {
        return "The method parameter array cannot not be null.";
    }
    @Override
    public final String validatedParameterArrayMustNotBeNull() {
        return validatedParameterArrayMustNotBeNull$str();
    }
    protected String validatedConstructorCreatedInstanceMustNotBeNull$str() {
        return "The created instance must not be null.";
    }
    @Override
    public final String validatedConstructorCreatedInstanceMustNotBeNull() {
        return validatedConstructorCreatedInstanceMustNotBeNull$str();
    }
    protected String inputStreamCannotBeNull$str() {
        return "The input stream for #addMapping() cannot be null.";
    }
    @Override
    public final String inputStreamCannotBeNull() {
        return String.format(getLoggingLocale(), inputStreamCannotBeNull$str());
    }
    protected String constraintOnConstructorOfNonStaticInnerClass$str() {
        return "Constraints on the parameters of constructors of non-static inner classes are not supported if those parameters have a generic type due to JDK bug JDK-5087240.";
    }
    @Override
    public final String constraintOnConstructorOfNonStaticInnerClass() {
        return String.format(getLoggingLocale(), constraintOnConstructorOfNonStaticInnerClass$str());
    }
    protected String parameterizedTypesWithMoreThanOneTypeArgument$str() {
        return "Custom parameterized types with more than one type argument are not supported and will not be checked for type use constraints.";
    }
    @Override
    public final String parameterizedTypesWithMoreThanOneTypeArgument() {
        return String.format(getLoggingLocale(), parameterizedTypesWithMoreThanOneTypeArgument$str());
    }
    protected String unableToUseResourceBundleAggregation$str() {
        return "Hibernate Validator cannot instantiate AggregateResourceBundle.CONTROL. This can happen most notably in a Google App Engine environment or when running Hibernate Validator as Java 9 named module. A PlatformResourceBundleLocator without bundle aggregation was created. This only affects you in case you are using multiple ConstraintDefinitionContributor JARs. ConstraintDefinitionContributors are a Hibernate Validator specific feature. All Jakarta Bean Validation features work as expected. See also https://hibernate.atlassian.net/browse/HV-1023.";
    }
    @Override
    public final String unableToUseResourceBundleAggregation() {
        return String.format(getLoggingLocale(), unableToUseResourceBundleAggregation$str());
    }
    protected String annotationTypeMustNotBeNull$str() {
        return "The annotation type must not be null when creating a constraint definition.";
    }
    @Override
    public final String annotationTypeMustNotBeNull() {
        return annotationTypeMustNotBeNull$str();
    }
    protected String annotationTypeMustBeAnnotatedWithConstraint$str() {
        return "The annotation type must be annotated with @jakarta.validation.Constraint when creating a constraint definition.";
    }
    @Override
    public final String annotationTypeMustBeAnnotatedWithConstraint() {
        return annotationTypeMustBeAnnotatedWithConstraint$str();
    }
}
