/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.metadata;

import com.intellij.openapi.Disposable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.config.K2MetadataConfigurationKeys;
import org.jetbrains.kotlin.cli.metadata.K2MetadataKlibSerializer;
import org.jetbrains.kotlin.cli.metadata.MetadataSerializer;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u001a\u0010\u001c\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00170\u001d2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/cli/metadata/K2MetadataCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2MetadataCompilerArguments;", "()V", "performanceManager", "Lorg/jetbrains/kotlin/cli/metadata/K2MetadataCompiler$K2MetadataCompilerPerformanceManager;", "getPerformanceManager", "()Lorg/jetbrains/kotlin/cli/metadata/K2MetadataCompiler$K2MetadataCompilerPerformanceManager;", "createArguments", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "addPlatformOptions", "", "Companion", "K2MetadataCompilerPerformanceManager", "cli"})
public final class K2MetadataCompiler
extends CLICompiler<K2MetadataCompilerArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final K2MetadataCompilerPerformanceManager performanceManager = new K2MetadataCompilerPerformanceManager();

    @Override
    @NotNull
    protected K2MetadataCompilerPerformanceManager getPerformanceManager() {
        return this.performanceManager;
    }

    @Override
    @NotNull
    public K2MetadataCompilerArguments createArguments() {
        return new K2MetadataCompilerArguments();
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2MetadataCompilerArguments arguments2, @NotNull Services services) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        Intrinsics.checkParameterIsNotNull((Object)services, (String)"services");
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $this$addPlatformOptions, @NotNull K2MetadataCompilerArguments arguments2) {
        Intrinsics.checkParameterIsNotNull($this$addPlatformOptions, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2MetadataCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        Object object;
        KotlinCoreEnvironment environment;
        Object[] $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)rootDisposable, (String)"rootDisposable");
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageCollector, (String)"configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector collector2 = messageCollector;
        ExitCode pluginLoadResult = this.loadPlugins(paths, (CommonCompilerArguments)arguments2, configuration);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        Object[] objectArray = arguments2.getCommonSources();
        Object object2 = objectArray == null ? null : ArraysKt.toSet((Object[])objectArray);
        Set commonSources = object2 == null ? SetsKt.emptySet() : object2;
        for (String arg : arguments2.getFreeArgs()) {
            ContentRootsKt.addKotlinSourceRoot(configuration, arg, commonSources.contains(arg));
        }
        if (arguments2.getClasspath() != null) {
            Collection<File> collection;
            void $this$mapTo$iv$iv;
            object2 = arguments2.getClasspath();
            if (object2 == null) {
                Intrinsics.throwNpe();
            }
            CharSequence charSequence = (CharSequence)object2;
            object2 = new char[1];
            object2[0] = File.pathSeparatorChar;
            object2 = StringsKt.split$default((CharSequence)charSequence, (char[])object2, (boolean)false, (int)0, (int)6, null);
            CompilerConfiguration compilerConfiguration = configuration;
            boolean $i$f$map = false;
            Object[] objectArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                File file2 = new File((String)p0);
                collection.add(file2);
            }
            collection = (List)destination$iv$iv;
            JvmContentRootsKt.addJvmClasspathRoots(compilerConfiguration, (List<? extends File>)collection);
        }
        configuration.put(CommonConfigurationKeys.MODULE_NAME, ($this$map$iv = arguments2.getModuleName()) == null ? "main" : $this$map$iv);
        configuration.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        $this$map$iv = arguments2.getFriendPaths();
        configuration.putIfNotNull(K2MetadataConfigurationKeys.INSTANCE.getFRIEND_PATHS(), $this$map$iv == null ? null : ArraysKt.toList((Object[])$this$map$iv));
        $this$map$iv = arguments2.getRefinesPaths();
        configuration.putIfNotNull(K2MetadataConfigurationKeys.INSTANCE.getREFINES_PATHS(), $this$map$iv == null ? null : ArraysKt.toList((Object[])$this$map$iv));
        String destination = arguments2.getDestination();
        if (destination != null) {
            if (StringsKt.endsWith$default((String)destination, (String)".jar", (boolean)false, (int)2, null)) {
                MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.STRONG_WARNING, ".jar destination is not yet supported, results will be written to the directory with the given name", null, 4, null);
            }
            configuration.put(CLIConfigurationKeys.METADATA_DESTINATION_DIRECTORY, new File(destination));
        }
        if ((environment = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.METADATA_CONFIG_FILES)).getSourceFiles().isEmpty()) {
            if (arguments2.getVersion()) {
                return ExitCode.OK;
            }
            MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.ERROR, "No source files", null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        UtilsKt.checkKotlinPackageUsage(environment, (Collection<? extends KtFile>)environment.getSourceFiles());
        try {
            Object metadataVersion;
            BinaryVersion binaryVersion = configuration.get(CommonConfigurationKeys.METADATA_VERSION);
            object = binaryVersion instanceof BuiltInsBinaryVersion ? (BuiltInsBinaryVersion)binaryVersion : null;
            Object object3 = metadataVersion = object == null ? BuiltInsBinaryVersion.INSTANCE : object;
            if (arguments2.getExpectActualLinker()) {
                new K2MetadataKlibSerializer((BuiltInsBinaryVersion)metadataVersion).serialize(environment);
            } else {
                new MetadataSerializer((BuiltInsBinaryVersion)metadataVersion, true).serialize(environment);
            }
        }
        catch (CompilationException e) {
            object = OutputMessageUtil.renderException(e);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"renderException(e)");
            collector2.report(CompilerMessageSeverity.EXCEPTION, (String)object, MessageUtil.psiElementToMessageLocation(e.getElement()));
            return ExitCode.INTERNAL_ERROR;
        }
        return ExitCode.OK;
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc";
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkParameterIsNotNull((Object)versionArray, (String)"versionArray");
        int[] nArray = new int[versionArray.length];
        System.arraycopy(versionArray, 0, nArray, 0, versionArray.length);
        return new BuiltInsBinaryVersion(nArray);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/K2MetadataCompiler$Companion;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "cli"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            CLITool.Companion.doMain(new K2MetadataCompiler(), args);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/K2MetadataCompiler$K2MetadataCompilerPerformanceManager;", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "()V", "cli"})
    protected static final class K2MetadataCompilerPerformanceManager
    extends CommonCompilerPerformanceManager {
        public K2MetadataCompilerPerformanceManager() {
            super("Kotlin to Metadata compiler");
        }
    }
}

