/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.cfg.UnreachableCode;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.PositioningStrategies;
import org.jetbrains.kotlin.diagnostics.PositioningStrategies$VALUE_ARGUMENTS$1$mark$;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolver;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003z{|B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010u\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010v\u001a\n\u0012\u0006\b\u0001\u0012\u00020x0w\"\u00020xH\u0007\u00a2\u0006\u0002\u0010yR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\rR\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u00170\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00108\u001a\b\u0012\u0004\u0012\u0002090\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\rR\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020C0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\rR\u0017\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\rR\u0017\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010\rR\u0017\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\rR\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\rR\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020?0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010\rR\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010]\u001a\b\u0012\u0004\u0012\u00020^0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020^0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00170\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010a\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010b\u001a\b\u0012\u0004\u0012\u00020c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020g0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010h\u001a\b\u0012\u0004\u0012\u00020i0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00170\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010\rR\u0013\u0010l\u001a\u00070m\u00a2\u0006\u0002\bnX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010o\u001a\u00070m\u00a2\u0006\u0002\bnX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010p\u001a\u0004\u0018\u00010q*\n\u0012\u0006\b\u0001\u0012\u00020\u00070r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bs\u0010t\u00a8\u0006}"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies;", "", "()V", "ABSTRACT_MODIFIER", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "ACTUAL_DECLARATION_NAME", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "ARRAY_ACCESS", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "ASSIGNMENT_VALUE", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getASSIGNMENT_VALUE", "()Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "AS_TYPE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "CALL_ELEMENT", "Lcom/intellij/psi/PsiElement;", "CALL_EXPRESSION", "COMPANION_OBJECT", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "CONST_MODIFIER", "CUT_CHAR_QUOTES", "Lorg/jetbrains/kotlin/psi/KtElement;", "DECLARATION_NAME", "DECLARATION_RETURN_TYPE", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "DECLARATION_SIGNATURE", "DECLARATION_SIGNATURE_OR_DEFAULT", "DECLARATION_START_TO_NAME", "DECLARATION_WITH_BODY", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "DEFAULT", "DELEGATOR_SUPER_CALL", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "DOT_BY_QUALIFIED", "getDOT_BY_QUALIFIED", "ELSE_ENTRY", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "FOR_REDECLARATION", "FOR_UNRESOLVED_REFERENCE", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "FUNCTION_PARAMETERS", "Lorg/jetbrains/kotlin/psi/KtFunction;", "FUN_INTERFACE", "FUN_MODIFIER", "IF_EXPRESSION", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "IMPORT_ALIAS", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "INCOMPATIBLE_DECLARATION", "INLINE_OR_VALUE_MODIFIER", "INNER_MODIFIER", "LATEINIT_MODIFIER", "LONG_LITERAL_SUFFIX", "MODALITY_MODIFIER", "NAME_OF_NAMED_ARGUMENT", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT", "NULLABLE_TYPE", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "OPEN_MODIFIER", "OPERATOR", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getOPERATOR", "OVERRIDE_MODIFIER", "PARAMETER_DEFAULT_VALUE", "Lorg/jetbrains/kotlin/psi/KtParameter;", "PARAMETER_VARARG_MODIFIER", "PRIVATE_MODIFIER", "RECEIVER", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "REFERENCED_NAME_BY_QUALIFIED", "getREFERENCED_NAME_BY_QUALIFIED", "REFERENCE_BY_QUALIFIED", "getREFERENCE_BY_QUALIFIED", "REIFIED_MODIFIER", "getREIFIED_MODIFIER", "RESERVED_UNDERSCORE", "getRESERVED_UNDERSCORE", "RETURN_WITH_LABEL", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "SAFE_ACCESS", "SECONDARY_CONSTRUCTOR_DELEGATION_CALL", "SELECTOR_BY_QUALIFIED", "getSELECTOR_BY_QUALIFIED", "SPECIAL_CONSTRUCT_TOKEN", "SUPERTYPES_LIST", "SUSPEND_MODIFIER", "TYPE_PARAMETERS_LIST", "getTYPE_PARAMETERS_LIST", "TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE", "UNREACHABLE_CODE", "UNUSED_VALUE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "USELESS_ELVIS", "VALUE_ARGUMENTS", "VAL_OR_VAR_NODE", "VARIANCE_IN_PROJECTION", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "VARIANCE_MODIFIER", "VISIBILITY_MODIFIER", "WHEN_CONDITION_IN_RANGE", "Lorg/jetbrains/kotlin/psi/KtWhenConditionInRange;", "WHEN_EXPRESSION", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "WHOLE_ELEMENT", "getWHOLE_ELEMENT", "classKindTokens", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "propertyKindTokens", "firstIncompatibility", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectedActualResolver$Compatibility$Incompatible;", "Lorg/jetbrains/kotlin/diagnostics/ParametrizedDiagnostic;", "getFirstIncompatibility", "(Lorg/jetbrains/kotlin/diagnostics/ParametrizedDiagnostic;)Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectedActualResolver$Compatibility$Incompatible;", "modifierSetPosition", "tokens", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "([Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "DeclarationHeader", "FindReferencePositioningStrategy", "ModifierSetBasedPositioningStrategy", "frontend"})
public final class PositioningStrategies {
    @NotNull
    public static final PositioningStrategies INSTANCE = new PositioningStrategies();
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DEFAULT = new PositioningStrategy<PsiElement>(){

        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement psiElement = element;
            if (psiElement instanceof KtObjectLiteralExpression) {
                KtObjectDeclaration ktObjectDeclaration = ((KtObjectLiteralExpression)element).getObjectDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"element.objectDeclaration");
                KtObjectDeclaration objectDeclaration = ktObjectDeclaration;
                PsiElement psiElement2 = objectDeclaration.getObjectKeyword();
                Intrinsics.checkNotNull((Object)psiElement2);
                PsiElement objectKeyword = psiElement2;
                KtSuperTypeList ktSuperTypeList = objectDeclaration.getSuperTypeList();
                if (ktSuperTypeList == null) {
                    return PositioningStrategyKt.markElement(objectKeyword);
                }
                KtSuperTypeList delegationSpecifierList = ktSuperTypeList;
                return PositioningStrategyKt.markRange(objectKeyword, delegationSpecifierList);
            }
            if (psiElement instanceof KtObjectDeclaration) {
                PsiElement psiElement3;
                PsiElement psiElement4 = ((KtObjectDeclaration)element).getObjectKeyword();
                Intrinsics.checkNotNull((Object)psiElement4);
                PsiElement psiElement5 = psiElement4;
                PsiElement psiElement6 = ((KtObjectDeclaration)element).getNameIdentifier();
                if (psiElement6 == null) {
                    PsiElement psiElement7 = ((KtObjectDeclaration)element).getObjectKeyword();
                    Intrinsics.checkNotNull((Object)psiElement7);
                    psiElement3 = psiElement7;
                } else {
                    psiElement3 = psiElement6;
                }
                psiElement4 = psiElement3;
                return PositioningStrategyKt.markRange(psiElement5, psiElement4);
            }
            if (psiElement instanceof KtConstructorDelegationCall) {
                return PositioningStrategies.SECONDARY_CONSTRUCTOR_DELEGATION_CALL.mark(element);
            }
            return super.mark(element);
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SUPERTYPES_LIST = new PositioningStrategy<PsiElement>(){

        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            KtClass ktClass;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            KtClass ktClass2 = ktClass = element instanceof KtClass ? (KtClass)element : null;
            if (ktClass == null) {
                return PositioningStrategyKt.markElement(element);
            }
            List<KtSuperTypeListEntry> supertypes2 = ktClass.getSuperTypeListEntries();
            return supertypes2.isEmpty() ? PositioningStrategyKt.markElement(element) : PositioningStrategyKt.markRange(supertypes2.get(0), (PsiElement)CollectionsKt.last(supertypes2));
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_RETURN_TYPE = new PositioningStrategy<KtDeclaration>(){

        @NotNull
        public List<TextRange> mark(@NotNull KtDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return PositioningStrategyKt.markElement(this.getElementToMark(element));
        }

        public boolean isValid(@NotNull KtDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return !PositioningStrategyKt.hasSyntaxErrors(this.getElementToMark(element));
        }

        private final PsiElement getElementToMark(KtDeclaration declaration2) {
            KtDeclaration ktDeclaration = declaration2;
            Pair pair = ktDeclaration instanceof KtCallableDeclaration ? new Pair((Object)((KtCallableDeclaration)declaration2).getTypeReference(), (Object)((KtCallableDeclaration)declaration2).getNameIdentifier()) : (ktDeclaration instanceof KtPropertyAccessor ? new Pair((Object)((KtPropertyAccessor)declaration2).getReturnTypeReference(), (Object)((KtPropertyAccessor)declaration2).getNamePlaceholder()) : new Pair(null, null));
            KtTypeReference returnTypeRef = (KtTypeReference)pair.component1();
            PsiElement nameIdentifierOrPlaceholder = (PsiElement)pair.component2();
            if (returnTypeRef != null) {
                return returnTypeRef;
            }
            if (nameIdentifierOrPlaceholder != null) {
                return nameIdentifierOrPlaceholder;
            }
            return declaration2;
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> ACTUAL_DECLARATION_NAME = new DeclarationHeader<KtNamedDeclaration>(){

        @NotNull
        public List<TextRange> mark(@NotNull KtNamedDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement nameIdentifier = element.getNameIdentifier();
            return nameIdentifier != null ? PositioningStrategyKt.markElement(nameIdentifier) : (element instanceof KtNamedFunction ? PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element)) : PositioningStrategies.DEFAULT.mark(element));
        }
    };
    @NotNull
    private static final TokenSet propertyKindTokens;
    @NotNull
    private static final TokenSet classKindTokens;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> INCOMPATIBLE_DECLARATION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_START_TO_NAME;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> DECLARATION_NAME;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DECLARATION_SIGNATURE_OR_DEFAULT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> ABSTRACT_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OPEN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OVERRIDE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> PRIVATE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> LATEINIT_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VARIANCE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> CONST_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> FUN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> SUSPEND_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> FOR_REDECLARATION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReferenceExpression> FOR_UNRESOLVED_REFERENCE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtArrayAccessExpression> ARRAY_ACCESS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SAFE_ACCESS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VISIBILITY_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> MODALITY_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INLINE_OR_VALUE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INNER_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeProjection> VARIANCE_IN_PROJECTION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_DEFAULT_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_VARARG_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtValueArgument> NAME_OF_NAMED_ARGUMENT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_ELEMENT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclarationWithBody> DECLARATION_WITH_BODY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> VAL_OR_VAR_NODE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenEntry> ELSE_ENTRY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenExpression> WHEN_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtIfExpression> IF_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenConditionInRange> WHEN_CONDITION_IN_RANGE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtExpression> SPECIAL_CONSTRUCT_TOKEN;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNullableType> NULLABLE_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> VALUE_ARGUMENTS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtFunction> FUNCTION_PARAMETERS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> CUT_CHAR_QUOTES;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> LONG_LITERAL_SUFFIX;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> UNREACHABLE_CODE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpressionWithTypeRHS> AS_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtObjectDeclaration> COMPANION_OBJECT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtEnumEntry> DELEGATOR_SUPER_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> UNUSED_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> USELESS_ELVIS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtImportDirective> IMPORT_ALIAS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReturnExpression> RETURN_WITH_LABEL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtCallableDeclaration> RECEIVER;
    @NotNull
    private static final PositioningStrategy<KtExpression> OPERATOR;
    @NotNull
    private static final PositioningStrategy<PsiElement> DOT_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> SELECTOR_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> RESERVED_UNDERSCORE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> FUN_INTERFACE;
    @NotNull
    private static final PositioningStrategy<PsiElement> REFERENCE_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> REFERENCED_NAME_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<KtModifierListOwner> REIFIED_MODIFIER;
    @NotNull
    private static final PositioningStrategy<KtProperty> ASSIGNMENT_VALUE;
    @NotNull
    private static final PositioningStrategy<KtElement> WHOLE_ELEMENT;
    @NotNull
    private static final PositioningStrategy<KtDeclaration> TYPE_PARAMETERS_LIST;

    private PositioningStrategies() {
    }

    private final ExpectedActualResolver.Compatibility.Incompatible getFirstIncompatibility(ParametrizedDiagnostic<? extends KtNamedDeclaration> $this$firstIncompatibility) {
        Map map;
        DiagnosticFactory<?> diagnosticFactory = $this$firstIncompatibility.getFactory();
        if (Intrinsics.areEqual(diagnosticFactory, Errors.NO_ACTUAL_FOR_EXPECT)) {
            map = (Map)((DiagnosticWithParameters3)Errors.NO_ACTUAL_FOR_EXPECT.cast((UnboundDiagnostic)$this$firstIncompatibility)).getC();
        } else if (Intrinsics.areEqual(diagnosticFactory, Errors.ACTUAL_WITHOUT_EXPECT)) {
            map = (Map)((DiagnosticWithParameters2)Errors.ACTUAL_WITHOUT_EXPECT.cast((UnboundDiagnostic)$this$firstIncompatibility)).getB();
        } else {
            return null;
        }
        Map map2 = map;
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"when (factory) {\n                NO_ACTUAL_FOR_EXPECT ->\n                    NO_ACTUAL_FOR_EXPECT.cast(this).c\n                ACTUAL_WITHOUT_EXPECT ->\n                    ACTUAL_WITHOUT_EXPECT.cast(this).b\n                else ->\n                    return null\n            }");
        Map map3 = map2;
        return (ExpectedActualResolver.Compatibility.Incompatible)CollectionsKt.firstOrNull((Iterable)map3.keySet());
    }

    @JvmStatic
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> modifierSetPosition(KtModifierKeywordToken ... tokens) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        return new PositioningStrategy<KtModifierListOwner>(tokens){
            final /* synthetic */ KtModifierKeywordToken[] $tokens;
            {
                this.$tokens = $tokens;
            }

            @NotNull
            public List<TextRange> mark(@NotNull KtModifierListOwner element) {
                Object[] objectArray;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Object[] $this$sure$iv = element.getModifierList();
                boolean $i$f$sure = false;
                Object[] objectArray2 = $this$sure$iv;
                if (objectArray2 == null) {
                    String string2;
                    boolean bl = false;
                    String string3 = string2 = "No modifier list, but modifier has been found by the analyzer";
                    throw new AssertionError((Object)string3);
                }
                Object[] modifierList2 = objectArray = objectArray2;
                for (KtModifierKeywordToken token : this.$tokens) {
                    PsiElement modifier = modifierList2.getModifier(token);
                    if (modifier == null) continue;
                    return PositioningStrategyKt.markElement(modifier);
                }
                objectArray = new KtModifierKeywordToken[this.$tokens.length];
                System.arraycopy(this.$tokens, 0, objectArray, 0, this.$tokens.length);
                throw new IllegalStateException(Intrinsics.stringPlus((String)"None of the modifiers is found: ", (Object)CollectionsKt.listOf((Object[])objectArray)));
            }
        };
    }

    @NotNull
    public final PositioningStrategy<KtExpression> getOPERATOR() {
        return OPERATOR;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getDOT_BY_QUALIFIED() {
        return DOT_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getSELECTOR_BY_QUALIFIED() {
        return SELECTOR_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getRESERVED_UNDERSCORE() {
        return RESERVED_UNDERSCORE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getREFERENCE_BY_QUALIFIED() {
        return REFERENCE_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getREFERENCED_NAME_BY_QUALIFIED() {
        return REFERENCED_NAME_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<KtModifierListOwner> getREIFIED_MODIFIER() {
        return REIFIED_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<KtProperty> getASSIGNMENT_VALUE() {
        return ASSIGNMENT_VALUE;
    }

    @NotNull
    public final PositioningStrategy<KtElement> getWHOLE_ELEMENT() {
        return WHOLE_ELEMENT;
    }

    @NotNull
    public final PositioningStrategy<KtDeclaration> getTYPE_PARAMETERS_LIST() {
        return TYPE_PARAMETERS_LIST;
    }

    public static final /* synthetic */ ExpectedActualResolver.Compatibility.Incompatible access$getFirstIncompatibility(PositioningStrategies $this, ParametrizedDiagnostic $receiver) {
        return $this.getFirstIncompatibility($receiver);
    }

    public static final /* synthetic */ TokenSet access$getClassKindTokens$p() {
        return classKindTokens;
    }

    public static final /* synthetic */ TokenSet access$getPropertyKindTokens$p() {
        return propertyKindTokens;
    }

    static {
        Object object = new IElementType[]{KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD};
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = TokenSet.create(object);
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordTokenArray, (String)"create(KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD)");
        propertyKindTokens = ktModifierKeywordTokenArray;
        object = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        ktModifierKeywordTokenArray = TokenSet.create(object);
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordTokenArray, (String)"create(KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD, KtTokens.INTERFACE_KEYWORD)");
        classKindTokens = ktModifierKeywordTokenArray;
        INCOMPATIBLE_DECLARATION = new DeclarationHeader<KtNamedDeclaration>(){

            @NotNull
            public List<TextRange> markDiagnostic(@NotNull ParametrizedDiagnostic<? extends KtNamedDeclaration> diagnostic) {
                List<TextRange> list2;
                UserDataHolder userDataHolder;
                PsiElement psiElement;
                PsiElement psiElement2;
                ExpectedActualResolver.Compatibility.Incompatible incompatibility;
                Intrinsics.checkNotNullParameter(diagnostic, (String)"diagnostic");
                KtNamedDeclaration element = diagnostic.getPsiElement();
                KtCallableDeclaration callableDeclaration = element instanceof KtCallableDeclaration ? (KtCallableDeclaration)element : null;
                ExpectedActualResolver.Compatibility.Incompatible incompatible = incompatibility = PositioningStrategies.access$getFirstIncompatibility(PositioningStrategies.INSTANCE, diagnostic);
                if (((incompatible == null ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.Unknown.INSTANCE)) ? true : incompatible instanceof ExpectedActualResolver.Compatibility.Incompatible.ClassScopes) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.EnumEntries.INSTANCE)) {
                    psiElement2 = null;
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ClassKind.INSTANCE)) {
                    PsiElement endElement;
                    PsiElement psiElement3 = element.getModifierList();
                    PsiElement psiElement4 = psiElement = psiElement3 == null ? null : psiElement3.getModifier(KtTokens.ENUM_KEYWORD);
                    PsiElement startElement = psiElement == null ? ((psiElement3 = element.getModifierList()) == null ? null : psiElement3.getModifier(KtTokens.ANNOTATION_KEYWORD)) : psiElement;
                    ASTNode aSTNode = element.getNode().findChildByType(PositioningStrategies.access$getClassKindTokens$p());
                    psiElement3 = aSTNode == null ? null : aSTNode.getPsi();
                    PsiElement psiElement5 = endElement = psiElement3 == null ? element.getNameIdentifier() : psiElement3;
                    if (startElement != null && endElement != null) {
                        return PositioningStrategyKt.markRange(startElement, endElement);
                    }
                    psiElement2 = endElement;
                } else if ((((Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.TypeParameterNames.INSTANCE) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.TypeParameterCount.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.TypeParameterUpperBounds.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.TypeParameterVariance.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.TypeParameterReified.INSTANCE)) {
                    userDataHolder = element instanceof KtTypeParameterListOwner ? (KtTypeParameterListOwner)element : null;
                    psiElement2 = userDataHolder == null ? null : userDataHolder.getTypeParameterList();
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.CallableKind.INSTANCE)) {
                    psiElement = callableDeclaration instanceof KtNamedFunction ? (KtNamedFunction)callableDeclaration : null;
                    UserDataHolder userDataHolder2 = userDataHolder = psiElement == null ? null : ((KtNamedFunction)psiElement).getFunKeyword();
                    if (userDataHolder == null) {
                        PsiElement psiElement6 = psiElement = callableDeclaration instanceof KtProperty ? (KtProperty)callableDeclaration : null;
                        psiElement2 = psiElement == null ? null : ((KtProperty)psiElement).getValOrVarKeyword();
                    } else {
                        psiElement2 = userDataHolder;
                    }
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ParameterShape.INSTANCE)) {
                    KtElementImplStub ktElementImplStub;
                    userDataHolder = callableDeclaration;
                    if (userDataHolder == null) {
                        ktElementImplStub = null;
                    } else {
                        psiElement = userDataHolder;
                        boolean bl = false;
                        boolean bl2 = false;
                        PsiElement it = psiElement;
                        boolean bl3 = false;
                        KtTypeReference ktTypeReference = it.getReceiverTypeReference();
                        ktElementImplStub = ktTypeReference == null ? (KtElementImplStub)it.getValueParameterList() : (KtElementImplStub)ktTypeReference;
                    }
                    psiElement2 = ktElementImplStub;
                } else if (((((Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ParameterCount.INSTANCE) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ParameterTypes.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ParameterNames.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ValueParameterVararg.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ValueParameterNoinline.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ValueParameterCrossinline.INSTANCE)) {
                    userDataHolder = callableDeclaration;
                    psiElement2 = userDataHolder == null ? null : userDataHolder.getValueParameterList();
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ReturnType.INSTANCE)) {
                    userDataHolder = callableDeclaration;
                    psiElement2 = userDataHolder == null ? null : userDataHolder.getTypeReference();
                } else if (((Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.FunctionModifiersDifferent.INSTANCE) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.FunctionModifiersNotSubset.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.PropertyModifiers.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ClassModifiers.INSTANCE)) {
                    psiElement2 = element.getModifierList();
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.PropertyKind.INSTANCE)) {
                    userDataHolder = element.getNode().findChildByType(PositioningStrategies.access$getPropertyKindTokens$p());
                    psiElement2 = userDataHolder == null ? null : userDataHolder.getPsi();
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.Supertypes.INSTANCE)) {
                    userDataHolder = element instanceof KtClassOrObject ? (KtClassOrObject)element : null;
                    psiElement2 = userDataHolder == null ? null : ((KtClassOrObject)userDataHolder).getSuperTypeList();
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.Modality.INSTANCE)) {
                    psiElement2 = KtPsiUtilKt.modalityModifier(element);
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.Visibility.INSTANCE)) {
                    psiElement2 = KtPsiUtilKt.visibilityModifier(element);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                PsiElement psiElement7 = psiElement2;
                if (psiElement7 == null) {
                    list2 = null;
                } else {
                    incompatible = psiElement7;
                    boolean bl = false;
                    boolean bl4 = false;
                    ExpectedActualResolver.Compatibility.Incompatible it = incompatible;
                    boolean bl5 = false;
                    list2 = PositioningStrategyKt.markElement((PsiElement)((Object)it));
                }
                List<TextRange> list3 = list2;
                return list3 == null ? PositioningStrategies.ACTUAL_DECLARATION_NAME.mark((KtNamedDeclaration)((PsiElement)element)) : list3;
            }
        };
        DECLARATION_START_TO_NAME = new DeclarationHeader<KtDeclaration>(){

            private final PsiElement firstNonCommentNonAnnotationLeaf(PsiElement $this$firstNonCommentNonAnnotationLeaf) {
                PsiElement leaf;
                PsiElement psiElement = $this$firstNonCommentNonAnnotationLeaf.getFirstChild();
                if (psiElement == null) {
                    return $this$firstNonCommentNonAnnotationLeaf;
                }
                PsiElement child = psiElement;
                while (true) {
                    if (child instanceof PsiComment || child instanceof PsiWhiteSpace || child instanceof KtAnnotationEntry) {
                        child = child.getNextSibling();
                        continue;
                    }
                    if (child == null) {
                        return null;
                    }
                    leaf = this.firstNonCommentNonAnnotationLeaf(child);
                    if (leaf != null) break;
                    child = child.getNextSibling();
                }
                return leaf;
            }

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                PsiElement psiElement;
                PsiElement psiElement2;
                PsiElement nameIdentifier;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement3 = this.firstNonCommentNonAnnotationLeaf(element);
                PsiElement startElement = psiElement3 == null ? (PsiElement)element : psiElement3;
                KtDeclaration ktDeclaration = element instanceof KtNamedDeclaration ? (KtNamedDeclaration)element : null;
                PsiElement psiElement4 = nameIdentifier = ktDeclaration == null ? null : ktDeclaration.getNameIdentifier();
                return nameIdentifier != null ? PositioningStrategyKt.markRange(startElement, nameIdentifier) : ((ktDeclaration = element) instanceof KtConstructor ? PositioningStrategyKt.markRange(startElement, (psiElement2 = ((KtConstructor)element).getConstructorKeyword()) == null ? (PsiElement)element : psiElement2) : (ktDeclaration instanceof KtObjectDeclaration ? PositioningStrategyKt.markRange(startElement, (psiElement = ((KtObjectDeclaration)element).getObjectKeyword()) == null ? (PsiElement)element : psiElement) : PositioningStrategies.DEFAULT.mark(element)));
            }
        };
        DECLARATION_NAME = new DeclarationHeader<KtNamedDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNamedDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement nameIdentifier = element.getNameIdentifier();
                if (nameIdentifier != null) {
                    if (element instanceof KtClassOrObject) {
                        Object object;
                        Object object2;
                        Object object3;
                        UserDataHolder userDataHolder = element.getModifierList();
                        Object object4 = object3 = userDataHolder == null ? null : ((KtModifierList)userDataHolder).getModifier(KtTokens.ENUM_KEYWORD);
                        if (object3 == null) {
                            Object object5 = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD};
                            userDataHolder = ((KtClassOrObject)element).getNode().findChildByType(TokenSet.create((IElementType[])object5));
                            object2 = userDataHolder == null ? (PsiElement)element : ((object5 = userDataHolder.getPsi()) == null ? (PsiElement)element : object5);
                        } else {
                            object2 = object3;
                        }
                        Object startElement = object = object2;
                        return PositioningStrategyKt.markRange((PsiElement)startElement, nameIdentifier);
                    }
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                if (element instanceof KtNamedFunction) {
                    return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element));
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        DECLARATION_SIGNATURE = new DeclarationHeader<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtConstructor) {
                    PsiElement psiElement;
                    PsiElement psiElement2;
                    PsiElement psiElement3;
                    PsiElement psiElement4 = ((KtConstructor)element).getConstructorKeyword();
                    if (psiElement4 == null) {
                        psiElement3 = ((KtConstructor)element).getValueParameterList();
                        if (psiElement3 == null) {
                            return PositioningStrategyKt.markElement(element);
                        }
                        psiElement2 = psiElement3;
                    } else {
                        psiElement2 = psiElement4;
                    }
                    PsiElement begin = psiElement2;
                    psiElement3 = ((KtConstructor)element).getValueParameterList();
                    if (psiElement3 == null) {
                        PsiElement psiElement5 = ((KtConstructor)element).getConstructorKeyword();
                        if (psiElement5 == null) {
                            return PositioningStrategyKt.markElement(element);
                        }
                        psiElement = psiElement5;
                    } else {
                        psiElement = psiElement3;
                    }
                    PsiElement end = psiElement;
                    return PositioningStrategyKt.markRange(begin, end);
                }
                if (ktDeclaration instanceof KtFunction) {
                    PsiElement end;
                    KtElementImplStub ktElementImplStub;
                    PsiElement psiElement = ((KtFunction)element).getTypeReference();
                    KtElementImplStub ktElementImplStub2 = ktElementImplStub = psiElement == null ? (KtElementImplStub)((KtFunction)element).getValueParameterList() : (KtElementImplStub)psiElement;
                    PsiElement endOfSignatureElement = end = ktElementImplStub == null ? ((psiElement = ((KtFunction)element).getNameIdentifier()) == null ? (PsiElement)element : psiElement) : (PsiElement)ktElementImplStub;
                    KtElement startElement = element instanceof KtFunctionLiteral ? (KtElement)((ktElementImplStub = ((KtFunction)element).getReceiverTypeReference()) == null ? ((psiElement = (KtElementImplStub)((KtFunction)element).getValueParameterList()) == null ? (NavigatablePsiElement)element : (NavigatablePsiElement)psiElement) : (NavigatablePsiElement)ktElementImplStub) : (KtElement)element;
                    return PositioningStrategyKt.markRange(startElement, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtProperty) {
                    PsiElement psiElement;
                    PsiElement startElement;
                    KtTypeReference ktTypeReference = ((KtProperty)element).getTypeReference();
                    PsiElement endOfSignatureElement = startElement = ktTypeReference == null ? ((psiElement = ((KtProperty)element).getNameIdentifier()) == null ? (PsiElement)element : psiElement) : (PsiElement)ktTypeReference;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtPropertyAccessor) {
                    PsiElement psiElement;
                    KtTypeReference ktTypeReference = ((KtPropertyAccessor)element).getReturnTypeReference();
                    PsiElement startElement = ktTypeReference == null ? ((psiElement = ((KtPropertyAccessor)element).getRightParenthesis()) == null ? ((KtPropertyAccessor)element).getNamePlaceholder() : psiElement) : (PsiElement)ktTypeReference;
                    Intrinsics.checkNotNullExpressionValue((Object)startElement, (String)"element.returnTypeReference\n                            ?: element.rightParenthesis\n                            ?: element.namePlaceholder");
                    PsiElement endOfSignatureElement = startElement;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtClass) {
                    PsiElement startElement;
                    PsiElement psiElement = ((KtClass)element).getNameIdentifier();
                    if (psiElement == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement nameAsDeclaration = startElement = psiElement;
                    psiElement = ((KtClass)element).getPrimaryConstructorParameterList();
                    if (psiElement == null) {
                        return PositioningStrategyKt.markElement(nameAsDeclaration);
                    }
                    PsiElement primaryConstructorParameterList = psiElement;
                    return PositioningStrategyKt.markRange(nameAsDeclaration, primaryConstructorParameterList);
                }
                if (ktDeclaration instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DECLARATION_NAME.mark((KtNamedDeclaration)element);
                }
                if (ktDeclaration instanceof KtClassInitializer) {
                    TextRange textRange = ((KtClassInitializer)element).getInitKeyword().getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.initKeyword.textRange");
                    return PositioningStrategyKt.markRange(textRange);
                }
                return super.mark((PsiElement)element);
            }
        };
        DECLARATION_SIGNATURE_OR_DEFAULT = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return element instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)element) : PositioningStrategies.DEFAULT.mark(element);
            }

            public boolean isValid(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return element instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.isValid((KtDeclaration)element) : PositioningStrategies.DEFAULT.isValid(element);
            }
        };
        NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtClassOrObject) {
                    PsiElement psiElement2;
                    PsiElement psiElement3 = ((KtClassOrObject)element).getDeclarationKeyword();
                    psiElement = psiElement3 == null ? ((psiElement2 = ((KtClassOrObject)element).getNameIdentifier()) == null ? (PsiElement)element : psiElement2) : psiElement3;
                } else if (ktDeclaration instanceof KtNamedFunction) {
                    PsiElement psiElement4;
                    PsiElement psiElement5;
                    PsiElement psiElement6 = ((KtNamedFunction)element).getModifierList();
                    PsiElement psiElement7 = psiElement5 = psiElement6 == null ? null : psiElement6.getModifier(KtTokens.INLINE_KEYWORD);
                    psiElement = psiElement4 = psiElement5 == null ? ((psiElement6 = ((KtNamedFunction)element).getFunKeyword()) == null ? (PsiElement)element : psiElement6) : psiElement5;
                } else {
                    psiElement = element;
                }
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                KtTypeParameterList jetTypeParameterList;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtTypeParameterListOwner && (jetTypeParameterList = ((KtTypeParameterListOwner)element).getTypeParameterList()) != null) {
                    return PositioningStrategyKt.markElement(jetTypeParameterList);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element));
            }
        };
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        ABSTRACT_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"OPEN_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        OPEN_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"OVERRIDE_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        OVERRIDE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        PRIVATE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.LATEINIT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"LATEINIT_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        LATEINIT_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[2];
        object = KtTokens.IN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"IN_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        object = KtTokens.OUT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"OUT_KEYWORD");
        ktModifierKeywordTokenArray[1] = object;
        VARIANCE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.CONST_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CONST_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        CONST_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.FUN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"FUN_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        FUN_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.SUSPEND_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SUSPEND_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        SUSPEND_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        FOR_REDECLARATION = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                PsiElement nameIdentifier;
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement2 = element;
                if (psiElement2 instanceof KtNamedDeclaration) {
                    psiElement = ((KtNamedDeclaration)element).getNameIdentifier();
                } else if (psiElement2 instanceof KtFile) {
                    KtPackageDirective ktPackageDirective = ((KtFile)element).getPackageDirective();
                    Intrinsics.checkNotNull((Object)ktPackageDirective);
                    psiElement = ktPackageDirective.getNameIdentifier();
                } else {
                    psiElement = nameIdentifier = null;
                }
                if (nameIdentifier == null && element instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DEFAULT.mark(element);
                }
                psiElement2 = nameIdentifier;
                return PositioningStrategyKt.markElement(psiElement2 == null ? element : psiElement2);
            }
        };
        FOR_UNRESOLVED_REFERENCE = new PositioningStrategy<KtReferenceExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtReferenceExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtArrayAccessExpression) {
                    List<TextRange> list2 = ((KtArrayAccessExpression)element).getBracketRanges();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"element.bracketRanges");
                    List<TextRange> ranges2 = list2;
                    if (!ranges2.isEmpty()) {
                        return ranges2;
                    }
                }
                return CollectionsKt.listOf((Object)element.getTextRange());
            }
        };
        ARRAY_ACCESS = new PositioningStrategy<KtArrayAccessExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtArrayAccessExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtContainerNode ktContainerNode = element.getIndicesNode();
                Intrinsics.checkNotNullExpressionValue((Object)ktContainerNode, (String)"element.indicesNode");
                return PositioningStrategyKt.markElement(ktContainerNode);
            }
        };
        SAFE_ACCESS = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                ASTNode aSTNode = element.getNode().findChildByType(KtTokens.SAFE_ACCESS);
                return PositioningStrategyKt.markElement(aSTNode == null ? element : ((psiElement = aSTNode.getPsi()) == null ? element : psiElement));
            }
        };
        ktModifierKeywordTokenArray = KtTokens.VISIBILITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordTokenArray, (String)"VISIBILITY_MODIFIERS");
        VISIBILITY_MODIFIER = new ModifierSetBasedPositioningStrategy((TokenSet)ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = KtTokens.MODALITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordTokenArray, (String)"MODALITY_MODIFIERS");
        MODALITY_MODIFIER = new ModifierSetBasedPositioningStrategy((TokenSet)ktModifierKeywordTokenArray);
        object = new IElementType[]{KtTokens.INLINE_KEYWORD, KtTokens.VALUE_KEYWORD};
        ktModifierKeywordTokenArray = TokenSet.create(object);
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordTokenArray, (String)"create(KtTokens.INLINE_KEYWORD, KtTokens.VALUE_KEYWORD)");
        INLINE_OR_VALUE_MODIFIER = new ModifierSetBasedPositioningStrategy((TokenSet)ktModifierKeywordTokenArray);
        object = new IElementType[]{KtTokens.INNER_KEYWORD};
        ktModifierKeywordTokenArray = TokenSet.create(object);
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordTokenArray, (String)"create(KtTokens.INNER_KEYWORD)");
        INNER_MODIFIER = new ModifierSetBasedPositioningStrategy((TokenSet)ktModifierKeywordTokenArray);
        VARIANCE_IN_PROJECTION = new PositioningStrategy<KtTypeProjection>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtTypeProjection element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getProjectionToken();
                Intrinsics.checkNotNull((Object)psiElement);
                PsiElement psiElement2 = psiElement;
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        PARAMETER_DEFAULT_VALUE = new PositioningStrategy<KtParameter>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtParameter element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtExpression ktExpression = element.getDefaultValue();
                Intrinsics.checkNotNull((Object)ktExpression);
                ASTNode aSTNode = ktExpression.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.defaultValue!!.node");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        PARAMETER_VARARG_MODIFIER = new PositioningStrategy<KtParameter>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtParameter element) {
                UserDataHolder userDataHolder;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtModifierList ktModifierList = element.getModifierList();
                Intrinsics.checkNotNull((Object)ktModifierList);
                PsiElement psiElement = ktModifierList.getModifier(KtTokens.VARARG_KEYWORD);
                Intrinsics.checkNotNull((Object)psiElement);
                PsiElement varargModifier = userDataHolder = psiElement;
                userDataHolder = varargModifier.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)userDataHolder, (String)"varargModifier.node");
                return PositioningStrategyKt.markNode((ASTNode)userDataHolder);
            }
        };
        NAME_OF_NAMED_ARGUMENT = new PositioningStrategy<KtValueArgument>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtValueArgument element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtValueArgumentName ktValueArgumentName = element.getArgumentName();
                return PositioningStrategyKt.markElement(ktValueArgumentName == null ? (KtElementImplStub)element : (KtElementImplStub)ktValueArgumentName);
            }
        };
        CALL_ELEMENT = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                KtExpression ktExpression;
                KtCallElement ktCallElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtCallElement ktCallElement2 = ktCallElement = element instanceof KtCallElement ? (KtCallElement)element : null;
                return PositioningStrategyKt.markElement(ktCallElement == null ? element : ((ktExpression = ktCallElement.getCalleeExpression()) == null ? element : (PsiElement)ktExpression));
            }
        };
        DECLARATION_WITH_BODY = new PositioningStrategy<KtDeclarationWithBody>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclarationWithBody element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtBlockExpression ktBlockExpression = element.getBodyBlockExpression();
                TextRange lastBracketRange = ktBlockExpression == null ? null : ktBlockExpression.getLastBracketRange();
                return lastBracketRange != null ? PositioningStrategyKt.markRange(lastBracketRange) : PositioningStrategyKt.markElement(element);
            }

            public boolean isValid(@NotNull KtDeclarationWithBody element) {
                KtBlockExpression ktBlockExpression;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return super.isValid((PsiElement)element) && ((ktBlockExpression = element.getBodyBlockExpression()) == null ? null : ktBlockExpression.getLastBracketRange()) != null;
            }
        };
        VAL_OR_VAR_NODE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtParameter) {
                    PsiElement psiElement = ((KtParameter)element).getValOrVarKeyword();
                    PsiElement psiElement2 = psiElement == null ? (PsiElement)element : psiElement;
                    list2 = PositioningStrategyKt.markElement(psiElement2);
                } else if (ktDeclaration instanceof KtProperty) {
                    PsiElement psiElement = ((KtProperty)element).getValOrVarKeyword();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.valOrVarKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktDeclaration instanceof KtDestructuringDeclaration) {
                    PsiElement psiElement = ((KtDestructuringDeclaration)element).getValOrVarKeyword();
                    PsiElement psiElement3 = psiElement == null ? (PsiElement)element : psiElement;
                    list2 = PositioningStrategyKt.markElement(psiElement3);
                } else {
                    String string2 = Intrinsics.stringPlus((String)"Declaration is neither a parameter nor a property: ", (Object)PsiUtilsKt.getElementTextWithContext(element));
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                return list2;
            }
        };
        ELSE_ENTRY = new PositioningStrategy<KtWhenEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenEntry element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getElseKeyword();
                Intrinsics.checkNotNull((Object)psiElement);
                PsiElement psiElement2 = psiElement;
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        WHEN_EXPRESSION = new PositioningStrategy<KtWhenExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getWhenKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.whenKeyword");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        IF_EXPRESSION = new PositioningStrategy<KtIfExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtIfExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getIfKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.ifKeyword");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHEN_CONDITION_IN_RANGE = new PositioningStrategy<KtWhenConditionInRange>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenConditionInRange element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtOperationReferenceExpression ktOperationReferenceExpression = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"element.operationReference");
                return PositioningStrategyKt.markElement(ktOperationReferenceExpression);
            }
        };
        SPECIAL_CONSTRUCT_TOKEN = new PositioningStrategy<KtExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtExpression element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtExpression ktExpression = element;
                if (ktExpression instanceof KtWhenExpression) {
                    PsiElement psiElement = ((KtWhenExpression)element).getWhenKeyword();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.whenKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktExpression instanceof KtIfExpression) {
                    PsiElement psiElement = ((KtIfExpression)element).getIfKeyword();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.ifKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktExpression instanceof KtOperationExpression) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KtOperationExpression)element).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"element.operationReference");
                    list2 = PositioningStrategyKt.markElement(ktSimpleNameExpression);
                } else {
                    String string2 = Intrinsics.stringPlus((String)"Expression is not an if, when or operation expression: ", (Object)PsiUtilsKt.getElementTextWithContext(element));
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                return list2;
            }
        };
        NULLABLE_TYPE = new PositioningStrategy<KtNullableType>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNullableType element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                ASTNode aSTNode = element.getQuestionMarkNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.questionMarkNode");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        CALL_EXPRESSION = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtCallExpression) {
                    KtElement ktElement;
                    KtTypeArgumentList ktTypeArgumentList = ((KtCallExpression)element).getTypeArgumentList();
                    return PositioningStrategyKt.markRange(element, ktTypeArgumentList == null ? ((ktElement = (KtElement)((KtCallExpression)element).getCalleeExpression()) == null ? (KtElement)element : ktElement) : (KtElement)ktTypeArgumentList);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        VALUE_ARGUMENTS = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement $this$findDescendantOfType_u24default$iv = element;
                Function1 predicate$iv = VALUE_ARGUMENTS$1$mark$$inlined$findDescendantOfType$default$1.INSTANCE;
                boolean $i$f$findDescendantOfType = false;
                PsiElement $this$findDescendantOfType$iv$iv = $this$findDescendantOfType_u24default$iv;
                boolean $i$f$findDescendantOfType2 = false;
                Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
                $this$findDescendantOfType$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                    final /* synthetic */ Function1 $predicate;
                    final /* synthetic */ Ref.ObjectRef $result;
                    {
                        this.$predicate = $predicate;
                        this.$result = $result;
                    }

                    public void visitElement(@NotNull PsiElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        if (element instanceof KtValueArgumentList && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                            this.$result.element = element;
                            this.stopWalking();
                            return;
                        }
                        PsiElement it = element;
                        boolean bl = false;
                        super.visitElement(element);
                    }
                });
                KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)((PsiElement)result$iv$iv.element);
                PsiElement psiElement2 = ktValueArgumentList == null ? (PsiElement)element : ((psiElement = ktValueArgumentList.getRightParenthesis()) == null ? (PsiElement)element : psiElement);
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        FUNCTION_PARAMETERS = new PositioningStrategy<KtFunction>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtFunction element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtParameterList valueParameterList = element.getValueParameterList();
                if (valueParameterList != null) {
                    return PositioningStrategyKt.markElement(valueParameterList);
                }
                if (element instanceof KtFunctionLiteral) {
                    ASTNode aSTNode = ((KtFunctionLiteral)element).getLBrace().getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.lBrace.node");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE_OR_DEFAULT.mark(element);
            }
        };
        CUT_CHAR_QUOTES = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtConstantExpression && Intrinsics.areEqual((Object)((KtConstantExpression)element).getNode().getElementType(), (Object)KtNodeTypes.CHARACTER_CONSTANT)) {
                    TextRange elementTextRange = element.getTextRange();
                    TextRange textRange = TextRange.create(elementTextRange.getStartOffset() + 1, elementTextRange.getEndOffset() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(elementTextRange.startOffset + 1, elementTextRange.endOffset - 1)");
                    return CollectionsKt.listOf((Object)textRange);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        LONG_LITERAL_SUFFIX = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtConstantExpression && Intrinsics.areEqual((Object)((KtConstantExpression)element).getNode().getElementType(), (Object)KtNodeTypes.INTEGER_CONSTANT)) {
                    int endOffset = PsiUtilsKt.getEndOffset(element);
                    TextRange textRange = TextRange.create(endOffset - 1, endOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(endOffset - 1, endOffset)");
                    return CollectionsKt.listOf((Object)textRange);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        UNREACHABLE_CODE = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> markDiagnostic(@NotNull ParametrizedDiagnostic<? extends PsiElement> diagnostic) {
                Intrinsics.checkNotNullParameter(diagnostic, (String)"diagnostic");
                DiagnosticWithParameters2 unreachableCode = (DiagnosticWithParameters2)Errors.UNREACHABLE_CODE.cast((UnboundDiagnostic)diagnostic);
                Object object = unreachableCode.getPsiElement();
                Intrinsics.checkNotNullExpressionValue(object, (String)"unreachableCode.psiElement");
                KtElement ktElement = (KtElement)object;
                object = unreachableCode.getA();
                Intrinsics.checkNotNullExpressionValue(object, (String)"unreachableCode.a");
                Set set = (Set)object;
                object = unreachableCode.getB();
                Intrinsics.checkNotNullExpressionValue(object, (String)"unreachableCode.b");
                return UnreachableCode.Companion.getUnreachableTextRanges(ktElement, set, (Set)object);
            }
        };
        AS_TYPE = new PositioningStrategy<KtBinaryExpressionWithTypeRHS>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpressionWithTypeRHS element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtSimpleNameExpression ktSimpleNameExpression = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"element.operationReference");
                return PositioningStrategyKt.markRange(ktSimpleNameExpression, element);
            }
        };
        COMPANION_OBJECT = new PositioningStrategy<KtObjectDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtObjectDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element.hasModifier(KtTokens.COMPANION_KEYWORD)) {
                    KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.COMPANION_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"COMPANION_KEYWORD");
                    ktModifierKeywordTokenArray[0] = ktModifierKeywordToken;
                    return PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray).mark((KtModifierListOwner)((PsiElement)element));
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element;
                if (psiElement instanceof KtSecondaryConstructor) {
                    PsiElement psiElement2 = ((KtSecondaryConstructor)element).getValueParameterList();
                    if (psiElement2 == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    KtParameterList valueParameterList = psiElement2;
                    PsiElement psiElement3 = ((KtSecondaryConstructor)element).getConstructorKeyword();
                    psiElement2 = valueParameterList.getLastChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"valueParameterList.lastChild");
                    list2 = PositioningStrategyKt.markRange(psiElement3, psiElement2);
                } else if (psiElement instanceof KtConstructorDelegationCall) {
                    if (((KtConstructorDelegationCall)element).isImplicit()) {
                        PsiElement $this$getStrictParentOfType$iv = element;
                        boolean $i$f$getStrictParentOfType = false;
                        KtSecondaryConstructor ktSecondaryConstructor = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtSecondaryConstructor.class, true);
                        Intrinsics.checkNotNull((Object)ktSecondaryConstructor);
                        KtSecondaryConstructor constructor2 = ktSecondaryConstructor;
                        PsiElement psiElement4 = constructor2.getValueParameterList();
                        if (psiElement4 == null) {
                            return PositioningStrategyKt.markElement(constructor2);
                        }
                        KtParameterList valueParameterList = psiElement4;
                        PsiElement psiElement5 = constructor2.getConstructorKeyword();
                        psiElement4 = valueParameterList.getLastChild();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"valueParameterList.lastChild");
                        return PositioningStrategyKt.markRange(psiElement5, psiElement4);
                    }
                    KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = ((KtConstructorDelegationCall)element).getCalleeExpression();
                    list2 = PositioningStrategyKt.markElement(ktConstructorDelegationReferenceExpression == null ? (KtElementImpl)element : (KtElementImpl)ktConstructorDelegationReferenceExpression);
                } else {
                    list2 = PositioningStrategyKt.markElement(element);
                }
                return list2;
            }
        };
        DELEGATOR_SUPER_CALL = new PositioningStrategy<KtEnumEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtEnumEntry element) {
                KtElementImplStub ktElementImplStub;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Object object = element.getSuperTypeListEntries();
                Intrinsics.checkNotNullExpressionValue(object, (String)"element.superTypeListEntries");
                List<KtSuperTypeListEntry> specifiers = object;
                if (specifiers.isEmpty()) {
                    ktElementImplStub = element;
                } else {
                    object = specifiers.get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"specifiers[0]");
                    ktElementImplStub = (KtElementImplStub)object;
                }
                return PositioningStrategyKt.markElement(ktElementImplStub);
            }
        };
        UNUSED_VALUE = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtExpression ktExpression = element.getLeft();
                Intrinsics.checkNotNull((Object)ktExpression);
                KtExpression ktExpression2 = ktExpression;
                int n = PsiUtilsKt.getStartOffset(ktExpression2);
                ktExpression2 = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"element.operationReference");
                return CollectionsKt.listOf((Object)new TextRange(n, PsiUtilsKt.getEndOffset(ktExpression2)));
            }
        };
        USELESS_ELVIS = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtOperationReferenceExpression ktOperationReferenceExpression = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"element.operationReference");
                return CollectionsKt.listOf((Object)new TextRange(PsiUtilsKt.getStartOffset(ktOperationReferenceExpression), PsiUtilsKt.getEndOffset(element)));
            }
        };
        IMPORT_ALIAS = new PositioningStrategy<KtImportDirective>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtImportDirective element) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtElement ktElement = element.getAlias();
                if (ktElement != null && (psiElement = ktElement.getNameIdentifier()) != null) {
                    PsiElement psiElement2 = psiElement;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiElement it = psiElement2;
                    boolean bl3 = false;
                    return PositioningStrategyKt.markElement(it);
                }
                ktElement = element.getImportedReference();
                if (ktElement != null) {
                    KtExpression ktExpression;
                    psiElement = ktElement;
                    boolean bl = false;
                    boolean bl4 = false;
                    PsiElement it = psiElement;
                    boolean bl5 = false;
                    if (it instanceof KtQualifiedExpression && (ktExpression = ((KtQualifiedExpression)it).getSelectorExpression()) != null) {
                        KtExpression ktExpression2 = ktExpression;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        KtExpression it2 = ktExpression2;
                        boolean bl8 = false;
                        return PositioningStrategyKt.markElement(it2);
                    }
                    return PositioningStrategyKt.markElement(it);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        RETURN_WITH_LABEL = new PositioningStrategy<KtReturnExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtReturnExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement labeledExpression = element.getLabeledExpression();
                if (labeledExpression != null) {
                    return PositioningStrategyKt.markRange(element, labeledExpression);
                }
                PsiElement psiElement = element.getReturnKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.returnKeyword");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        RECEIVER = new DeclarationHeader<KtCallableDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtCallableDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtTypeReference ktTypeReference = element.getReceiverTypeReference();
                if (ktTypeReference != null) {
                    KtTypeReference ktTypeReference2 = ktTypeReference;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtTypeReference it = ktTypeReference2;
                    boolean bl3 = false;
                    return PositioningStrategyKt.markElement(it);
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        OPERATOR = new PositioningStrategy<KtExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtExpression element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtExpression ktExpression = element;
                if (ktExpression instanceof KtBinaryExpression) {
                    KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)element).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"element.operationReference");
                    list2 = this.mark(ktOperationReferenceExpression);
                } else if (ktExpression instanceof KtUnaryExpression) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KtUnaryExpression)element).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"element.operationReference");
                    list2 = this.mark(ktSimpleNameExpression);
                } else {
                    list2 = super.mark((PsiElement)element);
                }
                return list2;
            }
        };
        DOT_BY_QUALIFIED = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element;
                if (psiElement instanceof KtDotQualifiedExpression) {
                    PsiElement psiElement2 = ((KtDotQualifiedExpression)element).getOperationTokenNode().getPsi();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.operationTokenNode.psi");
                    return this.mark(psiElement2);
                }
                return PositioningStrategies.INSTANCE.getREFERENCE_BY_QUALIFIED().mark(element);
            }
        };
        SELECTOR_BY_QUALIFIED = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                KtExpression selectorExpression;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtQualifiedExpression && (selectorExpression = ((KtQualifiedExpression)element).getSelectorExpression()) instanceof KtElement) {
                    return this.mark(selectorExpression);
                }
                return super.mark(element);
            }
        };
        RESERVED_UNDERSCORE = new PositioningStrategy<PsiElement>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiNameIdentifierOwner) {
                    PsiElement nameIdentifier = ((PsiNameIdentifierOwner)element).getNameIdentifier();
                    if (nameIdentifier != null) {
                        return super.mark(nameIdentifier);
                    }
                } else {
                    if (element instanceof KtImportDirective) {
                        PsiElement psiElement;
                        KtImportAlias nameIdentifier = ((KtImportDirective)element).getAlias();
                        return super.mark(nameIdentifier == null ? element : ((psiElement = nameIdentifier.getNameIdentifier()) == null ? element : psiElement));
                    }
                    if (element instanceof KtReturnExpression) {
                        PsiElement prevSibling = PsiUtilsKt.getPrevSiblingIgnoringWhitespace$default(element, false, 1, null);
                        if (prevSibling instanceof KtContainerNode) {
                            return this.mark(prevSibling);
                        }
                    } else if (!(element instanceof LeafPsiElement)) {
                        void $this$mapTo$iv$iv;
                        void $this$forEachDescendantOfType$iv$iv$iv$iv;
                        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
                        void $this$collectDescendantsOfType$iv;
                        Object object = element;
                        Function1 predicate$iv = RESERVED_UNDERSCORE.mark.ranges.1.INSTANCE;
                        boolean $i$f$collectDescendantsOfType22 = false;
                        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
                        boolean $i$f$collectDescendantsOfType = false;
                        Iterator<T> iterator2 = $this$collectDescendantsOfType$iv$iv;
                        Collection to$iv$iv$iv = new ArrayList<E>();
                        boolean $i$f$collectDescendantsOfTypeTo2 = false;
                        void var11_18 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
                        Function1 action$iv$iv$iv$iv = (Function1)new Function1<LeafPsiElement, Unit>(predicate$iv, to$iv$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ Collection $to;
                            {
                                this.$predicate = $predicate;
                                this.$to = $to;
                                super(1);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            public final void invoke(@NotNull PsiElement it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                                    this.$to.add(it);
                                }
                            }
                        };
                        boolean $i$f$forEachDescendantOfType = false;
                        $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                            final /* synthetic */ Function1 $action;
                            {
                                this.$action = $action;
                            }

                            public void visitElement(@NotNull PsiElement element) {
                                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                PsiElement it = element;
                                boolean bl = false;
                                super.visitElement(element);
                                if (element instanceof LeafPsiElement) {
                                    this.$action.invoke((Object)element);
                                }
                            }
                        });
                        Iterable $this$map$iv = (List)to$iv$iv$iv;
                        boolean $i$f$map = false;
                        Iterable $i$f$collectDescendantsOfType22 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            LeafPsiElement $i$f$collectDescendantsOfTypeTo2 = (LeafPsiElement)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            TextRange textRange = PositioningStrategyKt.markSingleElement((PsiElement)it);
                            collection.add(textRange);
                        }
                        List ranges2 = (List)destination$iv$iv;
                        object = ranges2;
                        boolean bl = false;
                        if (!object.isEmpty()) {
                            return ranges2;
                        }
                    }
                }
                return super.mark(element);
            }
        };
        FUN_INTERFACE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtClass) {
                    list2 = PositioningStrategies.FUN_MODIFIER.mark((KtModifierListOwner)((PsiElement)element));
                } else if (ktDeclaration instanceof KtProperty) {
                    PsiElement psiElement = ((KtProperty)element).getValOrVarKeyword();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.valOrVarKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktDeclaration instanceof KtNamedFunction) {
                    KtTypeParameterList typeParameterList = ((KtNamedFunction)element).getTypeParameterList();
                    if (typeParameterList != null) {
                        list2 = PositioningStrategyKt.markElement(typeParameterList);
                    } else if (element.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                        list2 = PositioningStrategies.SUSPEND_MODIFIER.mark((KtModifierListOwner)((PsiElement)element));
                    } else {
                        PsiElement psiElement = ((KtNamedFunction)element).getFunKeyword();
                        PsiElement psiElement2 = psiElement == null ? (PsiElement)element : psiElement;
                        list2 = PositioningStrategyKt.markElement(psiElement2);
                    }
                } else {
                    list2 = PositioningStrategyKt.markElement(element);
                }
                return list2;
            }
        };
        REFERENCE_BY_QUALIFIED = new FindReferencePositioningStrategy(false);
        REFERENCED_NAME_BY_QUALIFIED = new FindReferencePositioningStrategy(true);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.REIFIED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"REIFIED_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        REIFIED_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ASSIGNMENT_VALUE = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtProperty) {
                    KtExpression ktExpression = ((KtProperty)element).getInitializer();
                    KtExpression ktExpression2 = ktExpression == null ? (KtExpression)element : ktExpression;
                    psiElement = ktExpression2;
                } else {
                    psiElement = element;
                }
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHOLE_ELEMENT = new PositioningStrategy<KtElement>(){};
        TYPE_PARAMETERS_LIST = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtTypeParameterListOwner) {
                    KtTypeParameterList ktTypeParameterList = ((KtTypeParameterListOwner)element).getTypeParameterList();
                    return PositioningStrategyKt.markElement(ktTypeParameterList == null ? (KtElement)element : (KtElement)ktTypeParameterList);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0012\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$DeclarationHeader;", "T", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "()V", "isValid", "", "element", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "frontend"})
    private static class DeclarationHeader<T extends KtDeclaration>
    extends PositioningStrategy<T> {
        @Override
        public boolean isValid(@NotNull T element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            if (element instanceof KtNamedDeclaration && !(element instanceof KtObjectDeclaration) && !(element instanceof KtSecondaryConstructor) && !(element instanceof KtFunction) && ((KtNamedDeclaration)element).getNameIdentifier() == null) {
                return false;
            }
            return super.isValid((PsiElement)element);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$ModifierSetBasedPositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifierSet", "Lcom/intellij/psi/tree/TokenSet;", "(Lcom/intellij/psi/tree/TokenSet;)V", "mark", "", "Lcom/intellij/openapi/util/TextRange;", "element", "frontend"})
    private static final class ModifierSetBasedPositioningStrategy
    extends PositioningStrategy<KtModifierListOwner> {
        @NotNull
        private final TokenSet modifierSet;

        public ModifierSetBasedPositioningStrategy(@NotNull TokenSet modifierSet) {
            Intrinsics.checkNotNullParameter((Object)modifierSet, (String)"modifierSet");
            this.modifierSet = modifierSet;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<TextRange> mark(@NotNull KtModifierListOwner element) {
            Object object;
            PsiElement nameIdentifier;
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            KtModifierList modifierList2 = element.getModifierList();
            IElementType[] iElementTypeArray = this.modifierSet.getTypes();
            Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"modifierSet.types");
            Object $this$mapNotNull$iv = iElementTypeArray;
            boolean $i$f$mapNotNull = false;
            Object object2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            void var11_11 = $this$forEach$iv$iv$iv;
            int n = ((void)var11_11).length;
            for (int i = 0; i < n; ++i) {
                TextRange textRange;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var11_11[i];
                boolean bl = false;
                IElementType it = (IElementType)element$iv$iv;
                boolean bl2 = false;
                KtModifierList ktModifierList = modifierList2;
                if (ktModifierList == null) {
                    textRange = null;
                } else {
                    if (it == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
                    }
                    PsiElement psiElement = ktModifierList.getModifier((KtModifierKeywordToken)it);
                    textRange = psiElement == null ? null : psiElement.getTextRange();
                }
                if (textRange == null) continue;
                TextRange textRange2 = textRange;
                boolean bl3 = false;
                boolean bl4 = false;
                TextRange it$iv$iv = textRange2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List result2 = (List)destination$iv$iv;
            $this$mapNotNull$iv = result2;
            boolean bl = false;
            if (!$this$mapNotNull$iv.isEmpty()) {
                return result2;
            }
            if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)((Object)element)).getNameIdentifier()) != null) {
                return PositioningStrategyKt.markElement(nameIdentifier);
            }
            KtModifierListOwner ktModifierListOwner = element;
            if (ktModifierListOwner instanceof KtObjectDeclaration) {
                object2 = ((KtObjectDeclaration)element).getObjectKeyword();
                Intrinsics.checkNotNull((Object)object2);
                object = object2;
            } else if (ktModifierListOwner instanceof KtPropertyAccessor) {
                object2 = ((KtPropertyAccessor)element).getNamePlaceholder();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element.namePlaceholder");
                object = object2;
            } else if (ktModifierListOwner instanceof KtAnonymousInitializer) {
                object = element;
            } else {
                throw new IllegalArgumentException("Can't find text range for element '" + element.getClass().getCanonicalName() + "' with the text '" + element.getText() + '\'');
            }
            Object elementToMark = object;
            return PositioningStrategyKt.markElement((PsiElement)elementToMark);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$FindReferencePositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lcom/intellij/psi/PsiElement;", "locateReferencedName", "", "(Z)V", "getLocateReferencedName", "()Z", "mark", "", "Lcom/intellij/openapi/util/TextRange;", "element", "frontend"})
    public static final class FindReferencePositioningStrategy
    extends PositioningStrategy<PsiElement> {
        private final boolean locateReferencedName;

        public FindReferencePositioningStrategy(boolean locateReferencedName) {
            this.locateReferencedName = locateReferencedName;
        }

        public final boolean getLocateReferencedName() {
            return this.locateReferencedName;
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            PsiElement result2;
            PsiElement psiElement;
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement psiElement2 = element;
            if (psiElement2 instanceof KtQualifiedExpression) {
                KtExpression ktExpression2;
                KtExpression selectorExpression = ((KtQualifiedExpression)element).getSelectorExpression();
                ktExpression = selectorExpression instanceof KtCallExpression ? ((ktExpression2 = ((KtCallExpression)selectorExpression).getCalleeExpression()) == null ? selectorExpression : ktExpression2) : (selectorExpression instanceof KtReferenceExpression ? selectorExpression : (KtExpression)element);
                psiElement = ktExpression;
            } else if (psiElement2 instanceof KtCallableReferenceExpression) {
                ktExpression = ((KtCallableReferenceExpression)element).getCallableReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.callableReference");
                psiElement = ktExpression;
            } else if (psiElement2 instanceof KtCallExpression) {
                KtExpression ktExpression3 = ((KtCallExpression)element).getCalleeExpression();
                ktExpression = ktExpression3 == null ? (KtExpression)element : ktExpression3;
                psiElement = ktExpression;
            } else if (psiElement2 instanceof KtConstructorDelegationCall) {
                ktExpression = ((KtConstructorDelegationCall)element).getCalleeExpression();
                psiElement = ktExpression == null ? (KtElementImpl)element : (KtElementImpl)((Object)ktExpression);
            } else if (psiElement2 instanceof KtSuperTypeCallEntry) {
                ktExpression = ((KtSuperTypeCallEntry)element).getCalleeExpression();
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.calleeExpression");
                psiElement = ktExpression;
            } else if (psiElement2 instanceof KtOperationExpression) {
                ktExpression = ((KtOperationExpression)element).getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.operationReference");
                psiElement = ktExpression;
            } else if (psiElement2 instanceof KtWhenConditionInRange) {
                ktExpression = ((KtWhenConditionInRange)element).getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.operationReference");
                psiElement = ktExpression;
            } else {
                psiElement = result2 = element;
            }
            while (this.locateReferencedName && result2 instanceof KtParenthesizedExpression && (psiElement2 = ((KtParenthesizedExpression)result2).getExpression()) != null) {
                result2 = psiElement2;
            }
            return super.mark(result2);
        }
    }
}

