/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.targets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.targets.KotlinCommonModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinJsModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinJvmModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinTargetsIndex;
import org.jetbrains.kotlin.jps.targets.KotlinUnsupportedModuleBuildTarget;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformUtil;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformUtil;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformUtil;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinTargetsIndexBuilder;", "", "uninitializedContext", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "(Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;)V", "byJpsModuleBuildTarget", "", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "chunks", "", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "build", "Lorg/jetbrains/kotlin/jps/targets/KotlinTargetsIndex;", "ensureLoaded", "target", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nKotlinTargetsIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinTargetsIndex.kt\norg/jetbrains/kotlin/jps/targets/KotlinTargetsIndexBuilder\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n17#2,5:82\n22#2:104\n1855#3:87\n1603#3,9:88\n1855#3:97\n1856#3:99\n1612#3:100\n1855#3,2:101\n1856#3:103\n1194#3,2:105\n1222#3,4:107\n1#4:98\n*S KotlinDebug\n*F\n+ 1 KotlinTargetsIndex.kt\norg/jetbrains/kotlin/jps/targets/KotlinTargetsIndexBuilder\n*L\n37#1:82,5\n37#1:104\n41#1:87\n42#1:88,9\n42#1:97\n42#1:99\n42#1:100\n49#1:101,2\n41#1:103\n65#1:105,2\n65#1:107,4\n42#1:98\n*E\n"})
public final class KotlinTargetsIndexBuilder {
    @NotNull
    private final KotlinCompileContext uninitializedContext;
    @NotNull
    private final Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> byJpsModuleBuildTarget;
    @NotNull
    private final List<KotlinChunk> chunks;

    public KotlinTargetsIndexBuilder(@NotNull KotlinCompileContext uninitializedContext) {
        Intrinsics.checkNotNullParameter((Object)uninitializedContext, (String)"uninitializedContext");
        this.uninitializedContext = uninitializedContext;
        this.byJpsModuleBuildTarget = new LinkedHashMap();
        this.chunks = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KotlinTargetsIndex build() {
        Map map;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        boolean $i$f$measureTimeMillis22 = false;
        long start$iv = System.currentTimeMillis();
        boolean $i$a$-measureTimeMillis-KotlinTargetsIndexBuilder$build$time$22 = false;
        CompileContext jpsContext = this.uninitializedContext.getJpsContext();
        List list = jpsContext.getProjectDescriptor().getBuildTargetIndex().getSortedTargetChunks(jpsContext);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jpsContext.projectDescri\u2026dTargetChunks(jpsContext)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapNotNullTo$iv$iv;
            BuildTargetChunk chunk = (BuildTargetChunk)element$iv;
            boolean bl = false;
            Set set = chunk.getTargets();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"chunk.targets");
            Iterable $this$mapNotNull$iv = set;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KotlinModuleBuildTarget<?> it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                BuildTarget it = (BuildTarget)element$iv$iv;
                boolean bl3 = false;
                if ((it instanceof ModuleBuildTarget ? this.ensureLoaded((ModuleBuildTarget)it) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List moduleBuildTargets = (List)destination$iv$iv;
            if (!(!((Collection)moduleBuildTargets).isEmpty())) continue;
            KotlinChunk kotlinChunk = new KotlinChunk(this.uninitializedContext, moduleBuildTargets);
            Iterable $this$forEach$iv2 = moduleBuildTargets;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv2;
                boolean bl5 = false;
                it.setChunk(kotlinChunk);
            }
            this.chunks.add(kotlinChunk);
        }
        KotlinChunk.Companion.calculateChunkDependencies(this.chunks, this.byJpsModuleBuildTarget);
        long time = System.currentTimeMillis() - start$iv;
        KotlinBuilder.Companion.getLOG().info("KotlinTargetsIndex created in " + time + " ms");
        Iterable $i$f$measureTimeMillis22 = this.chunks;
        List<KotlinChunk> list2 = this.chunks;
        Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> map2 = this.byJpsModuleBuildTarget;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void $i$a$-measureTimeMillis-KotlinTargetsIndexBuilder$build$time$22 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Object element$iv;
            element$iv = (KotlinChunk)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getRepresentativeTarget().getJpsModuleBuildTarget(), element$iv$iv);
        }
        Map map3 = map = destination$iv$iv;
        List<KotlinChunk> list3 = list2;
        Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> map4 = map2;
        return new KotlinTargetsIndex(map4, list3, map3);
    }

    private final KotlinModuleBuildTarget<?> ensureLoaded(ModuleBuildTarget target) {
        KotlinModuleBuildTarget kotlinModuleBuildTarget = this.byJpsModuleBuildTarget.computeIfAbsent(target, arg_0 -> KotlinTargetsIndexBuilder.ensureLoaded$lambda$5((Function1)new Function1<ModuleBuildTarget, KotlinModuleBuildTarget<?>>(target, this){
            final /* synthetic */ ModuleBuildTarget $target;
            final /* synthetic */ KotlinTargetsIndexBuilder this$0;
            {
                this.$target = $target;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final KotlinModuleBuildTarget<?> invoke(@NotNull ModuleBuildTarget it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JpsModule jpsModule = this.$target.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"target.module");
                Object object = ModuleSettingsKt.getPlatform(jpsModule);
                if (object == null || (object = IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)object)) == null) {
                    object = IdePlatformKindUtil.getIdePlatformKind(JvmPlatforms.INSTANCE.getDefaultJvmPlatform());
                }
                Object platform = object;
                return CommonIdePlatformUtil.isCommon((IdePlatformKind)platform) ? (KotlinModuleBuildTarget)new KotlinCommonModuleBuildTarget(KotlinTargetsIndexBuilder.access$getUninitializedContext$p(this.this$0), this.$target) : (JsIdePlatformUtil.isJavaScript((IdePlatformKind)platform) ? (KotlinModuleBuildTarget)new KotlinJsModuleBuildTarget(KotlinTargetsIndexBuilder.access$getUninitializedContext$p(this.this$0), this.$target) : (JvmIdePlatformUtil.isJvm((IdePlatformKind)platform) ? (KotlinModuleBuildTarget)new KotlinJvmModuleBuildTarget(KotlinTargetsIndexBuilder.access$getUninitializedContext$p(this.this$0), this.$target) : (KotlinModuleBuildTarget)new KotlinUnsupportedModuleBuildTarget(KotlinTargetsIndexBuilder.access$getUninitializedContext$p(this.this$0), this.$target)));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)kotlinModuleBuildTarget, (String)"private fun ensureLoaded\u2026        }\n        }\n    }");
        return kotlinModuleBuildTarget;
    }

    private static final KotlinModuleBuildTarget ensureLoaded$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (KotlinModuleBuildTarget)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ KotlinCompileContext access$getUninitializedContext$p(KotlinTargetsIndexBuilder $this) {
        return $this.uninitializedContext;
    }
}

