/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.EvalType;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObjectVar0;
import org.jruby.RubyObjectVar1;
import org.jruby.RubyObjectVar2;
import org.jruby.RubyObjectVar3;
import org.jruby.RubyObjectVar4;
import org.jruby.RubyObjectVar5;
import org.jruby.RubyObjectVar6;
import org.jruby.RubyObjectVar7;
import org.jruby.RubyObjectVar8;
import org.jruby.RubyObjectVar9;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.DataType;
import org.jruby.util.cli.Options;

@JRubyClass(name={"Object"}, include={"Kernel"})
public class RubyObject
extends RubyBasicObject {
    public static final ObjectAllocator OBJECT_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyObject(runtime, klass);
        }
    };
    public static final ObjectAllocator OBJECT_VAR0_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyObjectVar0(runtime, klass);
        }
    };
    public static final ObjectAllocator OBJECT_VAR1_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyObjectVar1(runtime, klass);
        }
    };
    public static final ObjectAllocator OBJECT_VAR2_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyObjectVar2(runtime, klass);
        }
    };
    public static final ObjectAllocator OBJECT_VAR3_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyObjectVar3(runtime, klass);
        }
    };
    public static final ObjectAllocator OBJECT_VAR4_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyObjectVar4(runtime, klass);
        }
    };
    public static final ObjectAllocator OBJECT_VAR5_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyObjectVar5(runtime, klass);
        }
    };
    public static final ObjectAllocator OBJECT_VAR6_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyObjectVar6(runtime, klass);
        }
    };
    public static final ObjectAllocator OBJECT_VAR7_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyObjectVar7(runtime, klass);
        }
    };
    public static final ObjectAllocator OBJECT_VAR8_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyObjectVar8(runtime, klass);
        }
    };
    public static final ObjectAllocator OBJECT_VAR9_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyObjectVar9(runtime, klass);
        }
    };
    public static final ObjectAllocator[] FIELD_ALLOCATORS = new ObjectAllocator[]{OBJECT_ALLOCATOR, OBJECT_VAR0_ALLOCATOR, OBJECT_VAR1_ALLOCATOR, OBJECT_VAR2_ALLOCATOR, OBJECT_VAR3_ALLOCATOR, OBJECT_VAR4_ALLOCATOR, OBJECT_VAR5_ALLOCATOR, OBJECT_VAR6_ALLOCATOR, OBJECT_VAR7_ALLOCATOR, OBJECT_VAR8_ALLOCATOR, OBJECT_VAR9_ALLOCATOR};
    public static final Set<ObjectAllocator> FIELD_ALLOCATOR_SET = Collections.unmodifiableSet(new HashSet<ObjectAllocator>(Arrays.asList(FIELD_ALLOCATORS)));
    public static final Class[] FIELD_ALLOCATED_CLASSES = new Class[]{RubyObject.class, RubyObjectVar0.class, RubyObjectVar1.class, RubyObjectVar2.class, RubyObjectVar3.class, RubyObjectVar4.class, RubyObjectVar5.class, RubyObjectVar6.class, RubyObjectVar7.class, RubyObjectVar8.class, RubyObjectVar9.class};
    public static final ObjectAllocator IVAR_INSPECTING_OBJECT_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            Set<String> foundVariables = klass.discoverInstanceVariables();
            if (((Boolean)Options.DUMP_INSTANCE_VARS.load()).booleanValue()) {
                System.err.println(klass + ";" + foundVariables);
            }
            int count2 = 0;
            for (String name2 : foundVariables) {
                klass.getVariableTableManager().getVariableAccessorForVar(name2, count2);
                if (++count2 < 10) continue;
                break;
            }
            ObjectAllocator allocator = FIELD_ALLOCATORS[count2];
            Class reified = FIELD_ALLOCATED_CLASSES[count2];
            klass.setAllocator(allocator);
            klass.setReifiedClass(reified);
            klass.getMetaClass().invalidateCacheDescendants();
            return allocator.allocate(runtime, klass);
        }
    };
    public static final ObjectAllocator REIFYING_OBJECT_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            klass.reifyWithAncestors();
            return klass.allocate();
        }
    };

    public RubyObject(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public RubyObject(RubyClass metaClass) {
        super(metaClass);
    }

    @Deprecated
    protected RubyObject(Ruby runtime, RubyClass metaClass, boolean useObjectSpace, boolean canBeTainted) {
        super(runtime, metaClass, useObjectSpace, canBeTainted);
    }

    protected RubyObject(Ruby runtime, RubyClass metaClass, boolean useObjectSpace) {
        super(runtime, metaClass, useObjectSpace);
    }

    public static RubyClass createObjectClass(Ruby runtime, RubyClass objectClass) {
        objectClass.setClassIndex(ClassIndex.OBJECT);
        objectClass.setReifiedClass(RubyObject.class);
        return objectClass;
    }

    public void attachToObjectSpace() {
        this.getRuntime().getObjectSpace().add(this);
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.OBJECT;
    }

    public static void puts(Object obj) {
        System.out.println(obj.toString());
    }

    @Override
    public boolean equals(Object other) {
        return other == this || other instanceof IRubyObject && Helpers.invokedynamic(this.getRuntime().getCurrentContext(), (IRubyObject)this, MethodNames.OP_EQUAL, (IRubyObject)other).isTrue();
    }

    public String toString() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        RubyString rubyString = RubyObject.sites((ThreadContext)context).to_s.call(context, this, this).convertToString();
        return rubyString.getUnicodeValue();
    }

    public final void callInit(IRubyObject[] args2, Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, args2, block);
    }

    public final void callInit(Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, block);
    }

    public final void callInit(IRubyObject arg0, Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, block);
    }

    public final void callInit(IRubyObject arg0, IRubyObject arg1, Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, arg1, block);
    }

    public final void callInit(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, arg1, arg2, block);
    }

    public final void callInit(ThreadContext context, IRubyObject[] args2, Block block) {
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, args2, block);
    }

    public final void callInit(ThreadContext context, Block block) {
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, block);
    }

    public final void callInit(ThreadContext context, IRubyObject arg0, Block block) {
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, block);
    }

    public final void callInit(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, arg1, block);
    }

    public final void callInit(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, arg1, arg2, block);
    }

    @Deprecated
    public final IRubyObject convertToType(RubyClass target, int convertMethodIndex) {
        throw new RuntimeException("Not supported; use the String versions");
    }

    @Deprecated
    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject[] args2, Block block, EvalType evalType) {
        int line;
        String file2;
        if (block.isGiven()) {
            if (args2.length > 0) {
                throw this.getRuntime().newArgumentError(args2.length, 0);
            }
            return this.yieldUnder(context, mod, block, evalType);
        }
        if (args2.length == 0) {
            throw this.getRuntime().newArgumentError("block not supplied");
        }
        if (args2.length > 3) {
            String lastFuncName = context.getFrameName();
            throw this.getRuntime().newArgumentError("wrong number of arguments: " + lastFuncName + "(src) or " + lastFuncName + "{..}");
        }
        RubyString evalStr = args2[0] instanceof RubyString ? (RubyString)args2[0] : args2[0].convertToString();
        if (args2.length > 1) {
            file2 = args2[1].convertToString().asJavaString();
            line = args2.length > 2 ? (int)(args2[2].convertToInteger().getLongValue() - 1L) : 0;
        } else {
            file2 = "(eval)";
            line = 0;
        }
        return this.evalUnder(context, mod, evalStr, file2, line, evalType);
    }

    @Override
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return context.runtime.newBoolean(RubyObject.equalInternal(context, this, other));
    }

    public static boolean equalInternal(ThreadContext context, IRubyObject a, IRubyObject b2) {
        if (a == b2) {
            return true;
        }
        if (a instanceof RubySymbol) {
            return false;
        }
        if (a instanceof RubyFixnum && b2 instanceof RubyFixnum) {
            return ((RubyFixnum)a).fastEqual((RubyFixnum)b2);
        }
        if (a instanceof RubyFloat && b2 instanceof RubyFloat) {
            return ((RubyFloat)a).fastEqual((RubyFloat)b2);
        }
        return Helpers.invokedynamic(context, a, MethodNames.OP_EQUAL, b2).isTrue();
    }

    protected static boolean eqlInternal(ThreadContext context, IRubyObject a, IRubyObject b2) {
        if (a == b2) {
            return true;
        }
        if (a instanceof RubySymbol) {
            return false;
        }
        if (a instanceof RubyNumeric) {
            if (a.getClass() != b2.getClass()) {
                return false;
            }
            return RubyObject.equalInternal(context, a, b2);
        }
        return Helpers.invokedynamic(context, a, MethodNames.EQL, b2).isTrue();
    }

    @Override
    public int hashCode() {
        IRubyObject hashValue = Helpers.invokedynamic(this.getRuntime().getCurrentContext(), (IRubyObject)this, MethodNames.HASH);
        if (hashValue instanceof RubyFixnum) {
            return (int)RubyNumeric.fix2long(hashValue);
        }
        return RubyObject.nonFixnumHashCode(hashValue);
    }

    public static RubyString inspect(ThreadContext context, IRubyObject object) {
        return (RubyString)RubyObject.rbInspect(context, object);
    }

    public static IRubyObject dig(ThreadContext context, IRubyObject obj, IRubyObject[] args2, int idx) {
        if (obj.isNil()) {
            return context.nil;
        }
        JavaSites.ObjectSites sites = RubyObject.sites(context);
        if (obj instanceof RubyArray && sites.dig_array.isBuiltin(obj.getMetaClass())) {
            return ((RubyArray)obj).dig(context, args2, idx);
        }
        if (obj instanceof RubyHash && sites.dig_hash.isBuiltin(obj.getMetaClass())) {
            return ((RubyHash)obj).dig(context, args2, idx);
        }
        if (obj instanceof RubyStruct && sites.dig_struct.isBuiltin(obj.getMetaClass())) {
            return ((RubyStruct)obj).dig(context, args2, idx);
        }
        if (sites.respond_to_dig.respondsTo(context, obj, obj, true)) {
            int len = args2.length - idx;
            switch (len) {
                case 1: {
                    return sites.dig_misc.call(context, obj, obj, args2[idx]);
                }
                case 2: {
                    return sites.dig_misc.call(context, obj, obj, args2[idx], args2[idx + 1]);
                }
                case 3: {
                    return sites.dig_misc.call(context, obj, obj, args2[idx], args2[idx + 1], args2[idx + 2]);
                }
            }
            IRubyObject[] rest2 = new IRubyObject[len];
            System.arraycopy(args2, idx, rest2, 0, len);
            return sites.dig_misc.call(context, obj, obj, rest2);
        }
        throw context.runtime.newTypeError(obj.getMetaClass().getName() + " does not have #dig method");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        List<String> names2 = this.getInstanceVariableNameList();
        out.writeInt(names2.size());
        for (String name2 : names2) {
            out.writeObject(name2);
            out.writeObject(this.getInstanceVariables().getInstanceVariable(name2));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int ivarCount = in.readInt();
        for (int i2 = 0; i2 < ivarCount; ++i2) {
            this.setInstanceVariable((String)in.readObject(), (IRubyObject)in.readObject());
        }
    }

    private static JavaSites.ObjectSites sites(ThreadContext context) {
        return context.sites.Object;
    }

    public static class Data
    extends RubyObject
    implements DataType {
        public Data(Ruby runtime, RubyClass metaClass, Object data2) {
            super(runtime, metaClass);
            this.dataWrapStruct(data2);
        }

        public Data(RubyClass metaClass, Object data2) {
            super(metaClass);
            this.dataWrapStruct(data2);
        }
    }
}

