-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

-- Narratives

INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER,
                              UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'ED_SF424_Supplement_3_0-V3.0',
        (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'ED_SF424_Supplement_Attachment'), 'N',
        'admin', NOW(), UUID());

-- Errors

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/ED_SF424_Supplement_3_0/IsNoviceApplicant',
        'Please answer all the questions for the form "ED_SF424_Supplement_3_0-V3.0" within the Questions tab.',
        'questions', NOW(), 'admin', 1, UUID());

-- New Questionnaire

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);
INSERT INTO QUESTIONNAIRE (QUESTIONNAIRE_REF_ID, QUESTIONNAIRE_ID, SEQUENCE_NUMBER, NAME, DESCRIPTION, UPDATE_TIMESTAMP,
                           UPDATE_USER, IS_FINAL, VER_NBR, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_QUESTIONNAIRE_REF_ID), -12, 1, 'EDSF424 Supplement 3.0 Questions',
        'These questions support EDSF424 Supplement 3.0 Grants.gov forms.', NOW(), 'admin', 'Y', 1, UUID());

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);
INSERT INTO S2S_FORM_TO_QUESTIONNAIRE (S2S_FORM_TO_QUESTIONNAIRE_ID, OPP_NAME_SPACE, FORM_NAME, QUESTIONNAIRE_ID,
                                       UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, VER_NBR)
VALUES ((SELECT MAX(ID) FROM SEQ_QUESTIONNAIRE_REF_ID), 'http://apply.grants.gov/forms/ED_SF424_Supplement_3_0-V3.0',
        'ED_SF424_Supplement_3_0-V3.0', -12, NOW(), 'admin', UUID(), 1);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);
INSERT INTO QUESTIONNAIRE_USAGE (QUESTIONNAIRE_USAGE_ID, MODULE_ITEM_CODE, MODULE_SUB_ITEM_CODE,
                                 QUESTIONNAIRE_REF_ID_FK, QUESTIONNAIRE_SEQUENCE_NUMBER, RULE_ID, QUESTIONNAIRE_LABEL,
                                 UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, IS_MANDATORY)
VALUES ((SELECT MAX(ID) FROM SEQ_QUESTIONNAIRE_REF_ID), 3, 2,
        (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -12 AND SEQUENCE_NUMBER = 1), 1, null,
        'EDSF424 Supplement 3.0 Questions', NOW(), 'admin', 1, UUID(), 'N');

-- New Questions

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);
INSERT INTO QUESTION (QUESTION_REF_ID, QUESTION_ID, SEQUENCE_NUMBER, SEQUENCE_STATUS, QUESTION, STATUS, GROUP_TYPE_CODE,
                      QUESTION_TYPE_ID, LOOKUP_CLASS, LOOKUP_RETURN, DISPLAYED_ANSWERS,
                      MAX_ANSWERS, ANSWER_MAX_LENGTH, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_NUMBER)
VALUES ((SELECT MAX(ID) FROM SEQ_QUESTIONNAIRE_REF_ID), -10147, 1, 'C',
        'Are you either a new potential grantee or novice applicant as defined in the program competition’s
notice inviting applications (NIA)?', 'C', 2, 1, null, null, null, 1, 1,
        NOW(), 'admin', 1, UUID(), null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);
INSERT INTO QUESTION (QUESTION_REF_ID, QUESTION_ID, SEQUENCE_NUMBER, SEQUENCE_STATUS, QUESTION, STATUS, GROUP_TYPE_CODE,
                      QUESTION_TYPE_ID, LOOKUP_CLASS, LOOKUP_RETURN, DISPLAYED_ANSWERS,
                      MAX_ANSWERS, ANSWER_MAX_LENGTH, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_NUMBER)
VALUES ((SELECT MAX(ID) FROM SEQ_QUESTIONNAIRE_REF_ID), -10148, 1, 'C',
        'If the program competition NIA is giving competitive preference points for a new potential grantee or novice applicant,
how many points are you claiming for your application? (the NIA will indicate how many are available)', 'C', 2, 3, null,
        null, null, 1, 2,
        NOW(), 'admin', 1, UUID(), null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);
INSERT INTO QUESTION (QUESTION_REF_ID, QUESTION_ID, SEQUENCE_NUMBER, SEQUENCE_STATUS, QUESTION, STATUS, GROUP_TYPE_CODE,
                      QUESTION_TYPE_ID, LOOKUP_CLASS, LOOKUP_RETURN, DISPLAYED_ANSWERS,
                      MAX_ANSWERS, ANSWER_MAX_LENGTH, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_NUMBER)
VALUES ((SELECT MAX(ID) FROM SEQ_QUESTIONNAIRE_REF_ID), -10149, 1, 'C',
        'If the NIA includes a Qualified Opportunity Zones (QOZ) Priority in which you propose to either provide
services in QOZ(s) or are in a QOZ, provide the QOZ census tract number(s) below:', 'C', 2, 3, null,
        null, 12, 12, 11,
        NOW(), 'admin', 1, UUID(), null);

-- Adding Questions to Questionnaire

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK,
                                     QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG,
                                     CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR,
                                     RULE_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_QUESTIONNAIRE_REF_ID),
        (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -12),
        (SELECT QUESTION_REF_ID
         FROM QUESTION
         WHERE QUESTION_ID = -10147
           AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER) FROM QUESTION WHERE QUESTION_ID = -10147)),
        1, 0, 1, 'N', null, 'null', 'admin', NOW(), UUID(), 1, null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK,
                                     QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG,
                                     CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR,
                                     RULE_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_QUESTIONNAIRE_REF_ID),
        (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -12),
        (SELECT QUESTION_REF_ID
         FROM QUESTION
         WHERE QUESTION_ID = -10148
           AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER) FROM QUESTION WHERE QUESTION_ID = -10148)),
        2, 1, 2, 'Y', 4, 'Y', 'admin', NOW(), UUID(), 1, null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK,
                                     QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG,
                                     CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR,
                                     RULE_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_QUESTIONNAIRE_REF_ID),
        (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -12),
        (SELECT QUESTION_REF_ID
         FROM QUESTION
         WHERE QUESTION_ID = -10149
           AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER) FROM QUESTION WHERE QUESTION_ID = -10149)),
        3, 0, 3, 'N', null, 'null', 'admin', NOW(), UUID(), 1, null);
