/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common.waitfreepool;

import java.lang.reflect.Executable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.ucp.common.waitfreepool.PoolIterator;

final class PoolIteratorQueue<T> {
    private final AtomicReference<Element> listHead = new AtomicReference<Element>(new Element(null));
    private final AtomicReference<Element> listTail = new AtomicReference<Element>(this.listHead.get());
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    PoolIteratorQueue() {
    }

    void enqueue(PoolIterator<T> poolIterator) {
        this.skipToFirstActive();
        if (poolIterator == null) {
            throw new IllegalArgumentException("poolIterator is null");
        }
        Element newElement = new Element(poolIterator);
        Element element = this.listTail.get();
        while (true) {
            if (element.next.compareAndSet(null, newElement)) {
                this.listTail.set(newElement);
                return;
            }
            element = element.next.get();
        }
    }

    boolean peek(PoolIterator<T> poolIterator) {
        if (poolIterator == null) {
            throw new IllegalArgumentException("poolIterator is null");
        }
        Element element = this.skipToFirstActive();
        PoolIterator pi = element.poolIterator.get();
        if (null == pi) {
            return true;
        }
        return poolIterator == pi;
    }

    void disable(PoolIterator<T> poolIterator) {
        Element elm = this.listHead.get();
        while (null != elm) {
            if (elm.poolIterator.compareAndSet(poolIterator, null)) {
                return;
            }
            elm = elm.next.get();
        }
        throw new IllegalArgumentException("no poolIterator in a queue");
    }

    private Element skipToFirstActive() {
        Element nextElement;
        PoolIterator i2;
        Element element = this.listHead.get();
        while (true) {
            if ((i2 = element.poolIterator.get()) != null) {
                if (i2.isAlive()) break;
                element.poolIterator.set(null);
            }
            if ((nextElement = element.next.get()) == null) break;
            element = nextElement;
        }
        this.listHead.set(element);
        while (((i2 = element.poolIterator.get()) == null || i2.isSleeping()) && (nextElement = element.next.get()) != null) {
            element = nextElement;
        }
        return element;
    }

    static {
        try {
            $$$methodRef$$$4 = PoolIteratorQueue.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = PoolIteratorQueue.class.getDeclaredMethod("skipToFirstActive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = PoolIteratorQueue.class.getDeclaredMethod("disable", PoolIterator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = PoolIteratorQueue.class.getDeclaredMethod("peek", PoolIterator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = PoolIteratorQueue.class.getDeclaredMethod("enqueue", PoolIterator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }

    private final class Element {
        final AtomicReference<PoolIterator<T>> poolIterator;
        final AtomicReference<Element> next = new AtomicReference<Object>(null);
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        Element(PoolIterator<T> poolIterator) {
            this.poolIterator = new AtomicReference(poolIterator);
        }

        static {
            try {
                $$$methodRef$$$0 = Element.class.getDeclaredConstructor(PoolIteratorQueue.class, PoolIterator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

