/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.SqlStatementBuilder;
import org.flywaydb.core.internal.dbsupport.mysql.MySQLSchema;
import org.flywaydb.core.internal.dbsupport.mysql.MySQLSqlStatementBuilder;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class MySQLDbSupport
extends DbSupport {
    private static final Log LOG = LogFactory.getLog(MySQLDbSupport.class);

    public MySQLDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 12));
    }

    @Override
    public String getDbName() {
        return "mysql";
    }

    @Override
    public String getCurrentUserFunction() {
        return "SUBSTRING_INDEX(USER(),'@',1)";
    }

    @Override
    protected String doGetCurrentSchema() throws SQLException {
        return this.jdbcTemplate.getConnection().getCatalog();
    }

    @Override
    protected void doSetCurrentSchema(Schema schema) throws SQLException {
        if ("".equals(schema.getName())) {
            try {
                String newDb = this.quote(UUID.randomUUID().toString());
                this.jdbcTemplate.execute("CREATE SCHEMA " + newDb, new Object[0]);
                this.jdbcTemplate.execute("USE " + newDb, new Object[0]);
                this.jdbcTemplate.execute("DROP SCHEMA " + newDb, new Object[0]);
            }
            catch (Exception e2) {
                LOG.warn("Unable to restore connection to having no default schema");
            }
        } else {
            this.jdbcTemplate.execute("USE " + schema, new Object[0]);
        }
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new MySQLSqlStatementBuilder();
    }

    @Override
    public String doQuote(String identifier) {
        return "`" + identifier + "`";
    }

    @Override
    public Schema getSchema(String name) {
        return new MySQLSchema(this.jdbcTemplate, this, name);
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }
}

