/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.data.migration;

import co.kuali.coeus.data.migration.custom.CoeusMigrationResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.resolver.MigrationResolver;

public class FlywayMigrator {
    private static final Logger LOG = LogManager.getLogger(FlywayMigrator.class);
    protected String initVersion;
    protected String targetVersion;
    protected DataSource dataSource;
    protected DataSource riceDataSource;
    protected CoeusMigrationResolver coeusMigrationResolver;
    protected String sqlMigrationPath;
    protected String javaMigrationPath;
    protected List<String> extraMigrationPaths;
    protected String kcPath = "kc";
    protected String ricePath = "rice";
    protected String riceServer = "rice_server";
    protected String riceDataOnly = "rice_data_only";
    protected String embeddedClientScripts = "kc/embedded_client_scripts";
    protected String bootstrapPath = "bootstrap";
    protected String testingPath = "testing";
    protected String stagingDataPath = "staging";
    protected String demoDataPath = "demo";
    protected String grmDataPath = "grm";
    protected String checksumUpdatesFilename = "checksum_updates.csv";
    protected Boolean enabled;
    protected Boolean applyTesting;
    protected Boolean applyStaging;
    protected Boolean applyDemo;
    protected Boolean outOfOrder;
    protected Boolean ignoreMissingMigrations;
    protected Boolean grm;
    protected Boolean manageRice;
    protected Boolean embeddedMode;
    private String mysqlUpdateChecksumStatement = "update schema_version set checksum = ? where version = ?";
    private List<String> mysqlPreMigrationSql = new ArrayList<String>();
    private String oracleUpdateChecksumStatement = "update \"schema_version\" set \"checksum\" = ? where \"version\" = ?";
    private List<String> oraclePreMigrationSql = new ArrayList<String>();

    public void migrate() {
        if (!this.enabled.booleanValue()) {
            LOG.info("Flyway Migration is not enabled. Skipping.");
            return;
        }
        if (this.dataSource == null) {
            throw new IllegalStateException("dataSource == null");
        }
        if (this.riceDataSource == null) {
            throw new IllegalStateException("riceDataSource == null");
        }
        if (!this.embeddedMode.booleanValue()) {
            this.manageRice = true;
        }
        ArrayList<String> kcLocations = new ArrayList<String>(this.buildLocations(this.kcPath));
        if (!this.embeddedMode.booleanValue()) {
            kcLocations.addAll(this.buildLocations(this.ricePath));
            kcLocations.addAll(this.buildLocations(this.riceServer));
        } else {
            kcLocations.add(this.embeddedClientScripts);
        }
        if (this.grm.booleanValue()) {
            kcLocations.add(this.grmDataPath);
        }
        this.coeusMigrationResolver = new CoeusMigrationResolver(this.riceDataSource);
        this.coeusMigrationResolver.setJavaMigrationPath(this.getJavaMigrationPath());
        this.performMigration(this.dataSource, kcLocations, this.coeusMigrationResolver);
        if (this.embeddedMode.booleanValue()) {
            ArrayList<String> riceLocations = new ArrayList<String>(this.buildLocations(this.ricePath));
            if (this.manageRice.booleanValue()) {
                riceLocations.addAll(this.buildLocations(this.riceServer));
            } else {
                riceLocations.addAll(this.buildLocations(this.riceDataOnly));
            }
            this.performMigration(this.riceDataSource, riceLocations, new MigrationResolver[0]);
        }
    }

    protected void performMigration(DataSource dataSource, List<String> locations, MigrationResolver ... migrationResolvers) {
        this.runPreMigrationSql(dataSource);
        ArrayList<String> migrationLocations = new ArrayList<String>(this.prefixLocationsWithDb(this.getSqlMigrationPath(), locations));
        this.getExtraMigrationPaths().stream().map(path -> this.prefixLocationsWithDb((String)path, locations)).forEach(migrationLocations::addAll);
        FluentConfiguration flywayConfig = Flyway.configure();
        flywayConfig.dataSource(dataSource).table("schema_version").locations(this.filterForExistence(migrationLocations)).resolvers(migrationResolvers).placeholderPrefix("PLACEHOLDERS_DISABLED$$$$$").baselineOnMigrate(true).baselineVersion(MigrationVersion.fromVersion(this.getInitVersion())).target(MigrationVersion.fromVersion(this.getTargetVersion())).ignoreMissingMigrations(this.getIgnoreMissingMigrations()).outOfOrder(this.getOutOfOrder());
        Flyway flyway = flywayConfig.load();
        if (LOG.isInfoEnabled()) {
            LOG.info(Stream.of(flyway.info().all()).map(i -> "flyway migration: " + i.getVersion() + " : '" + i.getDescription() + "' from file: " + i.getScript() + "\n").collect(Collectors.joining()));
        }
        int numApplied = flyway.migrate();
        LOG.info("flyway migrations applied: " + numApplied);
    }

    protected List<String> prefixLocationsWithDb(String dbPath, List<String> locations) {
        ArrayList<String> result = new ArrayList<String>();
        for (String location : locations) {
            result.add(dbPath + "/" + location);
        }
        return result;
    }

    protected String[] filterForExistence(List<String> locations) {
        ArrayList<String> result = new ArrayList<String>();
        for (String location : locations) {
            if (this.getClass().getClassLoader().getResource(location) == null) continue;
            result.add(location);
        }
        return result.toArray(new String[0]);
    }

    protected void runPreMigrationSql(DataSource dataSource) {
        try (Connection conn = dataSource.getConnection();){
            conn.setAutoCommit(true);
            String databaseProductName = conn.getMetaData().getDatabaseProductName();
            if (StringUtils.containsIgnoreCase(databaseProductName, "oracle")) {
                this.runChecksumPreMigration(this.oracleUpdateChecksumStatement, conn);
                this.runSpecificPreMigrationSql(conn, this.oraclePreMigrationSql);
            } else {
                this.runChecksumPreMigration(this.mysqlUpdateChecksumStatement, conn);
                this.runSpecificPreMigrationSql(conn, this.mysqlPreMigrationSql);
            }
        }
        catch (SQLException e) {
            LOG.warn("Error getting connection to run pre migration sql", (Throwable)e);
        }
    }

    void runChecksumPreMigration(String checksumUpdateStatement, Connection conn) {
        this.runChecksumPreMigrationFromLocation(checksumUpdateStatement, this.getSqlMigrationPath(), conn);
        for (String path : this.getExtraMigrationPaths()) {
            this.runChecksumPreMigrationFromLocation(checksumUpdateStatement, path, conn);
        }
    }

    protected void runChecksumPreMigrationFromLocation(String checksumUpdateStatement, String location, Connection conn) {
        this.runChecksumUpdateSqlFromFile(checksumUpdateStatement, this.getClass().getClassLoader().getResource(location + "/" + this.checksumUpdatesFilename), conn);
    }

    void runChecksumUpdateSqlFromFile(String checksumUpdatePattern, URL checksumFileURL, Connection conn) {
        if (checksumFileURL == null) {
            return;
        }
        try (Stream<String> stream = new BufferedReader(new InputStreamReader(checksumFileURL.openStream())).lines();
             PreparedStatement stmt = conn.prepareStatement(checksumUpdatePattern);){
            stream.filter(StringUtils::isNotEmpty).map(line -> line.replaceAll("\\s", "")).forEach(line -> this.runChecksumUpdateStatementFromCsvLine((String)line, stmt));
        }
        catch (IOException | SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to run checksum updates.", (Throwable)e);
            }
            LOG.warn("Unable to run checksum updates. " + e.getMessage());
        }
    }

    void runChecksumUpdateStatementFromCsvLine(String line, PreparedStatement stmt) {
        String[] parts = line.split(",");
        try {
            stmt.setLong(1, Long.parseLong(parts[1]));
            stmt.setString(2, parts[0]);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to run checksum update - '" + line + "'", (Throwable)e);
            }
            LOG.warn("Unable to run checksum update - '" + line + "' - " + e.getMessage());
        }
    }

    void runSpecificPreMigrationSql(Connection conn, List<String> preMigrationSql) {
        for (String preSql : preMigrationSql) {
            try {
                Statement stmt = conn.createStatement();
                try {
                    stmt.executeUpdate(preSql);
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
            catch (SQLException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error running pre migration sql.", (Throwable)e);
                    continue;
                }
                LOG.warn("Error running pre migration sql " + e.getMessage());
            }
        }
    }

    protected List<String> buildLocations(String rootPath) {
        ArrayList<String> locations = new ArrayList<String>();
        locations.add(rootPath + "/" + this.bootstrapPath);
        if (this.getApplyTesting().booleanValue()) {
            locations.add(rootPath + "/" + this.testingPath);
        }
        if (this.getApplyStaging().booleanValue()) {
            locations.add(rootPath + "/" + this.stagingDataPath);
        }
        if (this.getApplyDemo().booleanValue()) {
            locations.add(rootPath + "/" + this.demoDataPath);
        }
        return locations;
    }

    protected Boolean getDefinedOption(String option, Boolean defaultValue) {
        if (System.getProperty(option) != null) {
            return Boolean.valueOf(System.getProperty(option));
        }
        if (System.getenv().containsKey(option)) {
            return Boolean.valueOf(System.getProperty(option));
        }
        return defaultValue;
    }

    protected String getDefinedOption(String option, String defaultValue) {
        if (System.getProperty(option) != null) {
            return System.getProperty(option);
        }
        if (System.getenv().containsKey(option)) {
            return System.getProperty(option);
        }
        return defaultValue;
    }

    public void setInitVersion(String initVersion) {
        this.initVersion = initVersion;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getRiceDataSource() {
        return this.riceDataSource;
    }

    public void setRiceDataSource(DataSource riceDataSource) {
        this.riceDataSource = riceDataSource;
    }

    public String getBootstrapPath() {
        return this.bootstrapPath;
    }

    public void setBootstrapPath(String bootstrapPath) {
        this.bootstrapPath = bootstrapPath;
    }

    public String getTestingPath() {
        return this.testingPath;
    }

    public void setTestingPath(String testingPath) {
        this.testingPath = testingPath;
    }

    public String getStagingDataPath() {
        return this.stagingDataPath;
    }

    public void setStagingDataPath(String stagingDataPath) {
        this.stagingDataPath = stagingDataPath;
    }

    public String getDemoDataPath() {
        return this.demoDataPath;
    }

    public void setDemoDataPath(String demoDataPath) {
        this.demoDataPath = demoDataPath;
    }

    public String getGrmDataPath() {
        return this.grmDataPath;
    }

    public void setGrmDataPath(String grmDataPath) {
        this.grmDataPath = grmDataPath;
    }

    public Boolean getApplyTesting() {
        if (this.applyTesting == null) {
            this.applyTesting = this.getDefinedOption("kc.flyway.testing", Boolean.FALSE);
        }
        return this.applyTesting;
    }

    public void setApplyTesting(boolean applyTesting) {
        this.applyTesting = applyTesting;
    }

    public Boolean getApplyStaging() {
        if (this.applyStaging == null) {
            this.applyStaging = this.getDefinedOption("kc.flyway.staging", Boolean.FALSE);
        }
        return this.applyStaging;
    }

    public void setApplyStaging(boolean applyStaging) {
        this.applyStaging = applyStaging;
    }

    public Boolean getApplyDemo() {
        if (this.applyDemo == null) {
            this.applyDemo = this.getDefinedOption("kc.flyway.demo", Boolean.FALSE);
        }
        return this.applyDemo;
    }

    public void setApplyDemo(boolean applyDemo) {
        this.applyDemo = applyDemo;
    }

    public String getInitVersion() {
        if (this.initVersion == null) {
            this.initVersion = this.getDefinedOption("kc.flyway.baseline.version", "0");
        }
        return this.initVersion;
    }

    public String getTargetVersion() {
        if (this.targetVersion == null) {
            this.targetVersion = this.getDefinedOption("kc.flyway.target.version", Long.toString(Long.MAX_VALUE));
        }
        return this.targetVersion;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Boolean getManageRice() {
        if (this.manageRice == null) {
            this.manageRice = this.getDefinedOption("kc.flyway.manageRice", Boolean.TRUE);
        }
        return this.manageRice;
    }

    public void setManageRice(Boolean manageRice) {
        this.manageRice = manageRice;
    }

    public Boolean getEmbeddedMode() {
        if (this.embeddedMode == null) {
            this.embeddedMode = this.getDefinedOption("kc.flyway.embedded", Boolean.FALSE);
        }
        return this.embeddedMode;
    }

    public void setEmbeddedMode(Boolean embeddedMode) {
        this.embeddedMode = embeddedMode;
    }

    public Boolean getGrm() {
        if (this.embeddedMode == null) {
            this.embeddedMode = this.getDefinedOption("kc.flyway.grm", Boolean.FALSE);
        }
        return this.embeddedMode;
    }

    public void setGrm(Boolean grm) {
        this.grm = grm;
    }

    public CoeusMigrationResolver getCoeusMigrationResolver() {
        return this.coeusMigrationResolver;
    }

    public void setCoeusMigrationResolver(CoeusMigrationResolver coeusMigrationResolver) {
        this.coeusMigrationResolver = coeusMigrationResolver;
    }

    public Boolean getEnabled() {
        if (this.enabled == null) {
            this.enabled = this.getDefinedOption("kc.flyway.enabled", Boolean.FALSE);
        }
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getSqlMigrationPath() {
        if (this.sqlMigrationPath == null) {
            this.sqlMigrationPath = this.getDefinedOption("kc.flyway.sql.migration.path", "");
        }
        return this.sqlMigrationPath;
    }

    public void setSqlMigrationPath(String migrationPath) {
        this.sqlMigrationPath = migrationPath;
    }

    public String getJavaMigrationPath() {
        if (this.javaMigrationPath == null) {
            this.javaMigrationPath = this.getDefinedOption("kc.flyway.java.migration.path", "");
        }
        return this.javaMigrationPath;
    }

    public void setJavaMigrationPath(String javaMigrationPath) {
        this.javaMigrationPath = javaMigrationPath;
    }

    public List<String> getExtraMigrationPaths() {
        if (this.extraMigrationPaths == null) {
            this.extraMigrationPaths = Arrays.asList(this.getDefinedOption("kc.flyway.sql.extra.paths", "").split(","));
        }
        return this.extraMigrationPaths;
    }

    public void setExtraMigrationPaths(List<String> extraMigrationPaths) {
        this.extraMigrationPaths = extraMigrationPaths;
    }

    public Boolean getOutOfOrder() {
        if (this.outOfOrder == null) {
            this.outOfOrder = this.getDefinedOption("kc.flyway.outOfOrder", Boolean.FALSE);
        }
        return this.outOfOrder;
    }

    public void setOutOfOrder(Boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    public Boolean getIgnoreMissingMigrations() {
        if (this.ignoreMissingMigrations == null) {
            this.ignoreMissingMigrations = this.getDefinedOption("kc.flyway.ignoreMissingMigrations", Boolean.FALSE);
        }
        return this.ignoreMissingMigrations;
    }

    public void setIgnoreMissingMigrations(Boolean ignoreMissingMigrations) {
        this.ignoreMissingMigrations = ignoreMissingMigrations;
    }
}

