/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.data.migration.custom;

import co.kuali.coeus.data.migration.custom.RiceDataSourceAware;
import co.kuali.coeus.data.migration.custom.SqlExecutor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.executor.Context;
import org.flywaydb.core.api.executor.MigrationExecutor;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.RegexPatternTypeFilter;

public class CoeusMigrationResolver
implements MigrationResolver {
    protected DataSource riceDataSource;
    protected String javaMigrationPath;

    public Set<ResolvedMigration> resolveMigrations(org.flywaydb.core.api.resolver.Context context) {
        HashSet<ResolvedMigration> migrations = new HashSet<ResolvedMigration>();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(true);
        provider.addIncludeFilter(new RegexPatternTypeFilter(Pattern.compile(".*")));
        Set<BeanDefinition> components = provider.findCandidateComponents(this.pathToPackage(this.javaMigrationPath));
        for (BeanDefinition component : components) {
            try {
                Class<?> clazz = Class.forName(component.getBeanClassName());
                if (!SqlExecutor.class.isAssignableFrom(clazz)) continue;
                SqlExecutor migration = (SqlExecutor)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (migration instanceof RiceDataSourceAware) {
                    ((RiceDataSourceAware)((Object)migration)).setRiceDataSource(this.riceDataSource);
                }
                migrations.add(new SqlExecutorMigrationAdapter(migration));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return migrations;
    }

    private String pathToPackage(String path) {
        String pkg = path.replaceAll("/", ".");
        while (pkg.endsWith(".")) {
            pkg = StringUtils.removeEnd(pkg, ".");
        }
        return pkg;
    }

    public CoeusMigrationResolver() {
    }

    public CoeusMigrationResolver(DataSource riceDataSource) {
        this.riceDataSource = riceDataSource;
    }

    public DataSource getRiceDataSource() {
        return this.riceDataSource;
    }

    public void setRiceDataSource(DataSource riceDataSource) {
        this.riceDataSource = riceDataSource;
    }

    public String getJavaMigrationPath() {
        return this.javaMigrationPath;
    }

    public void setJavaMigrationPath(String javaMigrationPath) {
        this.javaMigrationPath = javaMigrationPath;
    }

    private static class SqlExecutorMigrationAdapter
    implements ResolvedMigration,
    MigrationExecutor {
        private final SqlExecutor migration;

        private SqlExecutorMigrationAdapter(SqlExecutor o) {
            this.migration = o;
        }

        @Override
        public void execute(Context context) throws SQLException {
            this.migration.execute(context.getConnection());
        }

        @Override
        public boolean canExecuteInTransaction() {
            return this.migration.executeInTransaction();
        }

        @Override
        public Integer getChecksum() {
            return null;
        }

        @Override
        public String getPhysicalLocation() {
            return this.migration.getClass().getCanonicalName();
        }

        @Override
        public String getScript() {
            return this.migration.getClass().getSimpleName();
        }

        @Override
        public MigrationType getType() {
            return MigrationType.CUSTOM;
        }

        @Override
        public MigrationVersion getVersion() {
            return MigrationVersion.fromVersion(this.migration.getClass().getSimpleName().split("__")[0].substring(1));
        }

        @Override
        public String getDescription() {
            return this.migration.getClass().getSimpleName().split("__")[1];
        }

        @Override
        public MigrationExecutor getExecutor() {
            return this;
        }

        @Override
        public boolean checksumMatches(Integer checksum) {
            return true;
        }

        @Override
        public boolean checksumMatchesWithoutBeingIdentical(Integer checksum) {
            return true;
        }
    }
}

