/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.db.client;

import co.kuali.coeus.data.migration.FlywayMigrator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.flywaydb.core.api.FlywayException;

public class FlywayClient {
    private static final String COEUS_DATASOURCE = "coeusDataSource";
    private static final String RICE_DATASOURCE = "riceDataSource";
    private static final String DRIVER_NAME = "driverName";
    private static final String URL = "url";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String APPLY_DEMO = "applyDemo";
    private static final String APPLY_STAGING = "applyStaging";
    private static final String GRM = "grm";
    private static final String ENABLED = "enabled";
    private static final String SQL_MIGRATION_PATH = "sqlMigrationPath";
    private static final String JAVA_MIGRATION_PATH = "javaMigrationPath";
    private static final String INIT_VERSION = "initVersion";
    private static final String OUT_OF_ORDER = "outOfOrder";
    private static final String IGNORE_MISSING_MIGRATIONS = "ignoreMissingMigrations";
    private static final Logger LOG = LogManager.getLogger(FlywayClient.class);

    public static void main(String[] args) throws IOException {
        Map input = new ObjectMapper().readValue(System.in, HashMap.class);
        new FlywayClient().apply(input);
    }

    protected void apply(Map<String, Object> input) {
        LOG.info("Starting Flyway Migrator");
        Map coeusDataSourceInput = (Map)input.get(COEUS_DATASOURCE);
        String coeusDriverName = (String)coeusDataSourceInput.get(DRIVER_NAME);
        String coeusUrl = (String)coeusDataSourceInput.get(URL);
        String coeusUsername = (String)coeusDataSourceInput.get(USERNAME);
        String coeusPassword = (String)coeusDataSourceInput.get(PASSWORD);
        Map riceDataSourceInput = (Map)input.get(RICE_DATASOURCE);
        String riceDriverName = (String)riceDataSourceInput.get(DRIVER_NAME);
        String riceUrl = (String)riceDataSourceInput.get(URL);
        String riceUsername = (String)riceDataSourceInput.get(USERNAME);
        String ricePassword = (String)riceDataSourceInput.get(PASSWORD);
        Boolean applyDemo = (Boolean)input.get(APPLY_DEMO);
        Boolean applyStaging = (Boolean)input.get(APPLY_STAGING);
        Boolean grm = (Boolean)input.get(GRM);
        Boolean enabled = (Boolean)input.get(ENABLED);
        String sqlMigrationPath = (String)input.get(SQL_MIGRATION_PATH);
        String javaMigrationPath = (String)input.get(JAVA_MIGRATION_PATH);
        String initVersion = (String)input.get(INIT_VERSION);
        Boolean outOfOrder = (Boolean)input.get(OUT_OF_ORDER);
        Boolean ignoreMissingMigrations = (Boolean)input.get(IGNORE_MISSING_MIGRATIONS);
        FlywayMigrator migrator = new FlywayMigrator();
        migrator.setDataSource(this.retrieveDataSource(coeusDriverName, coeusUrl, coeusUsername, coeusPassword));
        migrator.setRiceDataSource(this.retrieveDataSource(riceDriverName, riceUrl, riceUsername, ricePassword));
        migrator.setManageRice(true);
        migrator.setEmbeddedMode(false);
        migrator.setApplyDemo(applyDemo);
        migrator.setApplyStaging(applyStaging);
        migrator.setGrm(grm);
        migrator.setEnabled(enabled);
        migrator.setSqlMigrationPath(sqlMigrationPath);
        migrator.setJavaMigrationPath(javaMigrationPath);
        migrator.setInitVersion(initVersion);
        migrator.setOutOfOrder(outOfOrder);
        migrator.setIgnoreMissingMigrations(ignoreMissingMigrations);
        String databaseName = coeusUrl;
        try (Connection connection = migrator.getDataSource().getConnection();){
            databaseName = connection.getCatalog();
        }
        catch (SQLException e) {
            LOG.error(String.format("Failed to retrieve connection from %s", databaseName), (Throwable)e);
        }
        try {
            migrator.migrate();
            LOG.info("SUCCESS");
        }
        catch (FlywayException e) {
            LOG.error(String.format("ERROR: Migration failed for %s", databaseName), (Throwable)e);
            System.exit(1);
        }
    }

    private DataSource retrieveDataSource(String driverName, String url, String username, String password) {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.addConnectionProperty("serverTimezone", "UTC");
        dataSource.setDefaultAutoCommit(false);
        dataSource.setAutoCommitOnReturn(false);
        dataSource.setDriverClassName(driverName);
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        return dataSource;
    }
}

