/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.statistics;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.core.InternalCache;
import org.ehcache.core.statistics.BulkOps;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.core.statistics.ChainedOperationObserver;
import org.ehcache.core.statistics.DefaultTierStatistics;
import org.ehcache.core.statistics.DelegatingOperationStatistic;
import org.ehcache.core.statistics.StatsUtils;
import org.ehcache.core.statistics.TierStatistics;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.ValueStatistics;

public class DefaultCacheStatistics
implements CacheStatistics {
    private volatile CompensatingCounters compensatingCounters = CompensatingCounters.empty();
    private final OperationStatistic<CacheOperationOutcomes.GetOutcome> get;
    private final OperationStatistic<CacheOperationOutcomes.PutOutcome> put;
    private final OperationStatistic<CacheOperationOutcomes.RemoveOutcome> remove;
    private final OperationStatistic<CacheOperationOutcomes.PutIfAbsentOutcome> putIfAbsent;
    private final OperationStatistic<CacheOperationOutcomes.ReplaceOutcome> replace;
    private final OperationStatistic<CacheOperationOutcomes.ConditionalRemoveOutcome> conditionalRemove;
    private final InternalCache<?, ?> cache;
    private final Map<String, TierStatistics> tierStatistics;
    private final TierStatistics lowestTier;
    private final Map<String, ValueStatistic<?>> knownStatistics;

    public DefaultCacheStatistics(InternalCache<?, ?> cache) {
        this.cache = cache;
        this.get = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.GetOutcome.class, "get");
        this.put = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.PutOutcome.class, "put");
        this.remove = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.RemoveOutcome.class, "remove");
        this.putIfAbsent = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.PutIfAbsentOutcome.class, "putIfAbsent");
        this.replace = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.ReplaceOutcome.class, "replace");
        this.conditionalRemove = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.ConditionalRemoveOutcome.class, "conditionalRemove");
        String[] tierNames = StatsUtils.findTiers(cache);
        String lowestTierName = StatsUtils.findLowestTier(tierNames);
        DefaultTierStatistics lowestTier = null;
        this.tierStatistics = new HashMap<String, TierStatistics>(tierNames.length);
        for (String tierName : tierNames) {
            DefaultTierStatistics tierStatistics = new DefaultTierStatistics(cache, tierName);
            this.tierStatistics.put(tierName, tierStatistics);
            if (!lowestTierName.equals(tierName)) continue;
            lowestTier = tierStatistics;
        }
        this.lowestTier = lowestTier;
        this.knownStatistics = this.createKnownStatistics();
    }

    @Override
    public <T extends Enum<T>, S extends ChainedOperationObserver<? super T>> void registerDerivedStatistic(Class<T> outcomeClass, String statName, S derivedStatistic) {
        DelegatingOperationStatistic<S> stat = new DelegatingOperationStatistic<S>(StatsUtils.findOperationStatisticOnChildren(this.cache, outcomeClass, statName));
        stat.addDerivedStatistic(derivedStatistic);
    }

    private Map<String, ValueStatistic<?>> createKnownStatistics() {
        HashMap knownStatistics = new HashMap(30);
        knownStatistics.put("Cache:HitCount", ValueStatistics.counter(this::getCacheHits));
        knownStatistics.put("Cache:MissCount", ValueStatistics.counter(this::getCacheMisses));
        knownStatistics.put("Cache:PutCount", ValueStatistics.counter(this::getCachePuts));
        knownStatistics.put("Cache:RemovalCount", ValueStatistics.counter(this::getCacheRemovals));
        knownStatistics.put("Cache:EvictionCount", ValueStatistics.counter(this::getCacheEvictions));
        knownStatistics.put("Cache:ExpirationCount", ValueStatistics.counter(this::getCacheExpirations));
        for (TierStatistics tier : this.tierStatistics.values()) {
            knownStatistics.putAll(tier.getKnownStatistics());
        }
        return Collections.unmodifiableMap(knownStatistics);
    }

    public Map<String, ValueStatistic<?>> getKnownStatistics() {
        return this.knownStatistics;
    }

    @Override
    public Map<String, TierStatistics> getTierStatistics() {
        return Collections.unmodifiableMap(this.tierStatistics);
    }

    @Override
    public void clear() {
        this.compensatingCounters = this.compensatingCounters.snapshot(this);
        for (TierStatistics t : this.tierStatistics.values()) {
            t.clear();
        }
    }

    @Override
    public long getCacheHits() {
        return DefaultCacheStatistics.normalize(this.getHits() - this.compensatingCounters.cacheHits);
    }

    @Override
    public float getCacheHitPercentage() {
        long cacheHits = this.getCacheHits();
        return DefaultCacheStatistics.normalize((float)cacheHits / (float)(cacheHits + this.getCacheMisses())) * 100.0f;
    }

    @Override
    public long getCacheMisses() {
        return DefaultCacheStatistics.normalize(this.getMisses() - this.compensatingCounters.cacheMisses);
    }

    @Override
    public float getCacheMissPercentage() {
        long cacheMisses = this.getCacheMisses();
        return DefaultCacheStatistics.normalize((float)cacheMisses / (float)(this.getCacheHits() + cacheMisses)) * 100.0f;
    }

    @Override
    public long getCacheGets() {
        return DefaultCacheStatistics.normalize(this.getHits() + this.getMisses() - this.compensatingCounters.cacheGets);
    }

    @Override
    public long getCachePuts() {
        return DefaultCacheStatistics.normalize(this.getBulkCount(BulkOps.PUT_ALL) + this.put.sum(EnumSet.of(CacheOperationOutcomes.PutOutcome.PUT)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.HIT)) - this.compensatingCounters.cachePuts);
    }

    @Override
    public long getCacheRemovals() {
        return DefaultCacheStatistics.normalize(this.getBulkCount(BulkOps.REMOVE_ALL) + this.remove.sum(EnumSet.of(CacheOperationOutcomes.RemoveOutcome.SUCCESS)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.SUCCESS)) - this.compensatingCounters.cacheRemovals);
    }

    @Override
    public long getCacheEvictions() {
        return DefaultCacheStatistics.normalize(this.lowestTier.getEvictions());
    }

    @Override
    public long getCacheExpirations() {
        return DefaultCacheStatistics.normalize(this.lowestTier.getExpirations());
    }

    private long getMisses() {
        return this.getBulkCount(BulkOps.GET_ALL_MISS) + this.get.sum(EnumSet.of(CacheOperationOutcomes.GetOutcome.MISS)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.MISS_NOT_PRESENT)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_MISSING));
    }

    private long getHits() {
        return this.getBulkCount(BulkOps.GET_ALL_HITS) + this.get.sum(EnumSet.of(CacheOperationOutcomes.GetOutcome.HIT)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.HIT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.HIT, CacheOperationOutcomes.ReplaceOutcome.MISS_PRESENT)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.SUCCESS, CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_PRESENT));
    }

    private long getBulkCount(BulkOps bulkOps) {
        return this.cache.getBulkMethodEntries().get((Object)bulkOps).longValue();
    }

    private static long normalize(long value) {
        return Math.max(0L, value);
    }

    private static float normalize(float value) {
        if (Float.isNaN(value)) {
            return 0.0f;
        }
        return Math.min(1.0f, Math.max(0.0f, value));
    }

    private static class CompensatingCounters {
        final long cacheHits;
        final long cacheMisses;
        final long cacheGets;
        final long cachePuts;
        final long cacheRemovals;

        private CompensatingCounters(long cacheHits, long cacheMisses, long cacheGets, long cachePuts, long cacheRemovals) {
            this.cacheHits = cacheHits;
            this.cacheMisses = cacheMisses;
            this.cacheGets = cacheGets;
            this.cachePuts = cachePuts;
            this.cacheRemovals = cacheRemovals;
        }

        static CompensatingCounters empty() {
            return new CompensatingCounters(0L, 0L, 0L, 0L, 0L);
        }

        CompensatingCounters snapshot(DefaultCacheStatistics statistics) {
            return new CompensatingCounters(this.cacheHits + statistics.getHits(), this.cacheMisses + statistics.getMisses(), this.cacheGets + statistics.getCacheGets(), this.cachePuts + statistics.getCachePuts(), this.cacheRemovals + statistics.getCacheRemovals());
        }
    }
}

