/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.statistics;

import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.core.InternalCache;
import org.ehcache.core.events.CacheManagerListener;
import org.ehcache.core.spi.service.CacheManagerProviderService;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.store.InternalCacheManager;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.core.statistics.DefaultCacheStatistics;
import org.ehcache.core.statistics.DelegatedMappedOperationStatistics;
import org.ehcache.core.statistics.DelegatingOperationObserver;
import org.ehcache.core.statistics.LatencyHistogramConfiguration;
import org.ehcache.core.statistics.OperationObserver;
import org.ehcache.core.statistics.OperationStatistic;
import org.ehcache.core.statistics.StatsUtils;
import org.ehcache.core.statistics.ZeroOperationStatistic;
import org.ehcache.spi.service.OptionalServiceDependencies;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.model.capabilities.descriptors.StatisticDescriptor;
import org.terracotta.management.model.stats.Statistic;
import org.terracotta.management.model.stats.StatisticRegistry;
import org.terracotta.management.model.stats.StatisticType;
import org.terracotta.statistics.MappedOperationStatistic;
import org.terracotta.statistics.StatisticBuilder;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.derived.OperationResultFilter;
import org.terracotta.statistics.derived.latency.DefaultLatencyHistogramStatistic;

@OptionalServiceDependencies(value={"org.ehcache.core.spi.service.CacheManagerProviderService"})
public class DefaultStatisticsService
implements StatisticsService,
CacheManagerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStatisticsService.class);
    private final ConcurrentMap<String, DefaultCacheStatistics> cacheStatistics = new ConcurrentHashMap<String, DefaultCacheStatistics>();
    private final ConcurrentMap<String, StatisticRegistry> statisticRegistries = new ConcurrentHashMap<String, StatisticRegistry>();
    private volatile InternalCacheManager cacheManager;
    private volatile boolean started = false;

    @Override
    public CacheStatistics getCacheStatistics(String cacheName) {
        CacheStatistics stats = (CacheStatistics)this.cacheStatistics.get(cacheName);
        if (stats == null) {
            throw new IllegalArgumentException("Unknown cache: " + cacheName);
        }
        return stats;
    }

    @Override
    public void registerWithParent(Object toAssociate, Object parent) {
        StatisticsManager.associate(toAssociate).withParent(parent);
    }

    @Override
    public <K, V, S extends Enum<S>, T extends Enum<T>> OperationStatistic<T> registerStoreStatistics(Store<K, V> store, String targetName, int tierHeight, String tag, Map<T, Set<S>> translation, String statisticName) {
        Class<S> outcomeType = DefaultStatisticsService.getOutcomeType(translation);
        if (StatsUtils.hasOperationStat(store, outcomeType, targetName)) {
            MappedOperationStatistic<S, T> operationStatistic = new MappedOperationStatistic<S, T>(store, translation, statisticName, tierHeight, targetName, tag);
            StatisticsManager.associate(operationStatistic).withParent(store);
            DelegatedMappedOperationStatistics<S, T> stat = new DelegatedMappedOperationStatistics<S, T>(operationStatistic);
            return stat;
        }
        return ZeroOperationStatistic.get();
    }

    private static <S extends Enum<S>, T extends Enum<T>> Class<S> getOutcomeType(Map<T, Set<S>> translation) {
        Map.Entry<T, Set<S>> first = translation.entrySet().iterator().next();
        Class outcomeType = ((Enum)first.getValue().iterator().next()).getDeclaringClass();
        return outcomeType;
    }

    @Override
    public void deRegisterFromParent(Object toDeassociate, Object parent) {
        StatisticsManager.dissociate(toDeassociate).fromParent(parent);
    }

    @Override
    public void cleanForNode(Object node) {
        StatisticsManager.nodeFor(node).clean();
    }

    @Override
    public <K, V> void createCacheRegistry(String cacheName, Cache<K, V> cache, LongSupplier timeSource) {
        this.statisticRegistries.put(cacheName, new StatisticRegistry(cache, timeSource));
    }

    @Override
    public void registerCacheStatistics(String cacheName) {
        ((DefaultCacheStatistics)this.cacheStatistics.get(cacheName)).getKnownStatistics().forEach(((StatisticRegistry)this.statisticRegistries.get(cacheName))::registerStatistic);
    }

    @Override
    public Collection<StatisticDescriptor> getCacheDescriptors(String cacheName) {
        return ((StatisticRegistry)this.statisticRegistries.get(cacheName)).getDescriptors();
    }

    @Override
    public <T extends Enum<T>, K, V> void registerDerivedStatistics(String cacheName, Cache<K, V> cache, String statName, T outcome, String derivedName, LatencyHistogramConfiguration configuration) {
        DefaultLatencyHistogramStatistic histogram = new DefaultLatencyHistogramStatistic(configuration.getPhi(), configuration.getBucketCount(), configuration.getWindow());
        Class<?> outcomeClass = outcome.getClass();
        org.terracotta.statistics.OperationStatistic<?> stat = StatsUtils.findOperationStatisticOnChildren(cache, outcomeClass, statName);
        stat.addDerivedStatistic(new OperationResultFilter<T>(EnumSet.of(outcome), histogram));
        ((StatisticRegistry)this.statisticRegistries.get(cacheName)).registerStatistic(derivedName + "#50", histogram.medianStatistic());
        ((StatisticRegistry)this.statisticRegistries.get(cacheName)).registerStatistic(derivedName + "#95", histogram.percentileStatistic(0.95));
        ((StatisticRegistry)this.statisticRegistries.get(cacheName)).registerStatistic(derivedName + "#99", histogram.percentileStatistic(0.99));
        ((StatisticRegistry)this.statisticRegistries.get(cacheName)).registerStatistic(derivedName + "#100", histogram.maximumStatistic());
    }

    @Override
    public Map<String, Statistic<? extends Serializable>> collectStatistics(String cacheName, Collection<String> statisticNames, long since) {
        return StatisticRegistry.collect((StatisticRegistry)this.statisticRegistries.get(cacheName), statisticNames, since);
    }

    @Override
    public <T extends Serializable> void registerStatistic(Object context, String name, StatisticType type, Set<String> tags, Supplier<T> valueSupplier) {
        StatisticsManager.createPassThroughStatistic(context, name, tags, StatisticType.convert(type), valueSupplier);
    }

    @Override
    public <T extends Enum<T>> OperationObserver<T> createOperationStatistics(String name, Class<T> outcome, String tag, Object context) {
        return new DelegatingOperationObserver(((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(outcome).named(name)).of(context)).tag(tag)).build());
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start(ServiceProvider<Service> serviceProvider) {
        LOGGER.debug("Starting service");
        CacheManagerProviderService cacheManagerProviderService = serviceProvider.getService(CacheManagerProviderService.class);
        if (cacheManagerProviderService != null) {
            this.cacheManager = cacheManagerProviderService.getCacheManager();
            this.cacheManager.registerListener(this);
        }
        this.started = true;
    }

    @Override
    public void stop() {
        LOGGER.debug("Stopping service");
        this.cacheManager.deregisterListener(this);
        this.cacheStatistics.clear();
        this.started = false;
    }

    @Override
    public void stateTransition(Status from, Status to) {
        LOGGER.debug("Moving from " + (Object)((Object)from) + " to " + (Object)((Object)to));
        switch (to) {
            case AVAILABLE: {
                this.registerAllCaches();
                break;
            }
            case UNINITIALIZED: {
                this.cacheManager.deregisterListener(this);
                this.cacheStatistics.clear();
                break;
            }
            case MAINTENANCE: {
                throw new IllegalStateException("Should not be started in maintenance mode");
            }
            default: {
                throw new AssertionError((Object)("Unsupported state: " + (Object)((Object)to)));
            }
        }
    }

    private void registerAllCaches() {
        for (Map.Entry<String, CacheConfiguration<?, ?>> entry : this.cacheManager.getRuntimeConfiguration().getCacheConfigurations().entrySet()) {
            String alias = entry.getKey();
            CacheConfiguration<?, ?> configuration = entry.getValue();
            Cache<?, ?> cache = this.cacheManager.getCache(alias, configuration.getKeyType(), configuration.getValueType());
            this.cacheAdded(alias, cache);
        }
    }

    @Override
    public void cacheAdded(String alias, Cache<?, ?> cache) {
        LOGGER.debug("Cache added " + alias);
        this.cacheStatistics.put(alias, new DefaultCacheStatistics((InternalCache)cache));
    }

    @Override
    public void cacheRemoved(String alias, Cache<?, ?> cache) {
        LOGGER.debug("Cache removed " + alias);
        this.cacheStatistics.remove(alias);
    }
}

