/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceType;
import org.ehcache.config.SizedResourcePool;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.impl.config.SizedResourcePoolImpl;
import org.ehcache.xml.CacheResourceConfigurationParser;
import org.ehcache.xml.DomUtil;
import org.ehcache.xml.XmlConfiguration;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.CacheType;
import org.ehcache.xml.model.Disk;
import org.ehcache.xml.model.Heap;
import org.ehcache.xml.model.MemoryType;
import org.ehcache.xml.model.MemoryUnit;
import org.ehcache.xml.model.ObjectFactory;
import org.ehcache.xml.model.Offheap;
import org.ehcache.xml.model.PersistableMemoryType;
import org.ehcache.xml.model.ResourceType;
import org.ehcache.xml.model.ResourceUnit;
import org.ehcache.xml.model.ResourcesType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ResourceConfigurationParser {
    private static final Schema CORE_SCHEMA;
    private static final String CORE_SCHEMA_NS;
    private final JAXBContext jaxbContext;
    private final Set<CacheResourceConfigurationParser> extensionParsers;

    public ResourceConfigurationParser(Set<CacheResourceConfigurationParser> extensionParsers) {
        this.extensionParsers = extensionParsers;
        try {
            this.jaxbContext = JAXBContext.newInstance(ResourcesType.class);
        }
        catch (JAXBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ResourcePools parseResourceConfiguration(CacheTemplate cacheTemplate, ResourcePoolsBuilder resourcePoolsBuilder) {
        if (cacheTemplate.getHeap() != null) {
            resourcePoolsBuilder = resourcePoolsBuilder.with(this.parseHeapConfiguration(cacheTemplate.getHeap()));
        } else if (!cacheTemplate.getResources().isEmpty()) {
            for (Element element : cacheTemplate.getResources()) {
                SizedResourcePoolImpl<SizedResourcePool> resourcePool;
                block12: {
                    if (!CORE_SCHEMA_NS.equals(element.getNamespaceURI())) {
                        resourcePool = this.parseResourceExtension(element);
                    } else {
                        try {
                            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
                            unmarshaller.setSchema(CORE_SCHEMA);
                            Object resource = unmarshaller.unmarshal(element);
                            if (resource instanceof Heap) {
                                resourcePool = this.parseHeapConfiguration((Heap)resource);
                                break block12;
                            }
                            if (resource instanceof Offheap) {
                                MemoryType offheapResource = (MemoryType)((Offheap)resource).getValue();
                                resourcePool = new SizedResourcePoolImpl<SizedResourcePool>(ResourceType.Core.OFFHEAP, offheapResource.getValue().longValue(), ResourceConfigurationParser.parseMemory(offheapResource), false);
                                break block12;
                            }
                            if (resource instanceof Disk) {
                                PersistableMemoryType diskResource = (PersistableMemoryType)((Disk)resource).getValue();
                                resourcePool = new SizedResourcePoolImpl<SizedResourcePool>(ResourceType.Core.DISK, diskResource.getValue().longValue(), ResourceConfigurationParser.parseMemory(diskResource), diskResource.isPersistent());
                                break block12;
                            }
                            throw new AssertionError((Object)("Unrecognized resource: " + element + " / " + resource.getClass().getName()));
                        }
                        catch (JAXBException e) {
                            throw new IllegalArgumentException("Can't find parser for resource: " + element, e);
                        }
                    }
                }
                resourcePoolsBuilder = resourcePoolsBuilder.with(resourcePool);
            }
        } else {
            throw new XmlConfigurationException("No resources defined for the cache: " + cacheTemplate.id());
        }
        return resourcePoolsBuilder.build();
    }

    private ResourcePool parseHeapConfiguration(Heap heap) {
        ResourceType heapResource = (ResourceType)heap.getValue();
        return new SizedResourcePoolImpl<SizedResourcePool>(ResourceType.Core.HEAP, heapResource.getValue().longValue(), ResourceConfigurationParser.parseUnit(heapResource), false);
    }

    private static org.ehcache.config.ResourceUnit parseUnit(ResourceType resourceType) {
        if (resourceType.getUnit().value().equalsIgnoreCase("entries")) {
            return EntryUnit.ENTRIES;
        }
        return org.ehcache.config.units.MemoryUnit.valueOf(resourceType.getUnit().value().toUpperCase());
    }

    private static org.ehcache.config.units.MemoryUnit parseMemory(MemoryType memoryType) {
        return org.ehcache.config.units.MemoryUnit.valueOf(memoryType.getUnit().value().toUpperCase());
    }

    ResourcePool parseResourceExtension(Element element) {
        for (CacheResourceConfigurationParser parser : this.extensionParsers) {
            ResourcePool resourcePool = parser.parseResourceConfiguration(element);
            if (resourcePool == null) continue;
            return resourcePool;
        }
        throw new XmlConfigurationException("Can't find parser for element: " + element);
    }

    public CacheType unparseResourceConfiguration(ResourcePools resourcePools, CacheType cacheType) {
        ArrayList<Element> resources = new ArrayList<Element>();
        resourcePools.getResourceTypeSet().forEach(resourceType -> {
            Element element;
            Object resourcePool = resourcePools.getPoolForResource(resourceType);
            if (resourceType instanceof ResourceType.Core) {
                MemoryType memoryType;
                JAXBElement resource;
                SizedResourcePool pool = (SizedResourcePool)resourcePool;
                if (resourceType == ResourceType.Core.HEAP) {
                    Heap heap = new Heap();
                    ResourceType xmlResourceType = new ResourceType().withValue(BigInteger.valueOf(pool.getSize())).withUnit(ResourceConfigurationParser.unparseUnit(pool.getUnit()));
                    heap.setValue(xmlResourceType);
                    resource = heap;
                } else if (resourceType == ResourceType.Core.OFFHEAP) {
                    Offheap offheap = new Offheap();
                    memoryType = new MemoryType().withValue(BigInteger.valueOf(pool.getSize())).withUnit(ResourceConfigurationParser.unparseMemory((org.ehcache.config.units.MemoryUnit)pool.getUnit()));
                    offheap.setValue(memoryType);
                    resource = offheap;
                } else if (resourceType == ResourceType.Core.DISK) {
                    Disk disk = new Disk();
                    memoryType = new PersistableMemoryType().withValue(BigInteger.valueOf(pool.getSize())).withUnit(ResourceConfigurationParser.unparseMemory((org.ehcache.config.units.MemoryUnit)pool.getUnit())).withPersistent(pool.isPersistent());
                    disk.setValue(memoryType);
                    resource = disk;
                } else {
                    throw new AssertionError((Object)("Unrecognized core resource type: " + resourceType));
                }
                try {
                    Document document = DomUtil.createAndGetDocumentBuilder().newDocument();
                    Marshaller marshaller = this.jaxbContext.createMarshaller();
                    marshaller.setSchema(CORE_SCHEMA);
                    marshaller.marshal((Object)resource, document);
                    element = document.getDocumentElement();
                }
                catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
                    throw new XmlConfigurationException(e);
                }
            } else {
                HashMap parsers = new HashMap();
                this.extensionParsers.forEach(parser -> parser.getResourceTypes().forEach(rt -> parsers.put(rt, parser)));
                CacheResourceConfigurationParser parser2 = (CacheResourceConfigurationParser)parsers.get(resourcePool.getClass());
                if (parser2 != null) {
                    element = parser2.unparseResourcePool((ResourcePool)resourcePool);
                } else {
                    throw new AssertionError((Object)("Parser not found for resource type: " + resourceType));
                }
            }
            resources.add(element);
        });
        return cacheType.withResources(new ResourcesType().withResource(resources));
    }

    private static ResourceUnit unparseUnit(org.ehcache.config.ResourceUnit resourceUnit) {
        if (resourceUnit instanceof EntryUnit) {
            return ResourceUnit.ENTRIES;
        }
        return ResourceUnit.fromValue(resourceUnit.toString());
    }

    private static MemoryUnit unparseMemory(org.ehcache.config.units.MemoryUnit memoryUnit) {
        return MemoryUnit.fromValue(memoryUnit.toString());
    }

    static {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            CORE_SCHEMA = schemaFactory.newSchema(XmlConfiguration.CORE_SCHEMA_URL);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        ObjectFactory factory = new ObjectFactory();
        CORE_SCHEMA_NS = factory.createResource(factory.createResourceType()).getName().getNamespaceURI();
    }
}

