/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.criteria;

import java.math.BigInteger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.kuali.rice.core.api.criteria.CriteriaValue;

@XmlRootElement(name="integerValue")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="CriteriaIntegerValueType")
public final class CriteriaIntegerValue
implements CriteriaValue<BigInteger> {
    @XmlValue
    private BigInteger value;

    CriteriaIntegerValue() {
        this.value = null;
    }

    CriteriaIntegerValue(BigInteger value) {
        CriteriaIntegerValue.validateValue(value);
        this.value = CriteriaIntegerValue.safeInstance(value);
    }

    CriteriaIntegerValue(Number value) {
        CriteriaIntegerValue.validateValue(value);
        this.value = BigInteger.valueOf(value.longValue());
    }

    private static void validateValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
    }

    private static BigInteger safeInstance(BigInteger val) {
        if (val.getClass() != BigInteger.class) {
            return new BigInteger(val.toByteArray());
        }
        return val;
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(obj, this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "integerValue";
        static final String TYPE_NAME = "CriteriaIntegerValueType";

        Constants() {
        }
    }
}

