/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.mo.ModelBuilder;

public final class GenericQueryResults<T>
implements QueryResults<T> {
    private List<T> results;
    private final Integer totalRowCount;
    private final boolean moreResultsAvailable;

    private GenericQueryResults(Builder<T> builder) {
        this.results = builder.getResults() != null ? new ArrayList<T>(builder.getResults()) : new ArrayList();
        this.totalRowCount = builder.getTotalRowCount();
        this.moreResultsAvailable = builder.isMoreResultsAvailable();
    }

    @Override
    public List<T> getResults() {
        return this.results;
    }

    @Override
    public Integer getTotalRowCount() {
        return this.totalRowCount;
    }

    @Override
    public boolean isMoreResultsAvailable() {
        return this.moreResultsAvailable;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(obj, this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public static final class Builder<T>
    implements ModelBuilder,
    QueryResults<T>,
    Serializable {
        private List<T> results = new ArrayList<T>();
        private Integer totalRowCount;
        private boolean moreResultsAvailable = false;

        public static <T> Builder create() {
            return new Builder<T>();
        }

        private Builder() {
        }

        @Override
        public GenericQueryResults<T> build() {
            return new GenericQueryResults(this);
        }

        @Override
        public List<T> getResults() {
            return this.results;
        }

        public void setResults(List<T> results) {
            if (results == null) {
                throw new IllegalArgumentException("results is null");
            }
            this.results = Collections.unmodifiableList(new ArrayList<T>(results));
        }

        @Override
        public Integer getTotalRowCount() {
            return this.totalRowCount;
        }

        public void setTotalRowCount(Integer totalRowCount) {
            if (totalRowCount != null && totalRowCount < 0) {
                throw new IllegalArgumentException("totalRowCount < 0");
            }
            this.totalRowCount = totalRowCount;
        }

        @Override
        public boolean isMoreResultsAvailable() {
            return this.moreResultsAvailable;
        }

        public void setMoreResultsAvailable(boolean moreResultsAvailable) {
            this.moreResultsAvailable = moreResultsAvailable;
        }
    }
}

