/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.resourceloader;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.xml.namespace.QName;
import org.apache.commons.lang.ArrayUtils;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoaderException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.InitializingBean;

public class LazyResourceFactoryBean
implements FactoryBean<Object>,
InitializingBean {
    private String serviceNamespace;
    private String serviceName;
    private Class<?> objectType = Object.class;
    private Class<?>[] proxyInterfaces = null;
    private Object proxyObject;

    @Override
    public void afterPropertiesSet() throws Exception {
        if (ArrayUtils.isEmpty(this.getProxyInterfaces())) {
            this.setProxyInterfaces(this.detectProxyInterfaces());
            if (ArrayUtils.isEmpty(this.getProxyInterfaces())) {
                throw new FactoryBeanNotInitializedException("Failed to initialize factory bean because proxyInterfaces were not injected or could not be derived from object type.");
            }
        }
        this.proxyObject = Proxy.newProxyInstance(this.getClass().getClassLoader(), this.getProxyInterfaces(), (InvocationHandler)new LazyInvocationHandler());
    }

    protected Class<?>[] detectProxyInterfaces() {
        Class<?> type = this.getObjectType();
        if (type != null && type.isInterface()) {
            return new Class[]{type};
        }
        if (type != null) {
            return type.getInterfaces();
        }
        return null;
    }

    @Override
    public Object getObject() throws Exception {
        return this.proxyObject;
    }

    @Override
    public Class<?> getObjectType() {
        return this.objectType;
    }

    public void setObjectType(Class<?> objectType) {
        this.objectType = objectType;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public String getServiceNamespace() {
        return this.serviceNamespace;
    }

    public void setServiceNamespace(String serviceNamespace) {
        this.serviceNamespace = serviceNamespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Class<?>[] getProxyInterfaces() {
        return this.proxyInterfaces;
    }

    public void setProxyInterfaces(Class<?>[] proxyInterfaces) {
        this.proxyInterfaces = proxyInterfaces;
    }

    private class LazyInvocationHandler
    implements InvocationHandler {
        private volatile Object service = null;

        private LazyInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (this.service == null) {
                    QName name = new QName(LazyResourceFactoryBean.this.getServiceNamespace(), LazyResourceFactoryBean.this.getServiceName());
                    this.service = GlobalResourceLoader.getService(name);
                    if (this.service == null) {
                        throw new ResourceLoaderException("Failed to locate resource with name: " + name);
                    }
                }
                return method.invoke(this.service, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

