/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public enum Truth {
    TRUE("true", "yes", "Y", "on", "1", "t", "enabled"),
    FALSE("false", "no", "N", "off", "0", "f", "disabled");

    private final Collection<String> truthStrings;

    private Truth(String ... vals) {
        this.truthStrings = Collections.unmodifiableCollection(Arrays.asList(vals));
    }

    public Collection<String> getTruthStrings() {
        return this.truthStrings;
    }

    public static Boolean strToBooleanIgnoreCase(String str) {
        return Truth.strToBooleanIgnoreCase(str, null);
    }

    public static Boolean strToBooleanIgnoreCase(String str, Boolean defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        for (String s2 : TRUE.getTruthStrings()) {
            if (!s2.equalsIgnoreCase(str)) continue;
            return Boolean.TRUE;
        }
        for (String s2 : FALSE.getTruthStrings()) {
            if (!s2.equalsIgnoreCase(str)) continue;
            return Boolean.FALSE;
        }
        return defaultValue;
    }
}

