/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class VersionHelper {
    private static final Pattern extractVersion = Pattern.compile("(\\D*)((\\d*\\.?)+)(\\S*)");
    private static final Pattern splitVersion = Pattern.compile("\\.");

    public static int compareVersion(String versionOne, String versionTwo) {
        try {
            return VersionHelper.compareVersionInt(versionOne, versionTwo);
        }
        catch (IllegalArgumentException iae) {
            return -1;
        }
    }

    private static int compareVersionInt(String versionOne, String versionTwo) throws IllegalArgumentException {
        if (StringUtils.isBlank(versionOne) || StringUtils.isBlank(versionTwo)) {
            throw new IllegalArgumentException("Invalid argument");
        }
        Matcher m1 = extractVersion.matcher(versionOne);
        Matcher m22 = extractVersion.matcher(versionTwo);
        if (!m1.matches() || !m22.matches()) {
            throw new IllegalArgumentException("Unable to extract version number from string using regex");
        }
        String sanitizedVOne = versionOne.substring(m1.start(2), m1.end(2));
        String sanitizedVTwo = versionTwo.substring(m22.start(2), m22.end(2));
        String[] oneDigits = splitVersion.split(sanitizedVOne);
        String[] twoDigits = splitVersion.split(sanitizedVTwo);
        int length = 0;
        length = oneDigits.length < twoDigits.length ? oneDigits.length : twoDigits.length;
        for (int i = 0; i < length; ++i) {
            Integer intTwo;
            Integer intOne = Integer.valueOf(oneDigits[i]);
            Integer compare = intOne.compareTo(intTwo = Integer.valueOf(twoDigits[i]));
            if (compare < 0) {
                return -1;
            }
            if (compare <= 0) continue;
            return 1;
        }
        if (oneDigits.length < twoDigits.length) {
            return -1;
        }
        if (oneDigits.length == twoDigits.length) {
            return 0;
        }
        return 1;
    }
}

