/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.collect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kuali.rice.core.api.exception.RiceRuntimeException;

public final class ConstantsMap
implements Map<String, Object> {
    private Map<String, Object> map;

    public void setConstantClass(Class<?> constantClass) {
        HashMap<String, Object> m3 = new HashMap<String, Object>();
        this.publishFields(m3, constantClass);
        this.map = Collections.unmodifiableMap(m3);
    }

    private void publishFields(Map<String, Object> constantMap, Class<?> c) {
        Field[] fields;
        for (Field field : fields = c.getDeclaredFields()) {
            int modifier = field.getModifiers();
            if (!Modifier.isStatic(modifier) || !Modifier.isFinal(modifier) || Modifier.isPrivate(modifier)) continue;
            try {
                String fieldName = field.getName();
                constantMap.put(fieldName, field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new ConstantExporterException(e);
            }
        }
        this.publishMemberClassFields(constantMap, c);
    }

    private void publishMemberClassFields(Map<String, Object> constantMap, Class<?> c) {
        Class<?>[] memberClasses;
        for (Class<?> memberClass : memberClasses = c.getClasses()) {
            if (memberClass.isAnonymousClass()) continue;
            String memberPrefix = memberClass.getSimpleName();
            HashMap<String, Object> subclassMap = new HashMap<String, Object>();
            this.publishFields(subclassMap, memberClass);
            constantMap.put(memberPrefix, Collections.unmodifiableMap(subclassMap));
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m3) {
        this.map.putAll(m3);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    private static class ConstantExporterException
    extends RiceRuntimeException {
        private ConstantExporterException(Throwable t) {
            super(t);
        }
    }
}

