/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PropertiesMap
implements Map {
    private PropertyTree propertyTree;

    public void setProperties(Properties properties) {
        this.propertyTree = new PropertyTree(properties);
    }

    public Object get(Object key) {
        if (this.propertyTree == null) {
            throw new IllegalStateException("propertyTree has not been initialized");
        }
        return this.propertyTree.get(key);
    }

    @Override
    public int size() {
        if (this.propertyTree == null) {
            throw new IllegalStateException("propertyTree has not been initialized");
        }
        return this.propertyTree.size();
    }

    @Override
    public void clear() {
        if (this.propertyTree == null) {
            throw new IllegalStateException("propertyTree has not been initialized");
        }
        this.propertyTree.clear();
    }

    @Override
    public boolean isEmpty() {
        if (this.propertyTree == null) {
            throw new IllegalStateException("propertyTree has not been initialized");
        }
        return this.propertyTree.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.propertyTree == null) {
            throw new IllegalStateException("propertyTree has not been initialized");
        }
        return this.propertyTree.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.propertyTree == null) {
            throw new IllegalStateException("propertyTree has not been initialized");
        }
        return this.propertyTree.containsValue(value);
    }

    public Collection values() {
        if (this.propertyTree == null) {
            throw new IllegalStateException("propertyTree has not been initialized");
        }
        return this.propertyTree.values();
    }

    public void putAll(Map m3) {
        if (this.propertyTree == null) {
            throw new IllegalStateException("propertyTree has not been initialized");
        }
        this.propertyTree.putAll(m3);
    }

    public Set entrySet() {
        if (this.propertyTree == null) {
            throw new IllegalStateException("propertyTree has not been initialized");
        }
        return this.propertyTree.entrySet();
    }

    public Set keySet() {
        if (this.propertyTree == null) {
            throw new IllegalStateException("propertyTree has not been initialized");
        }
        return this.propertyTree.keySet();
    }

    public Object remove(Object key) {
        if (this.propertyTree == null) {
            throw new IllegalStateException("propertyTree has not been initialized");
        }
        return this.propertyTree.remove(key);
    }

    public Object put(Object key, Object value) {
        if (this.propertyTree == null) {
            throw new IllegalStateException("propertyTree has not been initialized");
        }
        return this.propertyTree.put(key, value);
    }

    static class PropertyTree
    implements Map {
        private static final Logger LOG = LogManager.getLogger(PropertyTree.class);
        final boolean flat;
        final PropertyTree parent;
        String directValue;
        Map children;

        public PropertyTree() {
            this(false);
        }

        public PropertyTree(boolean flat) {
            this.parent = null;
            this.children = new LinkedHashMap();
            this.flat = flat;
        }

        private PropertyTree(PropertyTree parent) {
            this.parent = parent;
            this.children = new LinkedHashMap();
            this.flat = parent.flat;
        }

        public PropertyTree(Properties properties) {
            this();
            this.setProperties(properties);
        }

        public void setProperty(String key, String value) {
            this.validateKey(key);
            this.validateValue(value);
            if (this.parent == null) {
                LOG.debug("setting (k,v) (" + key + "," + value + ")");
            }
            if (StringUtils.contains(key, '.')) {
                String prefix = StringUtils.substringBefore(key, ".");
                String suffix = StringUtils.substringAfter(key, ".");
                PropertyTree node = this.getChild(prefix);
                node.setProperty(suffix, value);
            } else {
                PropertyTree node = this.getChild(key);
                node.setDirectValue(value);
            }
        }

        public void setProperties(Properties properties) {
            if (properties == null) {
                throw new IllegalArgumentException("invalid (null) Properties object");
            }
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                this.setProperty((String)e.getKey(), (String)e.getValue());
            }
        }

        private PropertyTree getSubtree(String key) {
            this.validateKey(key);
            PropertyTree returnValue = null;
            if (StringUtils.contains(key, '.')) {
                String prefix = StringUtils.substringBefore(key, ".");
                String suffix = StringUtils.substringAfter(key, ".");
                PropertyTree child = (PropertyTree)this.children.get(prefix);
                if (child != null) {
                    returnValue = child.getSubtree(suffix);
                }
            } else {
                returnValue = (PropertyTree)this.children.get(key);
            }
            return returnValue;
        }

        public String getProperty(String key) {
            String propertyValue = null;
            PropertyTree subtree = this.getSubtree(key);
            if (subtree != null) {
                propertyValue = subtree.getDirectValue();
            }
            return propertyValue;
        }

        public Map getDirectChildren() {
            return Collections.unmodifiableMap(this.children);
        }

        public String toString() {
            return this.getDirectValue();
        }

        private void setDirectValue(String value) {
            this.validateValue(value);
            this.directValue = value;
        }

        private String getDirectValue() {
            return this.directValue;
        }

        private boolean hasDirectValue() {
            return this.directValue != null;
        }

        private boolean hasChildren() {
            return !this.children.isEmpty();
        }

        private PropertyTree getChild(String key) {
            this.validateKey(key);
            PropertyTree child = (PropertyTree)this.children.get(key);
            if (child == null) {
                child = new PropertyTree(this);
                this.children.put(key, child);
            }
            return child;
        }

        private void validateKey(Object key) {
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("invalid (non-String) key");
            }
            if (key == null) {
                throw new IllegalArgumentException("invalid (null) key");
            }
        }

        private void validateValue(Object value) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("invalid (non-String) value");
            }
            if (value == null) {
                throw new IllegalArgumentException("invalid (null) value");
            }
        }

        public Set entrySet() {
            return Collections.unmodifiableSet(this.collectEntries(null, this.flat).entrySet());
        }

        private Map collectEntries(String prefix, boolean flattenEntries) {
            LinkedHashMap<String, String> entryMap = new LinkedHashMap<String, String>();
            for (Map.Entry e : this.children.entrySet()) {
                PropertyTree child = (PropertyTree)e.getValue();
                String childKey = (String)e.getKey();
                if (child.hasDirectValue()) {
                    String entryKey = prefix == null ? childKey : prefix + "." + childKey;
                    String entryValue = child.getDirectValue();
                    entryMap.put(entryKey, entryValue);
                }
                if (flattenEntries || !child.hasChildren()) continue;
                String childPrefix = prefix == null ? childKey : prefix + "." + childKey;
                entryMap.putAll(child.collectEntries(childPrefix, flattenEntries));
            }
            return entryMap;
        }

        @Override
        public int size() {
            return this.entrySet().size();
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet().isEmpty();
        }

        public Collection values() {
            ArrayList values = new ArrayList();
            Set entrySet = this.entrySet();
            for (Map.Entry e : entrySet) {
                values.add(e.getValue());
            }
            return Collections.unmodifiableList(values);
        }

        public Set keySet() {
            LinkedHashSet keys = new LinkedHashSet();
            Set entrySet = this.entrySet();
            for (Map.Entry e : entrySet) {
                keys.add(e.getKey());
            }
            return Collections.unmodifiableSet(keys);
        }

        @Override
        public boolean containsKey(Object key) {
            this.validateKey(key);
            boolean containsKey = false;
            Set entrySet = this.entrySet();
            Iterator i = entrySet.iterator();
            while (!containsKey && i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                Object entryKey = e.getKey();
                containsKey = entryKey != null && entryKey.equals(key);
            }
            return containsKey;
        }

        @Override
        public boolean containsValue(Object value) {
            this.validateValue(value);
            boolean containsValue = false;
            Set entrySet = this.entrySet();
            Iterator i = entrySet.iterator();
            while (!containsValue && i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                Object entryValue = e.getValue();
                containsValue = entryValue != null && entryValue.equals(value);
            }
            return containsValue;
        }

        public Object get(Object key) {
            this.validateKey(key);
            return this.getSubtree((String)key);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

