/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.io;

import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.cache.CopiedObject;

public class SerializationUtils
extends org.apache.commons.lang.SerializationUtils {
    public static String serializeToBase64(Serializable object) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot serialize a null object");
        }
        byte[] serializedBytes = org.apache.commons.lang.SerializationUtils.serialize(object);
        return new Base64().encodeAsString(serializedBytes);
    }

    public static Serializable deserializeFromBase64(String base64Value) {
        if (StringUtils.isBlank(base64Value)) {
            throw new IllegalArgumentException("Cannot deserialize a null or blank base64 string value.");
        }
        byte[] decoded = new Base64().decode(base64Value);
        return (Serializable)org.apache.commons.lang.SerializationUtils.deserialize(decoded);
    }

    public static Serializable deepCopy(Serializable src) {
        CopiedObject co = SerializationUtils.deepCopyForCaching(src);
        return co.getContent();
    }

    public static CopiedObject deepCopyForCaching(Serializable src) {
        CopiedObject<Serializable> co = new CopiedObject<Serializable>();
        co.setContent(src);
        return co;
    }

    private SerializationUtils() {
        throw new UnsupportedOperationException("Should never be invoked.");
    }
}

