/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.type;

import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractKualiDecimal<T extends AbstractKualiDecimal<T>>
extends Number
implements Comparable<T> {
    public static final int ROUND_BEHAVIOR = 4;
    protected BigDecimal value;

    public AbstractKualiDecimal() {
    }

    public AbstractKualiDecimal(String value, int scale) {
        this.value = StringUtils.isBlank(value) ? BigDecimal.ZERO.setScale(scale, 4) : new BigDecimal(value).setScale(scale, 4);
    }

    public AbstractKualiDecimal(int value, int scale) {
        this.value = new BigDecimal(value).setScale(scale, 4);
    }

    public AbstractKualiDecimal(double value, int scale) {
        this.value = new BigDecimal(value).setScale(scale, 4);
    }

    public AbstractKualiDecimal(BigDecimal value, int scale) {
        this(value.toPlainString(), scale);
    }

    public boolean isLessThan(T operand) {
        if (operand == null) {
            throw new IllegalArgumentException("invalid (null) operand");
        }
        return this.compareTo(operand) < 0;
    }

    public boolean isGreaterThan(T operand) {
        if (operand == null) {
            throw new IllegalArgumentException("invalid (null) operand");
        }
        return this.compareTo(operand) > 0;
    }

    public boolean isLessEqual(T operand) {
        if (operand == null) {
            throw new IllegalArgumentException("invalid (null) operand");
        }
        return !this.isGreaterThan(operand);
    }

    public boolean isGreaterEqual(T operand) {
        if (operand == null) {
            throw new IllegalArgumentException("invalid (null) operand");
        }
        return !this.isLessThan(operand);
    }

    public static boolean isNumeric(String s2) {
        boolean isValid = false;
        if (!StringUtils.isBlank(s2)) {
            try {
                new BigDecimal(s2);
                isValid = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return isValid;
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    @Override
    public int compareTo(T o) {
        return this.value.compareTo(((AbstractKualiDecimal)o).value);
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof AbstractKualiDecimal) {
            AbstractKualiDecimal k = (AbstractKualiDecimal)obj;
            equals = this.compareTo((T)k) == 0;
        }
        return equals;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean isNegative() {
        return this.compareTo(this.zero()) == -1;
    }

    public boolean isPositive() {
        return this.compareTo(this.zero()) == 1;
    }

    public boolean isZero() {
        return this.compareTo(this.zero()) == 0;
    }

    public T abs() {
        T absolute = null;
        absolute = this.isNegative() ? (T)this.negated() : (T)this.newInstance(this.value, this.value.scale());
        return absolute;
    }

    public boolean isNonZero() {
        return !this.isZero();
    }

    public T add(T addend) {
        if (addend == null) {
            throw new IllegalArgumentException("invalid (null) addend");
        }
        BigDecimal sum = this.value.add(((AbstractKualiDecimal)addend).value);
        return this.newInstance(sum, sum.scale());
    }

    public T subtract(T subtrahend) {
        if (subtrahend == null) {
            throw new IllegalArgumentException("invalid (null) subtrahend");
        }
        BigDecimal difference = this.value.subtract(((AbstractKualiDecimal)subtrahend).value);
        return this.newInstance(difference, difference.scale());
    }

    public T multiply(T multiplier) {
        return this.multiply(multiplier, true);
    }

    public T multiply(T multiplier, boolean applyScale) {
        if (multiplier == null) {
            throw new IllegalArgumentException("invalid (null) multiplier");
        }
        BigDecimal product = this.value.multiply(((AbstractKualiDecimal)multiplier).value);
        return this.newInstance(product, applyScale ? this.value.scale() : product.scale());
    }

    public T mod(T modulus) {
        return this.mod(modulus, true);
    }

    public T mod(T modulus, boolean applyScale) {
        if (modulus == null) {
            throw new IllegalArgumentException("invalid (null) modulus");
        }
        double difference = this.value.doubleValue() % ((AbstractKualiDecimal)modulus).doubleValue();
        int scaleToApply = applyScale ? this.value.scale() : new BigDecimal(difference).scale();
        return this.newInstance(new BigDecimal(difference), scaleToApply);
    }

    public T divide(T divisor) {
        return this.divide(divisor, true);
    }

    public T negated() {
        return this.multiply(this.newInstance("-1"));
    }

    public T divide(T divisor, boolean applyScale) {
        if (divisor == null) {
            throw new IllegalArgumentException("invalid (null) divisor");
        }
        BigDecimal quotient = this.value.divide(((AbstractKualiDecimal)divisor).value, 4);
        T result = this.newInstance(quotient, applyScale ? this.value.scale() : quotient.scale());
        return result;
    }

    protected abstract T newInstance(String var1);

    protected abstract T newInstance(double var1);

    protected abstract T newInstance(double var1, int var3);

    protected abstract T newInstance(BigDecimal var1);

    protected abstract T newInstance(BigDecimal var1, int var2);

    protected abstract T zero();
}

