/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.stats;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.context.Contextual;
import org.terracotta.statistics.Sample;
import org.terracotta.statistics.registry.Statistic;

public final class ContextualStatistics
implements Contextual {
    private static final long serialVersionUID = 1L;
    private final Map<String, Statistic<? extends Serializable>> statistics;
    private final String capability;
    private Context context;

    public ContextualStatistics(String capability, Context context, Map<String, Statistic<? extends Serializable>> statistics) {
        this.statistics = new HashMap<String, Statistic<? extends Serializable>>(Objects.requireNonNull(statistics));
        this.context = Objects.requireNonNull(context);
        this.capability = Objects.requireNonNull(capability);
    }

    public String getCapability() {
        return this.capability;
    }

    public int size() {
        return this.statistics.size();
    }

    public boolean isEmpty() {
        return this.statistics.isEmpty();
    }

    public Map<String, Statistic<? extends Serializable>> getStatistics() {
        return this.statistics;
    }

    public Map<String, ? extends Serializable> getLatestSampleValues() {
        return this.statistics.entrySet().stream().filter(e -> !((Statistic)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (Serializable)((Statistic)e.getValue()).getLatestSampleValue().get()));
    }

    public Map<String, Sample<? extends Serializable>> getLatestSamples() {
        return this.statistics.entrySet().stream().filter(e -> !((Statistic)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Statistic)e.getValue()).getLatestSample().get()));
    }

    public boolean hasStatistic(String name) {
        return this.statistics.containsKey(name);
    }

    public <T extends Serializable> Optional<Statistic<T>> getStatistic(String name) {
        return Optional.ofNullable(this.statistics.get(name));
    }

    public <T extends Serializable> Optional<T> getLatestSampleValue(String name) {
        return this.getLatestSample(name).map(Sample::getSample);
    }

    public <T extends Serializable> Optional<Sample<T>> getLatestSample(String name) {
        return this.getStatistic(name).flatMap(Statistic::getLatestSample);
    }

    @Override
    public void setContext(Context context) {
        this.context = Objects.requireNonNull(context);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public String toString() {
        return "ContextualStatistics{capability='" + this.capability + '\'' + ", context=" + this.context + ", statistics=" + this.statistics.size() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualStatistics that = (ContextualStatistics)o;
        if (!this.statistics.equals(that.statistics)) {
            return false;
        }
        if (!this.capability.equals(that.capability)) {
            return false;
        }
        return this.context.equals(that.context);
    }

    public int hashCode() {
        int result = this.statistics.hashCode();
        result = 31 * result + this.capability.hashCode();
        result = 31 * result + this.context.hashCode();
        return result;
    }
}

