/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.context.ContextElement;
import org.terracotta.context.ContextManager;
import org.terracotta.context.TreeNode;
import org.terracotta.statistics.GeneralOperationStatistic;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.PassThroughStatistic;
import org.terracotta.statistics.Statistic;
import org.terracotta.statistics.StatisticType;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.ValueStatistics;
import org.terracotta.statistics.observer.OperationObserver;

public class StatisticsManager
extends ContextManager {
    private static final String EQ = Pattern.quote("=");

    public static <T extends Enum<T>> OperationObserver<T> createOperationStatistic(Object context, String name, Set<String> tags, Class<T> eventTypes) {
        return StatisticsManager.createOperationStatistic(context, name, tags, Collections.emptyMap(), eventTypes);
    }

    public static <T extends Enum<T>> OperationObserver<T> createOperationStatistic(Object context, String name, Set<String> tags, Map<String, ? extends Object> properties, Class<T> resultType) {
        OperationStatistic<T> stat = StatisticsManager.createOperationStatistic(name, tags, properties, resultType);
        StatisticsManager.associate(context).withChild(stat);
        return stat;
    }

    private static <T extends Enum<T>> OperationStatistic<T> createOperationStatistic(String name, Set<String> tags, Map<String, ? extends Object> properties, Class<T> resultType) {
        return new GeneralOperationStatistic<T>(name, tags, properties, resultType);
    }

    public static <T extends Enum<T>> OperationStatistic<T> getOperationStatisticFor(OperationObserver<T> observer) {
        TreeNode node = ContextManager.nodeFor(observer);
        if (node == null) {
            return null;
        }
        ContextElement context = node.getContext();
        if (OperationStatistic.class.isAssignableFrom(context.identifier())) {
            OperationStatistic stat = (OperationStatistic)context.attributes().get("this");
            return stat;
        }
        throw new AssertionError();
    }

    public static <T extends Serializable> void createPassThroughStatistic(Object context, String name, Set<String> tags, StatisticType type, Supplier<T> source) {
        StatisticsManager.createPassThroughStatistic(context, name, tags, Collections.emptyMap(), ValueStatistics.supply(type, source));
    }

    public static <T extends Serializable> void createPassThroughStatistic(Object context, String name, Set<String> tags, ValueStatistic<T> source) {
        StatisticsManager.createPassThroughStatistic(context, name, tags, Collections.emptyMap(), source);
    }

    public static <T extends Serializable> void createPassThroughStatistic(Object context, String name, Set<String> tags, Map<String, ? extends Object> properties, StatisticType type, Supplier<T> source) {
        StatisticsManager.createPassThroughStatistic(context, name, tags, properties, ValueStatistics.supply(type, source));
    }

    public static <T extends Serializable> void createPassThroughStatistic(Object context, String name, Set<String> tags, Map<String, ? extends Object> properties, ValueStatistic<T> source) {
        PassThroughStatistic<T> stat = new PassThroughStatistic<T>(context, name, tags, properties, source);
        StatisticsManager.associate(context).withChild(stat);
    }

    public static void removePassThroughStatistics(Object context) {
        PassThroughStatistic.removeStatistics(context);
    }

    public static Set<String> tags(String ... tags) {
        return new HashSet<String>(Arrays.asList(tags));
    }

    private static void parseStatisticAnnotations(Object object) {
        for (Method m3 : object.getClass().getMethods()) {
            Statistic anno = m3.getAnnotation(Statistic.class);
            if (anno == null) continue;
            Class<?> returnType = m3.getReturnType();
            if (m3.getParameterTypes().length != 0) {
                throw new IllegalArgumentException("Statistic methods must be no-arg: " + m3);
            }
            if (!(Number.class.isAssignableFrom(returnType) || m3.getReturnType().isPrimitive() && !m3.getReturnType().equals(Boolean.TYPE))) {
                throw new IllegalArgumentException("Statistic methods must return a Number: " + m3);
            }
            if (Modifier.isStatic(m3.getModifiers())) {
                throw new IllegalArgumentException("Statistic methods must be non-static: " + m3);
            }
            StatisticsManager.createPassThroughStatistic(object, anno.name(), new HashSet<String>(Arrays.asList(anno.tags())), ValueStatistics.supply(anno.type(), new ReflectionSupplier(object, m3)));
        }
    }

    public static Map<String, String> properties(String ... kvs) {
        return Stream.of(kvs).map(kv -> kv.split(EQ, 2)).collect(Collectors.toMap(split -> split[0], split -> split[1]));
    }

    static {
        ContextManager.registerContextCreationListener(StatisticsManager::parseStatisticAnnotations);
    }

    static class ReflectionSupplier<T>
    implements Supplier<T> {
        private final WeakReference<Object> targetRef;
        private final Method method;

        ReflectionSupplier(Object target, Method method) {
            this.targetRef = new WeakReference<Object>(target);
            this.method = method;
        }

        @Override
        public T get() {
            try {
                return (T)this.method.invoke(this.targetRef.get(), new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
        }
    }
}

