/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.registry;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.terracotta.statistics.Sample;
import org.terracotta.statistics.SampledStatistic;
import org.terracotta.statistics.StatisticType;
import org.terracotta.statistics.Table;
import org.terracotta.statistics.ValueStatistic;

public class Statistic<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final StatisticType type;
    private final List<Sample<T>> samples;

    public Statistic(StatisticType type) {
        this(type, Collections.emptyList());
    }

    public Statistic(StatisticType type, Sample<T> sample) {
        this(type, Collections.singletonList(sample));
    }

    public Statistic(StatisticType type, List<Sample<T>> samples) {
        this.type = type;
        this.samples = samples;
    }

    public StatisticType getType() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.samples.isEmpty();
    }

    public List<Sample<T>> getSamples() {
        return this.samples;
    }

    public Optional<T> getLatestSampleValue() {
        return this.getLatestSample().map(Sample::getSample);
    }

    public Optional<Sample<T>> getLatestSample() {
        return this.samples.isEmpty() ? Optional.empty() : Optional.of(this.samples.get(this.samples.size() - 1));
    }

    public String toString() {
        return "Statistic{type=" + (Object)((Object)this.type) + ", samples=" + this.samples + '}';
    }

    static <T extends Serializable> Statistic<T> extract(ValueStatistic<T> valueStatistic, long sinceMillis, long now) {
        T value;
        if (valueStatistic instanceof SampledStatistic) {
            return new Statistic<T>(valueStatistic.type(), ((SampledStatistic)valueStatistic).history(sinceMillis).stream().filter(s2 -> Statistic.accepted(s2.getSample())).collect(Collectors.toList()));
        }
        if (sinceMillis <= now && Statistic.accepted(value = valueStatistic.value())) {
            return new Statistic<T>(valueStatistic.type(), new Sample<T>(now, value));
        }
        return new Statistic<T>(valueStatistic.type());
    }

    private static <T extends Serializable> boolean accepted(T sample) {
        return sample != null && (!(sample instanceof Table) || !((Table)sample).isEmpty());
    }
}

