/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class RingBuffer<T> {
    public static final int DEFAULT_CAPACITY = 64;
    private final Object[] ring;
    private int pointer = 0;
    private int nUpdates = 0;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();

    public RingBuffer() {
        this(64);
    }

    public RingBuffer(int capacity) {
        this.ring = new Object[capacity];
    }

    private int next(int i2) {
        return (i2 + 1) % this.getCapacity();
    }

    private int previous(int i2) {
        int j2 = i2 - 1;
        return j2 < 0 ? this.getCapacity() - 1 : j2;
    }

    public final void addItem(T item) {
        this.wLock.lock();
        try {
            this.pointer = this.next(this.pointer);
            this.ring[this.pointer] = item;
            if (++this.nUpdates < 0) {
                this.nUpdates = Integer.MAX_VALUE;
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    public final int getCapacity() {
        return this.ring.length;
    }

    public final int getNumberOfUpdates() {
        this.rLock.lock();
        try {
            int n2 = this.nUpdates;
            return n2;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<T> getAsList() {
        this.rLock.lock();
        try {
            ArrayList<Object> listHistory = new ArrayList<Object>();
            int index = this.pointer;
            for (int i2 = 0; i2 < Math.min(this.getCapacity(), this.getNumberOfUpdates()); ++i2) {
                listHistory.add(this.ring[index]);
                index = this.previous(index);
            }
            ArrayList<Object> arrayList = listHistory;
            return arrayList;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @DisableTrace
    public String toString() {
        this.rLock.lock();
        try {
            String string = this.toString(Math.min(this.getCapacity(), this.getNumberOfUpdates()));
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DisableTrace
    public String toString(int nItems) {
        StringBuilder sb = new StringBuilder();
        this.rLock.lock();
        try {
            int i2 = this.pointer;
            int n2 = nItems;
            if (n2 < 1) {
                String string = "";
                return string;
            }
            do {
                Object item;
                if (null == (item = this.ring[i2])) continue;
                sb.append(item.toString());
            } while ((i2 = this.previous(i2)) != this.pointer && --n2 > 0);
        }
        finally {
            this.rLock.unlock();
        }
        return sb.toString();
    }

    public final void clear() {
        this.wLock.lock();
        try {
            this.pointer = 0;
            this.nUpdates = 0;
        }
        finally {
            this.wLock.unlock();
        }
    }
}

