/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.io.File;
import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class UCPManifestReader {
    public static void main(String[] args) {
        try {
            System.out.println(UCPManifestReader.formatUCPVersionDetails(new JarFile(UCPManifestReader.findUcpPath(UCPManifestReader.readClassPath())).getManifest().getMainAttributes()));
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
        }
    }

    static List<String> readClassPath() {
        final ArrayList<String> classPath = new ArrayList<String>();
        AccessController.doPrivileged(new PrivilegedAction(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            public Object run() {
                String[] cp;
                for (String s2 : cp = System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
                    classPath.add(s2);
                }
                return null;
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(List.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
        return classPath;
    }

    static File findUcpPath(List<String> classPath) {
        String ucpName = "ucp.jar";
        File jarF = new File("ucp.jar");
        for (String s2 : classPath) {
            File f2 = new File(s2);
            if (!f2.getName().equalsIgnoreCase("ucp.jar")) continue;
            jarF = f2;
            break;
        }
        return jarF;
    }

    static String formatUCPVersionDetails(Attributes attrs) {
        String implementationTitle = attrs.getValue("Implementation-Title");
        String implementationVersion = attrs.getValue("Implementation-Version");
        String buildInfo = attrs.getValue("Build-Info");
        return new StringBuffer().append(implementationTitle).append("  (Version : ").append(implementationVersion).append(")  (Build : ").append(buildInfo == null ? "N/A" : buildInfo).append(')').toString();
    }
}

