/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class UCPFormatter
extends Formatter {
    @Override
    public String format(LogRecord lr) {
        String msg = lr.getMessage();
        Level level = lr.getLevel();
        return new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS a Z").format(new Date(lr.getMillis()), new StringBuffer(), new FieldPosition(0)).append(" UCP ").append(level.toString()).append(" seq-").append(lr.getSequenceNumber()).append(",thread-").append(lr.getThreadID()).append(' ').append(lr.getSourceClassName()).append('.').append(lr.getSourceMethodName()).append(' ').append(this.fmtMsgParams(lr)).append(this.fmtThrown(lr)).append('\n').toString();
    }

    private String fmtMsgParams(LogRecord lr) {
        String msg = lr.getMessage();
        if (msg == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String[] parts = msg.split("\\{\\d+\\}");
        Object[] params = lr.getParameters();
        int i2 = 0;
        for (String part : parts) {
            sb.append((Object)part);
            if (params == null || params.length <= i2) continue;
            sb.append(params[i2++]);
        }
        return sb.toString();
    }

    private String fmtThrown(LogRecord lr) {
        Throwable thrown = lr.getThrown();
        if (thrown == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        thrown.printStackTrace(new PrintWriter(writer));
        return "" + '\n' + writer + '\n';
    }
}

