/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.spring;

import java.sql.Connection;
import javax.sql.DataSource;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.migration.spring.SpringJdbcMigration;
import org.flywaydb.core.api.resolver.MigrationExecutor;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class SpringJdbcMigrationExecutor
implements MigrationExecutor {
    private final SpringJdbcMigration springJdbcMigration;

    public SpringJdbcMigrationExecutor(SpringJdbcMigration springJdbcMigration) {
        this.springJdbcMigration = springJdbcMigration;
    }

    @Override
    public void execute(Connection connection) {
        try {
            this.springJdbcMigration.migrate(new JdbcTemplate((DataSource)new SingleConnectionDataSource(connection, true)));
        }
        catch (Exception e2) {
            throw new FlywayException("Migration failed !", e2);
        }
    }

    @Override
    public boolean executeInTransaction() {
        return true;
    }
}

