/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.android;

import android.content.Context;
import dalvik.system.DexFile;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.android.ContextHolder;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.resource.android.AndroidResource;
import org.flywaydb.core.internal.scanner.classpath.ResourceAndClassScanner;
import org.flywaydb.core.internal.util.ClassUtils;

public class AndroidScanner<I>
implements ResourceAndClassScanner<I> {
    private static final Log LOG = LogFactory.getLog(AndroidScanner.class);
    private final Context context;
    private final Class<I> implementedInterface;
    private final ClassLoader clazzLoader;
    private final Charset encoding;
    private final Location location;

    public AndroidScanner(Class<I> implementedInterface, ClassLoader clazzLoader, Charset encoding, Location location) {
        this.implementedInterface = implementedInterface;
        this.clazzLoader = clazzLoader;
        this.encoding = encoding;
        this.location = location;
        this.context = ContextHolder.getContext();
        if (this.context == null) {
            throw new FlywayException("Unable to scan for Migrations! Context not set. Within an activity you can fix this with org.flywaydb.core.api.android.ContextHolder.setContext(this);");
        }
    }

    @Override
    public Collection<LoadableResource> scanForResources() {
        ArrayList<LoadableResource> resources = new ArrayList<LoadableResource>();
        String path = this.location.getRootPath();
        try {
            for (String asset : this.context.getAssets().list(path)) {
                if (!this.location.matchesPath(asset)) continue;
                resources.add(new AndroidResource(this.location, this.context.getAssets(), path, asset, this.encoding));
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to scan for resources: " + e.getMessage());
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Class<? extends I>> scanForClasses() {
        String pkg = this.location.getRootPath().replace("/", ".");
        ArrayList<Class<I>> classes = new ArrayList<Class<I>>();
        String sourceDir = this.context.getApplicationInfo().sourceDir;
        DexFile dex = null;
        try {
            dex = new DexFile(sourceDir);
            Enumeration entries = dex.entries();
            while (entries.hasMoreElements()) {
                Class<I> clazz;
                String className = (String)entries.nextElement();
                if (!className.startsWith(pkg) || (clazz = ClassUtils.loadClass(this.implementedInterface, className, this.clazzLoader)) == null) continue;
                classes.add(clazz);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to scan DEX file (" + sourceDir + "): " + e.getMessage());
        }
        finally {
            if (dex != null) {
                try {
                    dex.close();
                }
                catch (IOException e) {
                    LOG.debug("Unable to close DEX file (" + sourceDir + "): " + e.getMessage());
                }
            }
        }
        return classes;
    }
}

