--
-- Copyright © 2005-2020 Kuali, Inc.
-- All Rights Reserved
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
--

CREATE TABLE INSTITUTIONAL_PROPOSAL_NOTIFICATION (
	NOTIFICATION_ID DECIMAL(20,0) NOT NULL DEFAULT '0',
	NOTIFICATION_TYPE_ID DECIMAL(6,0) NOT NULL,
	DOCUMENT_NUMBER VARCHAR(40) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
	OWNING_DOCUMENT_ID_FK DECIMAL(12,0) NOT NULL DEFAULT '0',
	RECIPIENTS VARCHAR(1000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
	SUBJECT VARCHAR(1000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
	MESSAGE VARCHAR(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
	UPDATE_USER VARCHAR(60) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
	UPDATE_TIMESTAMP DATETIME NOT NULL,
	CREATE_TIMESTAMP DATETIME NOT NULL,
	VER_NBR DECIMAL(8,0) NOT NULL DEFAULT '1',
	OBJ_ID VARCHAR(36) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
	PRIMARY KEY (NOTIFICATION_ID),
	KEY FK1_PROPOSAL_NOTIFICATION (OWNING_DOCUMENT_ID_FK),
	KEY FK2_PROPOSAL_NOTIFICATION (NOTIFICATION_TYPE_ID),
	CONSTRAINT FK1_INSTITUTIONAL_PROPOSAL_NOTIFICATION FOREIGN KEY (OWNING_DOCUMENT_ID_FK) REFERENCES PROPOSAL (PROPOSAL_ID) ON DELETE RESTRICT ON UPDATE RESTRICT,
	CONSTRAINT FK2_INSTITUTIONAL_PROPOSAL_NOTIFICATION FOREIGN KEY (NOTIFICATION_TYPE_ID) REFERENCES NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
