/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect;

import com.sun.xml.bind.WhiteSpaceProcessor;
import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.runtime.Transducer;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.DefaultTransducedAccessor;
import com.sun.xml.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.bind.v2.runtime.reflect.Lister;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

public final class ListTransducedAccessorImpl<BeanT, ListT, ItemT, PackT>
extends DefaultTransducedAccessor<BeanT> {
    private final Transducer<ItemT> xducer;
    private final Lister<BeanT, ListT, ItemT, PackT> lister;
    private final Accessor<BeanT, ListT> acc;

    public ListTransducedAccessorImpl(Transducer<ItemT> xducer, Accessor<BeanT, ListT> acc, Lister<BeanT, ListT, ItemT, PackT> lister) {
        this.xducer = xducer;
        this.lister = lister;
        this.acc = acc;
    }

    @Override
    public boolean useNamespace() {
        return this.xducer.useNamespace();
    }

    @Override
    public void declareNamespace(BeanT bean2, XMLSerializer w2) throws AccessorException, SAXException {
        ListT list = this.acc.get(bean2);
        if (list != null) {
            ListIterator<ItemT> itr = this.lister.iterator(list, w2);
            while (itr.hasNext()) {
                try {
                    ItemT item = itr.next();
                    if (item == null) continue;
                    this.xducer.declareNamespace(item, w2);
                }
                catch (JAXBException e2) {
                    w2.reportError(null, e2);
                }
            }
        }
    }

    @Override
    public String print(BeanT o2) throws AccessorException, SAXException {
        ListT list = this.acc.get(o2);
        if (list == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        XMLSerializer w2 = XMLSerializer.getInstance();
        ListIterator<ItemT> itr = this.lister.iterator(list, w2);
        while (itr.hasNext()) {
            try {
                ItemT item = itr.next();
                if (item == null) continue;
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(this.xducer.print(item));
            }
            catch (JAXBException e2) {
                w2.reportError(null, e2);
            }
        }
        return buf.toString();
    }

    private void processValue(BeanT bean2, CharSequence s2) throws AccessorException, SAXException {
        PackT pack = this.lister.startPacking(bean2, this.acc);
        int idx = 0;
        int len = s2.length();
        while (true) {
            int p2;
            for (p2 = idx; p2 < len && !WhiteSpaceProcessor.isWhiteSpace(s2.charAt(p2)); ++p2) {
            }
            CharSequence token = s2.subSequence(idx, p2);
            if (!token.equals("")) {
                this.lister.addToPack(pack, this.xducer.parse(token));
            }
            if (p2 == len) break;
            while (p2 < len && WhiteSpaceProcessor.isWhiteSpace(s2.charAt(p2))) {
                ++p2;
            }
            if (p2 == len) break;
            idx = p2;
        }
        this.lister.endPacking(pack, bean2, this.acc);
    }

    @Override
    public void parse(BeanT bean2, CharSequence lexical) throws AccessorException, SAXException {
        this.processValue(bean2, lexical);
    }

    @Override
    public boolean hasValue(BeanT bean2) throws AccessorException {
        return this.acc.get(bean2) != null;
    }
}

