/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.CacheQuery;
import net.sf.ehcache.Disposable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.FeaturesManager;
import net.sf.ehcache.LoaderTimeoutException;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.Status;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.bootstrap.BootstrapCacheLoaderFactory;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.cluster.ClusterScheme;
import net.sf.ehcache.cluster.ClusterSchemeNotAvailableException;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.StripedReadWriteLockSync;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheWriterConfiguration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.config.ManagementRESTServiceConfiguration;
import net.sf.ehcache.config.NonstopConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.config.SearchAttribute;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.constructs.nonstop.NonstopActiveDelegateHolder;
import net.sf.ehcache.constructs.nonstop.NonstopExecutorService;
import net.sf.ehcache.constructs.nonstop.concurrency.LockOperationTimedOutNonstopException;
import net.sf.ehcache.constructs.nonstop.store.NonstopStoreImpl;
import net.sf.ehcache.constructs.nonstop.store.RejoinAwareNonstopStore;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.exceptionhandler.CacheExceptionHandler;
import net.sf.ehcache.extension.CacheExtension;
import net.sf.ehcache.extension.CacheExtensionFactory;
import net.sf.ehcache.loader.CacheLoader;
import net.sf.ehcache.loader.CacheLoaderFactory;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.pool.PoolableStore;
import net.sf.ehcache.pool.SizeOfEngine;
import net.sf.ehcache.pool.impl.BoundedPool;
import net.sf.ehcache.pool.impl.FromLargestCacheOnDiskPoolEvictor;
import net.sf.ehcache.pool.impl.FromLargestCacheOnHeapPoolEvictor;
import net.sf.ehcache.pool.impl.UnboundedPool;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.SearchException;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.search.attribute.DynamicAttributesExtractor;
import net.sf.ehcache.statistics.CacheUsageListener;
import net.sf.ehcache.statistics.LiveCacheStatistics;
import net.sf.ehcache.statistics.LiveCacheStatisticsWrapper;
import net.sf.ehcache.statistics.sampled.CacheStatisticsSampler;
import net.sf.ehcache.statistics.sampled.SampledCacheStatistics;
import net.sf.ehcache.statistics.sampled.SampledCacheStatisticsWrapper;
import net.sf.ehcache.store.DiskBackedMemoryStore;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.LegacyStoreWrapper;
import net.sf.ehcache.store.LruMemoryStore;
import net.sf.ehcache.store.MemoryOnlyStore;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreListener;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.store.TerracottaStore;
import net.sf.ehcache.store.compound.ImmutableValueElementCopyStrategy;
import net.sf.ehcache.store.compound.ReadWriteCopyStrategy;
import net.sf.ehcache.store.disk.DiskStore;
import net.sf.ehcache.store.disk.StoreUpdateException;
import net.sf.ehcache.terracotta.InternalEhcache;
import net.sf.ehcache.terracotta.TerracottaNotRunningException;
import net.sf.ehcache.transaction.SoftLockManager;
import net.sf.ehcache.transaction.TransactionIDFactory;
import net.sf.ehcache.transaction.local.JtaLocalTransactionStore;
import net.sf.ehcache.transaction.local.LocalTransactionStore;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.transaction.xa.EhcacheXAResource;
import net.sf.ehcache.transaction.xa.EhcacheXAResourceImpl;
import net.sf.ehcache.transaction.xa.XATransactionStore;
import net.sf.ehcache.util.ClassLoaderUtil;
import net.sf.ehcache.util.NamedThreadFactory;
import net.sf.ehcache.util.PropertyUtil;
import net.sf.ehcache.util.TimeUtil;
import net.sf.ehcache.util.VmUtils;
import net.sf.ehcache.writer.CacheWriter;
import net.sf.ehcache.writer.CacheWriterFactory;
import net.sf.ehcache.writer.CacheWriterManager;
import net.sf.ehcache.writer.CacheWriterManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cache
implements InternalEhcache,
StoreListener {
    public static final String DEFAULT_CACHE_NAME = "default";
    public static final String NET_SF_EHCACHE_DISABLED = "net.sf.ehcache.disabled";
    public static final String NET_SF_EHCACHE_USE_CLASSIC_LRU = "net.sf.ehcache.use.classic.lru";
    public static final long DEFAULT_EXPIRY_THREAD_INTERVAL_SECONDS = 120L;
    private static final Logger LOG = LoggerFactory.getLogger(Cache.class.getName());
    private static InetAddress localhost;
    private static final int BACK_OFF_TIME_MILLIS = 50;
    private static final int EXECUTOR_KEEP_ALIVE_TIME = 60000;
    private static final int EXECUTOR_MAXIMUM_POOL_SIZE;
    private static final int EXECUTOR_CORE_POOL_SIZE = 1;
    private static final String EHCACHE_CLUSTERREDSTORE_MAX_CONCURRENCY_PROP = "ehcache.clusteredStore.maxConcurrency";
    private static final int DEFAULT_EHCACHE_CLUSTERREDSTORE_MAX_CONCURRENCY = 4096;
    private volatile boolean disabled = Boolean.getBoolean("net.sf.ehcache.disabled");
    private final boolean useClassicLru = Boolean.getBoolean("net.sf.ehcache.use.classic.lru");
    private volatile CacheStatus cacheStatus = new CacheStatus();
    private volatile CacheConfiguration configuration;
    private volatile Store compoundStore;
    private volatile CacheLockProvider lockProvider;
    private volatile RegisteredEventListeners registeredEventListeners;
    private volatile List<CacheExtension> registeredCacheExtensions;
    private volatile String guid;
    private volatile CacheManager cacheManager;
    private volatile BootstrapCacheLoader bootstrapCacheLoader;
    private volatile CacheExceptionHandler cacheExceptionHandler;
    private volatile List<CacheLoader> registeredCacheLoaders;
    private volatile CacheWriterManager cacheWriterManager;
    private volatile AtomicBoolean cacheWriterManagerInitFlag = new AtomicBoolean(false);
    private volatile ReentrantLock cacheWriterManagerInitLock = new ReentrantLock();
    private volatile CacheWriter registeredCacheWriter;
    private volatile ExecutorService executorService;
    private volatile LiveCacheStatisticsWrapper liveCacheStatisticsData;
    private volatile SampledCacheStatisticsWrapper sampledCacheStatistics;
    private volatile TransactionManagerLookup transactionManagerLookup;
    private volatile boolean allowDisable = true;
    private volatile PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private volatile ElementValueComparator elementValueComparator;
    private volatile NonstopActiveDelegateHolderImpl nonstopActiveDelegateHolder;
    private volatile EhcacheXAResource xaResource;

    public Cache(CacheConfiguration cacheConfiguration) {
        this(cacheConfiguration, null, null);
    }

    public Cache(CacheConfiguration cacheConfiguration, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader) {
        this.cacheStatus.changeState(Status.STATUS_UNINITIALISED);
        this.configuration = cacheConfiguration.clone();
        this.configuration.validateCompleteConfiguration();
        this.guid = this.createGuid();
        this.registeredEventListeners = registeredEventListeners == null ? new RegisteredEventListeners(this) : registeredEventListeners;
        this.registeredCacheExtensions = new CopyOnWriteArrayList<CacheExtension>();
        this.registeredCacheLoaders = new CopyOnWriteArrayList<CacheLoader>();
        this.liveCacheStatisticsData = new LiveCacheStatisticsWrapper(this);
        this.sampledCacheStatistics = new SampledCacheStatisticsWrapper();
        RegisteredEventListeners listeners = this.getCacheEventNotificationService();
        Cache.registerCacheListeners(this.configuration, listeners);
        Cache.registerCacheExtensions(this.configuration, this);
        this.bootstrapCacheLoader = null == bootstrapCacheLoader ? Cache.createBootstrapCacheLoader(this.configuration.getBootstrapCacheLoaderFactoryConfiguration()) : bootstrapCacheLoader;
        Cache.registerCacheLoaders(this.configuration, this);
        Cache.registerCacheWriter(this.configuration, this);
        this.nonstopActiveDelegateHolder = new NonstopActiveDelegateHolderImpl(this);
    }

    public Cache(String name, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds) {
        this(new CacheConfiguration(name, maxElementsInMemory).overflowToDisk(overflowToDisk).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds));
    }

    public Cache(String name, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds) {
        this(new CacheConfiguration(name, maxElementsInMemory).overflowToDisk(overflowToDisk).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds).diskPersistent(diskPersistent).diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds));
        LOG.warn("An API change between ehcache-1.1 and ehcache-1.2 results in the persistence path being set to " + DiskStoreConfiguration.getDefaultPath() + " when the ehcache-1.1 constructor is used. " + "Please change to the 1.2 constructor.");
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners) {
        this(new CacheConfiguration(name, maxElementsInMemory).memoryStoreEvictionPolicy(memoryStoreEvictionPolicy).overflowToDisk(overflowToDisk).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds).diskPersistent(diskPersistent).diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds), registeredEventListeners, null);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader) {
        this(new CacheConfiguration(name, maxElementsInMemory).memoryStoreEvictionPolicy(memoryStoreEvictionPolicy).overflowToDisk(overflowToDisk).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds).diskPersistent(diskPersistent).diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds), registeredEventListeners, bootstrapCacheLoader);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int maxElementsOnDisk) {
        this(new CacheConfiguration(name, maxElementsInMemory).memoryStoreEvictionPolicy(memoryStoreEvictionPolicy).overflowToDisk(overflowToDisk).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds).diskPersistent(diskPersistent).diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds).maxElementsOnDisk(maxElementsOnDisk), registeredEventListeners, bootstrapCacheLoader);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int maxElementsOnDisk, int diskSpoolBufferSizeMB) {
        this(new CacheConfiguration(name, maxElementsInMemory).memoryStoreEvictionPolicy(memoryStoreEvictionPolicy).overflowToDisk(overflowToDisk).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds).diskPersistent(diskPersistent).diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds).maxElementsOnDisk(maxElementsOnDisk).diskSpoolBufferSizeMB(diskSpoolBufferSizeMB), registeredEventListeners, bootstrapCacheLoader);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int maxElementsOnDisk, int diskSpoolBufferSizeMB, boolean clearOnFlush) {
        this(new CacheConfiguration(name, maxElementsInMemory).memoryStoreEvictionPolicy(memoryStoreEvictionPolicy).overflowToDisk(overflowToDisk).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds).diskPersistent(diskPersistent).diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds).maxElementsOnDisk(maxElementsOnDisk).diskSpoolBufferSizeMB(diskSpoolBufferSizeMB).clearOnFlush(clearOnFlush), registeredEventListeners, bootstrapCacheLoader);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int maxElementsOnDisk, int diskSpoolBufferSizeMB, boolean clearOnFlush, boolean isTerracottaClustered, String terracottaValueMode, boolean terracottaCoherentReads) {
        this(new CacheConfiguration(name, maxElementsInMemory).memoryStoreEvictionPolicy(memoryStoreEvictionPolicy).overflowToDisk(overflowToDisk).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds).diskPersistent(diskPersistent).diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds).maxElementsOnDisk(maxElementsOnDisk).diskSpoolBufferSizeMB(diskSpoolBufferSizeMB).clearOnFlush(clearOnFlush).terracotta(new TerracottaConfiguration().clustered(isTerracottaClustered).valueMode(terracottaValueMode).coherentReads(terracottaCoherentReads)), registeredEventListeners, bootstrapCacheLoader);
    }

    private static void registerCacheListeners(CacheConfiguration cacheConfiguration, RegisteredEventListeners registeredEventListeners) {
        List cacheEventListenerConfigurations = cacheConfiguration.getCacheEventListenerConfigurations();
        for (Object cacheEventListenerConfiguration : cacheEventListenerConfigurations) {
            CacheConfiguration.CacheEventListenerFactoryConfiguration factoryConfiguration = (CacheConfiguration.CacheEventListenerFactoryConfiguration)cacheEventListenerConfiguration;
            CacheEventListener cacheEventListener = Cache.createCacheEventListener(factoryConfiguration);
            registeredEventListeners.registerListener(cacheEventListener, factoryConfiguration.getListenFor());
        }
    }

    private static void registerCacheExtensions(CacheConfiguration cacheConfiguration, Ehcache cache) {
        List cacheExtensionConfigurations = cacheConfiguration.getCacheExtensionConfigurations();
        for (Object cacheExtensionConfiguration : cacheExtensionConfigurations) {
            CacheConfiguration.CacheExtensionFactoryConfiguration factoryConfiguration = (CacheConfiguration.CacheExtensionFactoryConfiguration)cacheExtensionConfiguration;
            CacheExtension cacheExtension = Cache.createCacheExtension(factoryConfiguration, cache);
            cache.registerCacheExtension(cacheExtension);
        }
    }

    private static void registerCacheLoaders(CacheConfiguration cacheConfiguration, Ehcache cache) {
        List cacheLoaderConfigurations = cacheConfiguration.getCacheLoaderConfigurations();
        for (Object cacheLoaderConfiguration : cacheLoaderConfigurations) {
            CacheConfiguration.CacheLoaderFactoryConfiguration factoryConfiguration = (CacheConfiguration.CacheLoaderFactoryConfiguration)cacheLoaderConfiguration;
            CacheLoader cacheLoader = Cache.createCacheLoader(factoryConfiguration, cache);
            cache.registerCacheLoader(cacheLoader);
        }
    }

    private static void registerCacheWriter(CacheConfiguration cacheConfiguration, Ehcache cache) {
        CacheWriterConfiguration config = cacheConfiguration.getCacheWriterConfiguration();
        if (config != null) {
            CacheWriter cacheWriter = Cache.createCacheWriter(config, cache);
            cache.registerCacheWriter(cacheWriter);
        }
    }

    private static CacheEventListener createCacheEventListener(CacheConfiguration.CacheEventListenerFactoryConfiguration factoryConfiguration) {
        String className = null;
        CacheEventListener cacheEventListener = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null) {
            LOG.debug("CacheEventListener factory not configured. Skipping...");
        } else {
            CacheEventListenerFactory factory = (CacheEventListenerFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            cacheEventListener = factory.createCacheEventListener(properties);
        }
        return cacheEventListener;
    }

    private static CacheExtension createCacheExtension(CacheConfiguration.CacheExtensionFactoryConfiguration factoryConfiguration, Ehcache cache) {
        String className = null;
        CacheExtension cacheExtension = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null) {
            LOG.debug("CacheExtension factory not configured. Skipping...");
        } else {
            CacheExtensionFactory factory = (CacheExtensionFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            cacheExtension = factory.createCacheExtension(cache, properties);
        }
        return cacheExtension;
    }

    private static CacheLoader createCacheLoader(CacheConfiguration.CacheLoaderFactoryConfiguration factoryConfiguration, Ehcache cache) {
        String className = null;
        CacheLoader cacheLoader = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null) {
            LOG.debug("CacheLoader factory not configured. Skipping...");
        } else {
            CacheLoaderFactory factory = (CacheLoaderFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            cacheLoader = factory.createCacheLoader(cache, properties);
        }
        return cacheLoader;
    }

    private static CacheWriter createCacheWriter(CacheWriterConfiguration config, Ehcache cache) {
        String className = null;
        CacheWriter cacheWriter = null;
        CacheWriterConfiguration.CacheWriterFactoryConfiguration factoryConfiguration = config.getCacheWriterFactoryConfiguration();
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (null == className) {
            LOG.debug("CacheWriter factory not configured. Skipping...");
        } else {
            CacheWriterFactory factory = (CacheWriterFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            if (null == properties) {
                properties = new Properties();
            }
            cacheWriter = factory.createCacheWriter(cache, properties);
        }
        return cacheWriter;
    }

    private static final BootstrapCacheLoader createBootstrapCacheLoader(CacheConfiguration.BootstrapCacheLoaderFactoryConfiguration factoryConfiguration) throws CacheException {
        String className = null;
        BootstrapCacheLoader bootstrapCacheLoader = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className != null && className.length() != 0) {
            BootstrapCacheLoaderFactory factory = (BootstrapCacheLoaderFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            return factory.createBootstrapCacheLoader(properties);
        }
        LOG.debug("No BootstrapCacheLoaderFactory class specified. Skipping...");
        return bootstrapCacheLoader;
    }

    public TransactionManagerLookup getTransactionManagerLookup() {
        return this.transactionManagerLookup;
    }

    @Override
    public void setTransactionManagerLookup(TransactionManagerLookup lookup) {
        TransactionManagerLookup oldValue = this.getTransactionManagerLookup();
        this.transactionManagerLookup = lookup;
        this.firePropertyChange("TransactionManagerLookup", oldValue, lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() {
        Cache cache = this;
        synchronized (cache) {
            Object context;
            Store store;
            Pool<PoolableStore> onDiskPool;
            Pool<PoolableStore> onHeapPool;
            if (!this.cacheStatus.canInitialize()) {
                throw new IllegalStateException("Cannot initialise the " + this.configuration.getName() + " cache because its status is not STATUS_UNINITIALISED");
            }
            if (this.configuration.getMaxBytesLocalHeap() > 0L) {
                FromLargestCacheOnHeapPoolEvictor evictor = new FromLargestCacheOnHeapPoolEvictor();
                SizeOfEngine sizeOfEngine = this.cacheManager.createSizeOfEngine(this);
                onHeapPool = new BoundedPool(this.configuration.getMaxBytesLocalHeap(), evictor, sizeOfEngine);
            } else {
                onHeapPool = this.getCacheManager() != null && this.getCacheManager().getConfiguration().isMaxBytesLocalHeapSet() ? this.getCacheManager().getOnHeapPool() : new UnboundedPool();
            }
            if (this.configuration.getMaxBytesLocalDisk() > 0L) {
                FromLargestCacheOnDiskPoolEvictor evictor = new FromLargestCacheOnDiskPoolEvictor();
                onDiskPool = new BoundedPool(this.configuration.getMaxBytesLocalDisk(), evictor, null);
            } else {
                onDiskPool = this.getCacheManager() != null && this.getCacheManager().getConfiguration().isMaxBytesLocalDiskSet() ? this.getCacheManager().getOnDiskPool() : new UnboundedPool();
            }
            ReadWriteCopyStrategy<Element> copyStrategy = null;
            if (this.configuration.getTransactionalMode().isTransactional()) {
                this.configuration.getCopyStrategyConfiguration().setCopyStrategyInstance(null);
                copyStrategy = this.configuration.getCopyStrategyConfiguration().getCopyStrategyInstance();
                this.configuration.getCopyStrategyConfiguration().setCopyStrategyInstance(new ImmutableValueElementCopyStrategy());
            }
            this.elementValueComparator = this.configuration.getElementValueComparatorConfiguration().createElementComparatorInstance(this.configuration);
            if (this.configuration.getTransactionalMode().isTransactional() && this.configuration.isTerracottaClustered() && this.configuration.getTerracottaConfiguration().getValueMode() != TerracottaConfiguration.ValueMode.SERIALIZATION) {
                throw new CacheException("To be transactional, a Terracotta clustered cache needs to be in Serialization value mode");
            }
            if (this.isTerracottaClustered()) {
                Store tempStore;
                boolean cachePinned;
                this.checkClusteredConfig();
                int maxConcurrency = Integer.getInteger(EHCACHE_CLUSTERREDSTORE_MAX_CONCURRENCY_PROP, 4096);
                if (this.getCacheConfiguration().getTerracottaConfiguration().getConcurrency() > maxConcurrency) {
                    throw new InvalidConfigurationException("Maximum supported concurrency for Terracotta clustered caches is " + maxConcurrency + ". Please reconfigure cache '" + this.getName() + "' with concurrency value <= " + maxConcurrency + " or use system property '" + EHCACHE_CLUSTERREDSTORE_MAX_CONCURRENCY_PROP + "' to override the default");
                }
                boolean bl = cachePinned = this.getCacheConfiguration().getPinningConfiguration() != null && this.getCacheConfiguration().getPinningConfiguration().getStore() == PinningConfiguration.Store.INCACHE;
                if (!cachePinned && this.getCacheConfiguration().getMaxElementsOnDisk() == 0) {
                    LOG.warn("Performance may degrade and server disks could run out of space!\nThe distributed cache {} does not have maxElementsOnDisk set. Failing to set maxElementsOnDisk could mean no eviction of its elements from the Terracotta Server Array disk store. To avoid this, set maxElementsOnDisk to a non-zero value.", (Object)this.getName());
                }
                if (!((tempStore = this.cacheManager.createTerracottaStore(this)) instanceof TerracottaStore)) {
                    throw new CacheException("CacheManager should create instances of TerracottaStore for Terracotta Clustered caches instead of - " + (tempStore == null ? "null" : tempStore.getClass().getName()));
                }
                CacheConfiguration.TransactionalMode clusteredTransactionalMode = ((TerracottaStore)tempStore).getTransactionalMode();
                if (clusteredTransactionalMode != null && !clusteredTransactionalMode.equals((Object)this.configuration.getTransactionalMode())) {
                    throw new InvalidConfigurationException("Transactional mode cannot be changed on clustered caches. Please reconfigure cache '" + this.getName() + "' with transactionalMode = " + (Object)((Object)clusteredTransactionalMode));
                }
                TerracottaStore terracottaStore = (TerracottaStore)this.makeXaStrictTransactionalIfNeeded(tempStore, copyStrategy);
                NonstopConfiguration nonstopConfig = this.getCacheConfiguration().getTerracottaConfiguration().getNonstopConfiguration();
                if (nonstopConfig != null) {
                    nonstopConfig.freezeConfig();
                }
                if (this.getCacheConfiguration().getTerracottaConfiguration().isNonstopEnabled()) {
                    this.nonstopActiveDelegateHolder.terracottaStoreInitialized(terracottaStore);
                    store = this.nonstopActiveDelegateHolder.getNonstopStore();
                } else {
                    store = terracottaStore;
                }
            } else {
                FeaturesManager featuresManager = this.cacheManager.getFeaturesManager();
                if (featuresManager == null) {
                    if (this.configuration.isOverflowToOffHeap()) {
                        throw new CacheException("Cache " + this.configuration.getName() + " cannot be configured because the enterprise features manager could not be found. " + "You must use an enterprise version of Ehcache to successfully enable overflowToOffHeap.");
                    }
                    PersistenceConfiguration persistence = this.configuration.getPersistenceConfiguration();
                    if (persistence != null && PersistenceConfiguration.Strategy.LOCALRESTARTABLE.equals((Object)persistence.getStrategy())) {
                        throw new CacheException("Cache " + this.configuration.getName() + " cannot be configured because the enterprise features manager could not be found. " + "You must use an enterprise version of Ehcache to successfully enable enterprise persistence.");
                    }
                    if (this.useClassicLru && this.configuration.getMemoryStoreEvictionPolicy().equals(MemoryStoreEvictionPolicy.LRU)) {
                        DiskStore disk = this.createDiskStore();
                        store = new LegacyStoreWrapper(new LruMemoryStore(this, disk), disk, this.registeredEventListeners, this.configuration);
                    } else {
                        store = this.configuration.isOverflowToDisk() ? DiskBackedMemoryStore.create(this, onHeapPool, onDiskPool) : MemoryOnlyStore.create(this, onHeapPool);
                    }
                } else {
                    store = featuresManager.createStore(this, onHeapPool, onDiskPool);
                }
                store = this.makeXaStrictTransactionalIfNeeded(store, copyStrategy);
            }
            if (this.configuration.isXaTransactional()) {
                SoftLockManager softLockManager = this.cacheManager.createSoftLockManager(this);
                LocalTransactionStore localTransactionStore = new LocalTransactionStore(this.getCacheManager().getTransactionController(), this.getCacheManager().getOrCreateTransactionIDFactory(), softLockManager, this, store, copyStrategy);
                this.compoundStore = new JtaLocalTransactionStore(localTransactionStore, this.transactionManagerLookup, this.cacheManager.getTransactionController());
            } else if (this.configuration.isLocalTransactional()) {
                SoftLockManager softLockManager = this.cacheManager.createSoftLockManager(this);
                this.compoundStore = new LocalTransactionStore(this.getCacheManager().getTransactionController(), this.getCacheManager().getOrCreateTransactionIDFactory(), softLockManager, this, store, copyStrategy);
            } else {
                this.compoundStore = store;
            }
            HashMap<String, AttributeExtractor> extractors = new HashMap<String, AttributeExtractor>();
            for (SearchAttribute sa : this.configuration.getSearchAttributes().values()) {
                extractors.put(sa.getName(), sa.constructExtractor());
            }
            this.compoundStore.setAttributeExtractors(extractors);
            this.cacheWriterManager = this.configuration.getCacheWriterConfiguration().getWriteMode().createWriterManager(this);
            this.cacheStatus.changeState(Status.STATUS_ALIVE);
            this.initialiseRegisteredCacheWriter();
            this.initialiseCacheWriterManager(false);
            this.initialiseRegisteredCacheExtensions();
            this.initialiseRegisteredCacheLoaders();
            this.getCacheEventNotificationService().registerListener(this.liveCacheStatisticsData);
            this.liveCacheStatisticsData.setStatisticsAccuracy(1);
            this.liveCacheStatisticsData.setStatisticsEnabled(this.configuration.getStatistics());
            this.registerCacheUsageListener(this.sampledCacheStatistics);
            if (this.isTerracottaClustered()) {
                this.cacheManager.createTerracottaEventReplicator(this);
            }
            this.lockProvider = (context = this.compoundStore.getInternalContext()) instanceof CacheLockProvider ? (CacheLockProvider)context : new StripedReadWriteLockSync(2048);
        }
        this.compoundStore.addStoreListener(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initialised cache: " + this.configuration.getName());
        }
        if (this.disabled) {
            LOG.warn("Cache: " + this.configuration.getName() + " is disabled because the " + NET_SF_EHCACHE_DISABLED + " property was set to true. No elements will be added to the cache.");
        }
    }

    private void checkClusteredConfig() {
        TerracottaConfiguration.Consistency consistency = this.getCacheConfiguration().getTerracottaConfiguration().getConsistency();
        boolean coherent = this.getCacheConfiguration().getTerracottaConfiguration().isCoherent();
        if (this.getCacheConfiguration().getTerracottaConfiguration().isSynchronousWrites() && consistency == TerracottaConfiguration.Consistency.EVENTUAL) {
            throw new InvalidConfigurationException("Terracotta clustered caches with eventual consistency and synchronous writes are not supported yet. You can fix this by either making the cache in 'strong' consistency mode (<terracotta consistency=\"strong\"/>) or turning off synchronous writes.");
        }
        if (this.getCacheConfiguration().getTransactionalMode().isTransactional() && consistency == TerracottaConfiguration.Consistency.EVENTUAL) {
            throw new InvalidConfigurationException("Consistency should be " + (Object)((Object)TerracottaConfiguration.Consistency.STRONG) + " when cache is configured with transactions enabled. " + "You can fix this by either making the cache in 'strong' consistency mode " + "(<terracotta consistency=\"strong\"/>) or turning off transactions.");
        }
        if (this.getCacheConfiguration().getTransactionalMode().isTransactional() && !this.getCacheConfiguration().getTransactionalMode().equals((Object)CacheConfiguration.TransactionalMode.XA_STRICT) && this.getCacheConfiguration().getTerracottaConfiguration().isNonstopEnabled()) {
            LOG.warn("Cache: " + this.configuration.getName() + " configured both NonStop and transactional non xa_strict." + " NonStop features won't work for this cache!");
        }
        if (coherent && consistency == TerracottaConfiguration.Consistency.EVENTUAL || !coherent && consistency == TerracottaConfiguration.Consistency.STRONG) {
            throw new InvalidConfigurationException("Coherent and consistency attribute values are conflicting. Please remove the coherent attribute as its deprecated.");
        }
    }

    private Store makeXaStrictTransactionalIfNeeded(Store clusteredStore, ReadWriteCopyStrategy<Element> copyStrategy) {
        Store wrappedStore;
        if (this.configuration.isXaStrictTransactional()) {
            if (this.transactionManagerLookup.getTransactionManager() == null) {
                throw new CacheException("You've configured cache " + this.cacheManager.getName() + "." + this.configuration.getName() + " to be transactional, but no TransactionManager could be found!");
            }
            if (this.configuration.isTerracottaClustered()) {
                this.configuration.getTerracottaConfiguration().setCacheXA(true);
            }
            SoftLockManager softLockManager = this.cacheManager.createSoftLockManager(this);
            TransactionIDFactory transactionIDFactory = this.cacheManager.getOrCreateTransactionIDFactory();
            this.xaResource = new EhcacheXAResourceImpl(this, clusteredStore, this.transactionManagerLookup, softLockManager, transactionIDFactory, copyStrategy);
            this.transactionManagerLookup.register(this.xaResource, true);
            wrappedStore = new XATransactionStore(this.transactionManagerLookup, softLockManager, transactionIDFactory, this, clusteredStore, copyStrategy);
        } else {
            wrappedStore = clusteredStore;
        }
        return wrappedStore;
    }

    private CacheCluster getCacheCluster() {
        CacheCluster cacheCluster;
        try {
            cacheCluster = this.getCacheManager().getCluster(ClusterScheme.TERRACOTTA);
        }
        catch (ClusterSchemeNotAvailableException e2) {
            LOG.info("Terracotta ClusterScheme is not available, using ClusterScheme.NONE");
            cacheCluster = this.getCacheManager().getCluster(ClusterScheme.NONE);
        }
        return cacheCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseCacheWriterManager(boolean imperative) throws CacheException {
        if (!this.cacheWriterManagerInitFlag.get()) {
            this.cacheWriterManagerInitLock.lock();
            try {
                if (!this.cacheWriterManagerInitFlag.get()) {
                    if (this.cacheWriterManager != null && this.registeredCacheWriter != null) {
                        this.cacheWriterManager.init(this);
                        this.cacheWriterManagerInitFlag.set(true);
                    } else if (imperative) {
                        throw new CacheException("Cache: " + this.configuration.getName() + " was being used with cache writer " + "features, but it wasn't properly registered beforehand.");
                    }
                }
            }
            finally {
                this.cacheWriterManagerInitLock.unlock();
            }
        }
    }

    @Override
    public CacheWriterManager getWriterManager() {
        return this.cacheWriterManager;
    }

    protected DiskStore createDiskStore() {
        if (this.isDiskStore()) {
            return DiskStore.create(this);
        }
        return null;
    }

    protected boolean isDiskStore() {
        return this.configuration.isOverflowToDisk();
    }

    public boolean isTerracottaClustered() {
        return this.configuration.isTerracottaClustered();
    }

    @Override
    public void bootstrap() {
        if (!this.disabled && this.bootstrapCacheLoader != null) {
            this.bootstrapCacheLoader.load(this);
        }
    }

    @Override
    public final void put(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.put(element, false);
    }

    @Override
    public void putAll(Collection<Element> elements) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.putAll(elements, false);
    }

    @Override
    public final void put(Element element, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.putInternal(element, doNotNotifyCacheReplicators, false);
    }

    private void putAll(Collection<Element> elements, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.putAllInternal(elements, doNotNotifyCacheReplicators);
    }

    @Override
    public void putWithWriter(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.putInternal(element, false, true);
    }

    private void putInternal(Element element, boolean doNotNotifyCacheReplicators, boolean useCacheWriter) {
        if (useCacheWriter) {
            this.initialiseCacheWriterManager(true);
        }
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        if (element == null) {
            if (doNotNotifyCacheReplicators) {
                LOG.debug("Element from replicated put is null. This happens because the element is a SoftReference and it has been collected. Increase heap memory on the JVM or set -Xms to be the same as -Xmx to avoid this problem.");
            }
            return;
        }
        if (element.getObjectKey() == null) {
            return;
        }
        element.resetAccessStatistics();
        this.applyDefaultsToElementWithoutLifespanSet(element);
        this.backOffIfDiskSpoolFull();
        element.updateUpdateStatistics();
        if (useCacheWriter) {
            boolean elementExists = false;
            boolean notifyListeners = true;
            try {
                elementExists = !this.compoundStore.putWithWriter(element, this.cacheWriterManager);
            }
            catch (StoreUpdateException e2) {
                elementExists = e2.isUpdate();
                notifyListeners = this.configuration.getCacheWriterConfiguration().getNotifyListenersOnException();
                RuntimeException cause = e2.getCause();
                if (cause instanceof CacheWriterManagerException) {
                    throw ((CacheWriterManagerException)cause).getCause();
                }
                throw cause;
            }
            finally {
                if (notifyListeners) {
                    this.notifyPutInternalListeners(element, doNotNotifyCacheReplicators, elementExists);
                }
            }
        } else {
            boolean elementExists = !this.compoundStore.put(element);
            this.notifyPutInternalListeners(element, doNotNotifyCacheReplicators, elementExists);
        }
    }

    private void putAllInternal(Collection<Element> elements, boolean doNotNotifyCacheReplicators) {
        this.checkStatus();
        if (this.disabled || elements.isEmpty()) {
            return;
        }
        this.backOffIfDiskSpoolFull();
        this.compoundStore.putAll(elements);
        for (Element element : elements) {
            element.resetAccessStatistics();
            this.applyDefaultsToElementWithoutLifespanSet(element);
            this.notifyPutInternalListeners(element, doNotNotifyCacheReplicators, false);
        }
    }

    private void notifyPutInternalListeners(Element element, boolean doNotNotifyCacheReplicators, boolean elementExists) {
        if (elementExists) {
            this.registeredEventListeners.notifyElementUpdated(element, doNotNotifyCacheReplicators);
        } else {
            this.registeredEventListeners.notifyElementPut(element, doNotNotifyCacheReplicators);
        }
    }

    private void backOffIfDiskSpoolFull() {
        if (this.compoundStore.bufferFull()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void applyDefaultsToElementWithoutLifespanSet(Element element) {
        if (!element.isLifespanSet()) {
            element.setLifespanDefaults(TimeUtil.convertTimeToInt(this.configuration.getTimeToIdleSeconds()), TimeUtil.convertTimeToInt(this.configuration.getTimeToLiveSeconds()), this.configuration.isEternal());
        }
    }

    @Override
    public final void putQuiet(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        if (element == null || element.getObjectKey() == null) {
            return;
        }
        this.applyDefaultsToElementWithoutLifespanSet(element);
        this.compoundStore.put(element);
    }

    @Override
    public final Element get(Serializable key) throws IllegalStateException, CacheException {
        return this.get((Object)key);
    }

    @Override
    public final Element get(Object key) throws IllegalStateException, CacheException {
        this.checkStatus();
        if (this.disabled) {
            return null;
        }
        if (this.isStatisticsEnabled()) {
            long start = System.nanoTime();
            Element element = this.searchInStoreWithStats(key);
            long end = System.nanoTime();
            this.liveCacheStatisticsData.addGetTimeNanos(end - start);
            return element;
        }
        return this.searchInStoreWithoutStats(key, false, true);
    }

    @Override
    public Map<Object, Element> getAll(Collection<?> keys) throws IllegalStateException, CacheException {
        this.checkStatus();
        if (this.disabled) {
            return null;
        }
        if ((keys = Collections.unmodifiableCollection(keys)).isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        if (this.isStatisticsEnabled()) {
            long start = System.currentTimeMillis();
            Map<Object, Element> elements = this.searchAllInStoreWithStats(keys);
            this.liveCacheStatisticsData.addGetTimeMillis(System.currentTimeMillis() - start);
            return elements;
        }
        return this.searchAllInStoreWithoutStats(keys);
    }

    @Override
    public Element getWithLoader(Object key, CacheLoader loader, Object loaderArgument) throws CacheException {
        Element element = this.get(key);
        if (element != null) {
            return element;
        }
        if (this.registeredCacheLoaders.size() == 0 && loader == null) {
            return null;
        }
        try {
            Object value;
            element = this.getQuiet(key);
            if (element != null) {
                return element;
            }
            long cacheLoaderTimeoutMillis = this.configuration.getCacheLoaderTimeoutMillis();
            if (cacheLoaderTimeoutMillis > 0L) {
                Future<AtomicReference<Object>> future = this.asynchronousLoad(key, loader, loaderArgument);
                value = future.get(cacheLoaderTimeoutMillis, TimeUnit.MILLISECONDS).get();
            } else {
                value = this.loadValueUsingLoader(key, loader, loaderArgument);
            }
            if (value != null) {
                this.put(new Element(key, value), false);
            }
        }
        catch (TimeoutException e2) {
            throw new LoaderTimeoutException("Timeout on load for key " + key, e2);
        }
        catch (Exception e3) {
            throw new CacheException("Exception on load for key " + key, e3);
        }
        return this.getQuiet(key);
    }

    @Override
    public void load(Object key) throws CacheException {
        if (this.registeredCacheLoaders.size() == 0) {
            LOG.debug("The CacheLoader is null. Returning.");
            return;
        }
        boolean existsOnCall = this.isKeyInCache(key);
        if (existsOnCall) {
            LOG.debug("The key {} exists in the cache. Returning.", key);
            return;
        }
        this.asynchronousPut(key, null, null);
    }

    @Override
    public Map getAllWithLoader(Collection keys, Object loaderArgument) throws CacheException {
        if (keys == null) {
            return new HashMap(0);
        }
        HashMap map = new HashMap(keys.size());
        ArrayList missingKeys = new ArrayList(keys.size());
        if (this.registeredCacheLoaders.size() > 0) {
            Object key = null;
            try {
                map = new HashMap(keys.size());
                for (Object key1 : keys) {
                    key = key1;
                    Element element = this.get(key);
                    if (element == null) {
                        missingKeys.add(key);
                        continue;
                    }
                    map.put(key, element.getObjectValue());
                }
                Future future = this.asynchronousLoadAll(missingKeys, loaderArgument);
                long cacheLoaderTimeoutMillis = this.configuration.getCacheLoaderTimeoutMillis();
                if (cacheLoaderTimeoutMillis > 0L) {
                    try {
                        future.get(cacheLoaderTimeoutMillis, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e2) {
                        throw new LoaderTimeoutException("Timeout on load for key " + key, e2);
                    }
                } else {
                    future.get();
                }
                for (Object missingKey : missingKeys) {
                    key = missingKey;
                    Element element = this.get(key);
                    if (element != null) {
                        map.put(key, element.getObjectValue());
                        continue;
                    }
                    map.put(key, null);
                }
            }
            catch (InterruptedException e3) {
                throw new CacheException(e3.getMessage() + " for key " + key, e3);
            }
            catch (ExecutionException e4) {
                throw new CacheException(e4.getMessage() + " for key " + key, e4);
            }
        } else {
            for (Object key : keys) {
                Element element = this.get(key);
                if (element != null) {
                    map.put(key, element.getObjectValue());
                    continue;
                }
                map.put(key, null);
            }
        }
        return map;
    }

    @Override
    public void loadAll(Collection keys, Object argument) throws CacheException {
        if (this.registeredCacheLoaders.size() == 0) {
            LOG.debug("The CacheLoader is null. Returning.");
            return;
        }
        if (keys == null) {
            return;
        }
        this.asynchronousLoadAll(keys, argument);
    }

    @Override
    public final Element getQuiet(Serializable key) throws IllegalStateException, CacheException {
        return this.getQuiet((Object)key);
    }

    @Override
    public final Element getQuiet(Object key) throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.searchInStoreWithoutStats(key, true, false);
    }

    @Override
    public final List getKeys() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.compoundStore.getKeys();
    }

    @Override
    public final List getKeysWithExpiryCheck() throws IllegalStateException, CacheException {
        List allKeyList = this.getKeys();
        ArrayList nonExpiredKeys = new ArrayList(allKeyList.size());
        for (Object key : allKeyList) {
            Element element = this.getQuiet(key);
            if (element == null) continue;
            nonExpiredKeys.add(key);
        }
        nonExpiredKeys.trimToSize();
        return nonExpiredKeys;
    }

    @Override
    public final List getKeysNoDuplicateCheck() throws IllegalStateException {
        this.checkStatus();
        return this.getKeys();
    }

    private Element searchInStoreWithStats(Object key) {
        Element element;
        boolean hasOnDisk;
        boolean wasInMemory = this.compoundStore.containsKeyInMemory(key);
        boolean wasOffHeap = false;
        boolean hasOffHeap = this.getCacheConfiguration().isOverflowToOffHeap();
        boolean isTCClustered = this.getCacheConfiguration().isTerracottaClustered();
        boolean bl = hasOnDisk = isTCClustered || this.getCacheConfiguration().isOverflowToDisk();
        if (!wasInMemory) {
            this.liveCacheStatisticsData.cacheMissInMemory();
            if (hasOffHeap) {
                wasOffHeap = this.compoundStore.containsKeyOffHeap(key);
            }
        }
        if ((element = this.compoundStore.get(key)) != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.configuration.getName() + " cache hit, but element expired");
                }
                this.liveCacheStatisticsData.cacheMissExpired();
                this.tryRemoveImmediately(key, true);
                element = null;
            } else {
                element.updateAccessStatistics();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cache: " + this.getName() + " store hit for " + key);
                }
                if (wasInMemory) {
                    this.liveCacheStatisticsData.cacheHitInMemory();
                } else if (wasOffHeap) {
                    this.liveCacheStatisticsData.cacheHitOffHeap();
                } else if (hasOffHeap) {
                    this.liveCacheStatisticsData.cacheMissOffHeap();
                    this.liveCacheStatisticsData.cacheHitOnDisk();
                } else {
                    this.liveCacheStatisticsData.cacheHitOnDisk();
                }
            }
        } else {
            this.liveCacheStatisticsData.cacheMissNotFound();
            if (hasOffHeap) {
                this.liveCacheStatisticsData.cacheMissOffHeap();
            }
            if (hasOnDisk) {
                this.liveCacheStatisticsData.cacheMissOnDisk();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.configuration.getName() + " cache - Miss");
            }
        }
        return element;
    }

    private Map<Object, Element> searchAllInStoreWithStats(Collection<?> keys) {
        boolean wasOnDisk = false;
        boolean wasOffHeap = false;
        boolean hasOffHeap = this.getCacheConfiguration().isOverflowToOffHeap();
        boolean isTCClustered = this.getCacheConfiguration().isTerracottaClustered();
        boolean hasOnDisk = isTCClustered || this.getCacheConfiguration().isOverflowToDisk();
        HashMap wasOffHeapMap = new HashMap();
        HashMap wasOnDiskMap = new HashMap();
        for (Object obj : keys) {
            if (this.compoundStore.containsKeyInMemory(obj)) continue;
            this.liveCacheStatisticsData.cacheMissInMemory();
            if (hasOffHeap) {
                wasOffHeap = this.compoundStore.containsKeyOffHeap(obj);
                wasOffHeapMap.put(obj, wasOffHeap);
            }
            if (wasOffHeap) continue;
            if (hasOffHeap) {
                this.liveCacheStatisticsData.cacheMissOffHeap();
            }
            wasOnDisk = this.compoundStore.containsKeyOnDisk(obj);
            wasOnDiskMap.put(obj, wasOnDisk);
            if (!hasOnDisk || wasOnDisk) continue;
            this.liveCacheStatisticsData.cacheMissOnDisk();
        }
        Map<Object, Element> elements = this.compoundStore.getAll(keys);
        for (Map.Entry entry : elements.entrySet()) {
            Object key = entry.getKey();
            Element element = (Element)entry.getValue();
            if (element != null) {
                if (this.isExpired(element)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.configuration.getName() + " cache hit, but element expired");
                    }
                    this.liveCacheStatisticsData.cacheMissExpired();
                    this.tryRemoveImmediately(key, true);
                    element = null;
                } else {
                    element.updateAccessStatistics();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cache: " + this.getName() + " store hit for " + key);
                    }
                    if (wasOffHeapMap.containsKey(key) && ((Boolean)wasOffHeapMap.get(key)).booleanValue()) {
                        this.liveCacheStatisticsData.cacheHitOffHeap();
                    } else if (wasOnDiskMap.containsKey(key) && ((Boolean)wasOnDiskMap.get(key)).booleanValue()) {
                        this.liveCacheStatisticsData.cacheHitOnDisk();
                    } else {
                        this.liveCacheStatisticsData.cacheHitInMemory();
                    }
                }
            } else {
                this.liveCacheStatisticsData.cacheMissNotFound();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.configuration.getName() + " cache - Miss");
                }
            }
            elements.put(key, element);
        }
        return elements;
    }

    private Element searchInStoreWithoutStats(Object key, boolean quiet, boolean notifyListeners) {
        Element element = null;
        element = quiet ? this.compoundStore.getQuiet(key) : this.compoundStore.get(key);
        return this.elementStatsHelper(key, quiet, notifyListeners, element);
    }

    private Element elementStatsHelper(Object key, boolean quiet, boolean notifyListeners, Element element) {
        if (element != null) {
            if (this.isExpired(element)) {
                this.tryRemoveImmediately(key, notifyListeners);
                element = null;
            } else if (!quiet && !this.skipUpdateAccessStatistics(element)) {
                element.updateAccessStatistics();
            }
        }
        return element;
    }

    private Map<Object, Element> searchAllInStoreWithoutStats(Collection<?> keys) {
        Map<Object, Element> elements = this.compoundStore.getAllQuiet(keys);
        for (Map.Entry<Object, Element> entry : elements.entrySet()) {
            Element element = entry.getValue();
            Object key = entry.getKey();
            elements.put(key, this.elementStatsHelper(key, false, true, element));
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryRemoveImmediately(Object key, boolean notifyListeners) {
        boolean writeLocked;
        Sync syncForKey;
        block11: {
            syncForKey = ((CacheLockProvider)this.getInternalContext()).getSyncForKey(key);
            writeLocked = false;
            try {
                writeLocked = syncForKey.tryLock(LockType.WRITE, 0L);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
            catch (LockOperationTimedOutNonstopException e3) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Try lock attempt failed, inline expiry will not happen. Exception: " + e3);
                }
            }
            catch (Error e4) {
                if (e4.getClass().getName().equals("com.tc.exception.TCLockUpgradeNotSupportedError")) break block11;
                throw e4;
            }
        }
        if (writeLocked) {
            try {
                this.removeInternal(key, true, notifyListeners, false, false);
            }
            finally {
                syncForKey.unlock(LockType.WRITE);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(this.configuration.getName() + " cache: element " + key + " expired, but couldn't be inline evicted");
        }
    }

    private boolean skipUpdateAccessStatistics(Element element) {
        return this.configuration.isFrozen() && element.isEternal() && this.configuration.getMaxElementsInMemory() == 0 && (!this.configuration.isOverflowToDisk() || this.configuration.getMaxElementsOnDisk() == 0);
    }

    @Override
    public final boolean remove(Serializable key) throws IllegalStateException {
        return this.remove((Object)key);
    }

    @Override
    public final boolean remove(Object key) throws IllegalStateException {
        return this.remove(key, false);
    }

    @Override
    public final Element removeAndReturnElement(Object key) throws IllegalStateException {
        return this.removeInternal(key, false, true, false, false);
    }

    @Override
    public void removeAll(Collection<?> keys) throws IllegalStateException {
        this.removeAll(keys, false);
    }

    @Override
    public final void removeAll(Collection<?> keys, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        this.removeAllInternal(keys, false, true, doNotNotifyCacheReplicators);
    }

    @Override
    public final boolean remove(Serializable key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.remove((Object)key, doNotNotifyCacheReplicators);
    }

    @Override
    public final boolean remove(Object key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.removeInternal(key, false, true, doNotNotifyCacheReplicators, false) != null;
    }

    @Override
    public final boolean removeQuiet(Serializable key) throws IllegalStateException {
        return this.removeInternal(key, false, false, false, false) != null;
    }

    @Override
    public final boolean removeQuiet(Object key) throws IllegalStateException {
        return this.removeInternal(key, false, false, false, false) != null;
    }

    @Override
    public boolean removeWithWriter(Object key) throws IllegalStateException {
        return this.removeInternal(key, false, true, false, true) != null;
    }

    private Element removeInternal(Object key, boolean expiry, boolean notifyListeners, boolean doNotNotifyCacheReplicators, boolean useCacheWriter) throws IllegalStateException {
        if (useCacheWriter) {
            this.initialiseCacheWriterManager(true);
        }
        this.checkStatus();
        Element elementFromStore = null;
        if (useCacheWriter) {
            try {
                elementFromStore = this.compoundStore.removeWithWriter(key, this.cacheWriterManager);
            }
            catch (CacheWriterManagerException e2) {
                if (this.configuration.getCacheWriterConfiguration().getNotifyListenersOnException()) {
                    this.notifyRemoveInternalListeners(key, expiry, notifyListeners, doNotNotifyCacheReplicators, elementFromStore);
                }
                throw e2.getCause();
            }
        } else {
            elementFromStore = this.compoundStore.remove(key);
        }
        this.notifyRemoveInternalListeners(key, expiry, notifyListeners, doNotNotifyCacheReplicators, elementFromStore);
        return elementFromStore;
    }

    private boolean notifyRemoveInternalListeners(Object key, boolean expiry, boolean notifyListeners, boolean doNotNotifyCacheReplicators, Element elementFromStore) {
        boolean removed = false;
        boolean removeNotified = false;
        if (elementFromStore != null) {
            if (expiry) {
                this.registeredEventListeners.notifyElementExpiry(elementFromStore, doNotNotifyCacheReplicators);
            } else if (notifyListeners) {
                removeNotified = true;
                this.registeredEventListeners.notifyElementRemoved(elementFromStore, doNotNotifyCacheReplicators);
            }
            removed = true;
        }
        if (notifyListeners && !expiry && !removeNotified) {
            Element syntheticElement = new Element(key, null);
            this.registeredEventListeners.notifyElementRemoved(syntheticElement, doNotNotifyCacheReplicators);
        }
        return removed;
    }

    private void removeAllInternal(Collection<?> keys, boolean expiry, boolean notifyListeners, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        this.checkStatus();
        if (this.disabled || keys.isEmpty()) {
            return;
        }
        this.compoundStore.removeAll(keys);
        for (Object key : keys) {
            Element syntheticElement = new Element(key, null);
            this.notifyRemoveInternalListeners(key, false, notifyListeners, doNotNotifyCacheReplicators, syntheticElement);
        }
    }

    @Override
    public void removeAll() throws IllegalStateException, CacheException {
        this.removeAll(false);
    }

    @Override
    public void removeAll(boolean doNotNotifyCacheReplicators) throws IllegalStateException, CacheException {
        this.checkStatus();
        this.compoundStore.removeAll();
        this.registeredEventListeners.notifyRemoveAll(doNotNotifyCacheReplicators);
    }

    @Override
    public synchronized void dispose() throws IllegalStateException {
        if (this.checkStatusAlreadyDisposed()) {
            return;
        }
        if (this.bootstrapCacheLoader != null && this.bootstrapCacheLoader instanceof Disposable) {
            ((Disposable)((Object)this.bootstrapCacheLoader)).dispose();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.disposeRegisteredCacheExtensions();
        this.disposeRegisteredCacheLoaders();
        this.disposeRegisteredCacheWriter();
        this.registeredEventListeners.dispose();
        if (this.cacheWriterManager != null) {
            this.cacheWriterManager.dispose();
        }
        if (this.compoundStore != null) {
            this.compoundStore.removeStoreListener(this);
            this.compoundStore.dispose();
            this.compoundStore = null;
        }
        if (this.xaResource != null) {
            this.transactionManagerLookup.unregister(this.xaResource, true);
            this.xaResource = null;
        }
        this.lockProvider = null;
        if (this.cacheManager != null) {
            this.cacheManager.getCacheRejoinAction().unregister(this);
        }
        this.cacheStatus.changeState(Status.STATUS_SHUTDOWN);
    }

    private void initialiseRegisteredCacheExtensions() {
        for (CacheExtension cacheExtension : this.registeredCacheExtensions) {
            cacheExtension.init();
        }
    }

    private void disposeRegisteredCacheExtensions() {
        for (CacheExtension cacheExtension : this.registeredCacheExtensions) {
            cacheExtension.dispose();
        }
    }

    private void initialiseRegisteredCacheLoaders() {
        for (CacheLoader cacheLoader : this.registeredCacheLoaders) {
            cacheLoader.init();
        }
    }

    private void disposeRegisteredCacheLoaders() {
        for (CacheLoader cacheLoader : this.registeredCacheLoaders) {
            cacheLoader.dispose();
        }
    }

    private void initialiseRegisteredCacheWriter() {
        CacheWriter writer = this.registeredCacheWriter;
        if (writer != null) {
            writer.init();
        }
    }

    private void disposeRegisteredCacheWriter() {
        CacheWriter writer = this.registeredCacheWriter;
        if (writer != null) {
            writer.dispose();
        }
    }

    @Override
    public CacheConfiguration getCacheConfiguration() {
        return this.configuration;
    }

    @Override
    public final synchronized void flush() throws IllegalStateException, CacheException {
        this.checkStatus();
        try {
            this.compoundStore.flush();
        }
        catch (IOException e2) {
            throw new CacheException("Unable to flush cache: " + this.configuration.getName() + ". Initial cause was " + e2.getMessage(), e2);
        }
    }

    @Override
    public final int getSize() throws IllegalStateException, CacheException {
        this.checkStatus();
        if (this.isTerracottaClustered()) {
            return this.compoundStore.getTerracottaClusteredSize();
        }
        return this.compoundStore.getSize();
    }

    @Override
    public int getSizeBasedOnAccuracy(int statisticsAccuracy) throws IllegalStateException, CacheException {
        if (statisticsAccuracy == 1) {
            return this.getSize();
        }
        if (statisticsAccuracy == 2) {
            return this.getKeysWithExpiryCheck().size();
        }
        if (statisticsAccuracy == 0) {
            return this.getKeysNoDuplicateCheck().size();
        }
        throw new IllegalArgumentException("Unknown statistics accuracy: " + statisticsAccuracy);
    }

    @Override
    public final long calculateInMemorySize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.compoundStore.getInMemorySizeInBytes();
    }

    @Override
    public boolean hasAbortedSizeOf() {
        this.checkStatus();
        return this.compoundStore.hasAbortedSizeOf();
    }

    @Override
    public final long calculateOffHeapSize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.compoundStore.getOffHeapSizeInBytes();
    }

    @Override
    public final long calculateOnDiskSize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.compoundStore.getOnDiskSizeInBytes();
    }

    @Override
    public final long getMemoryStoreSize() throws IllegalStateException {
        this.checkStatus();
        return this.compoundStore.getInMemorySize();
    }

    @Override
    public long getOffHeapStoreSize() throws IllegalStateException {
        this.checkStatus();
        return this.compoundStore.getOffHeapSize();
    }

    @Override
    public final int getDiskStoreSize() throws IllegalStateException {
        this.checkStatus();
        if (this.isTerracottaClustered()) {
            return this.compoundStore.getTerracottaClusteredSize();
        }
        return this.compoundStore.getOnDiskSize();
    }

    @Override
    public final Status getStatus() {
        return this.cacheStatus.getStatus();
    }

    private void checkStatus() throws IllegalStateException {
        this.cacheStatus.checkAlive(this.configuration);
    }

    private boolean checkStatusAlreadyDisposed() throws IllegalStateException {
        return this.cacheStatus.isShutdown();
    }

    @Override
    public final String getName() {
        return this.configuration.getName();
    }

    @Override
    public final void setName(String name) throws IllegalArgumentException {
        if (!this.cacheStatus.isUninitialized()) {
            throw new IllegalStateException("Only uninitialised caches can have their names set.");
        }
        this.configuration.setName(name);
    }

    @Override
    public String toString() {
        StringBuilder dump = new StringBuilder();
        dump.append("[").append(" name = ").append(this.configuration.getName()).append(" status = ").append(this.cacheStatus.getStatus()).append(" eternal = ").append(this.configuration.isEternal()).append(" overflowToDisk = ").append(this.configuration.isOverflowToDisk()).append(" maxEntriesLocalHeap = ").append(this.configuration.getMaxEntriesLocalHeap()).append(" maxEntriesLocalDisk = ").append(this.configuration.getMaxEntriesLocalDisk()).append(" memoryStoreEvictionPolicy = ").append(this.configuration.getMemoryStoreEvictionPolicy()).append(" timeToLiveSeconds = ").append(this.configuration.getTimeToLiveSeconds()).append(" timeToIdleSeconds = ").append(this.configuration.getTimeToIdleSeconds()).append(" persistence = ").append(this.configuration.getPersistenceConfiguration() == null ? "none" : this.configuration.getPersistenceConfiguration().getStrategy()).append(" diskExpiryThreadIntervalSeconds = ").append(this.configuration.getDiskExpiryThreadIntervalSeconds()).append(this.registeredEventListeners).append(" hitCount = ").append(this.getLiveCacheStatisticsNoCheck().getCacheHitCount()).append(" memoryStoreHitCount = ").append(this.getLiveCacheStatisticsNoCheck().getInMemoryHitCount()).append(" diskStoreHitCount = ").append(this.getLiveCacheStatisticsNoCheck().getOnDiskHitCount()).append(" missCountNotFound = ").append(this.getLiveCacheStatisticsNoCheck().getCacheMissCount()).append(" missCountExpired = ").append(this.getLiveCacheStatisticsNoCheck().getCacheMissCountExpired()).append(" maxBytesLocalHeap = ").append(this.configuration.getMaxBytesLocalHeap()).append(" overflowToOffHeap = ").append(this.configuration.isOverflowToOffHeap()).append(" maxBytesLocalOffHeap = ").append(this.configuration.getMaxBytesLocalOffHeap()).append(" maxBytesLocalDisk = ").append(this.configuration.getMaxBytesLocalDisk()).append(" pinned = ").append(this.configuration.getPinningConfiguration() != null ? this.configuration.getPinningConfiguration().getStore().name() : "false").append(" ]");
        return dump.toString();
    }

    @Override
    public final boolean isExpired(Element element) throws IllegalStateException, NullPointerException {
        this.checkStatus();
        return element.isExpired(this.configuration);
    }

    @Override
    public final Cache clone() throws CloneNotSupportedException {
        if (this.compoundStore != null) {
            throw new CloneNotSupportedException("Cannot clone an initialized cache.");
        }
        Cache copy = (Cache)super.clone();
        copy.liveCacheStatisticsData = new LiveCacheStatisticsWrapper(copy);
        copy.sampledCacheStatistics = new SampledCacheStatisticsWrapper();
        copy.configuration = this.configuration.clone();
        copy.guid = this.createGuid();
        copy.cacheStatus = new CacheStatus();
        copy.cacheStatus.changeState(Status.STATUS_UNINITIALISED);
        copy.configuration.getCopyStrategyConfiguration().setCopyStrategyInstance(null);
        copy.elementValueComparator = copy.configuration.getElementValueComparatorConfiguration().createElementComparatorInstance(copy.configuration);
        copy.propertyChangeSupport = new PropertyChangeSupport(copy);
        copy.nonstopActiveDelegateHolder = new NonstopActiveDelegateHolderImpl(copy);
        copy.cacheWriterManagerInitFlag = new AtomicBoolean(false);
        copy.cacheWriterManagerInitLock = new ReentrantLock();
        for (PropertyChangeListener propertyChangeListener : this.propertyChangeSupport.getPropertyChangeListeners()) {
            copy.addPropertyChangeListener(propertyChangeListener);
        }
        RegisteredEventListeners registeredEventListenersFromCopy = copy.getCacheEventNotificationService();
        if (registeredEventListenersFromCopy == null || registeredEventListenersFromCopy.getCacheEventListeners().size() == 0) {
            copy.registeredEventListeners = new RegisteredEventListeners(copy);
        } else {
            copy.registeredEventListeners = new RegisteredEventListeners(copy);
            Set<CacheEventListener> cacheEventListeners = this.registeredEventListeners.getCacheEventListeners();
            Iterator<CacheEventListener> i$ = cacheEventListeners.iterator();
            while (i$.hasNext()) {
                CacheEventListener cacheEventListener1;
                CacheEventListener cacheEventListener = cacheEventListener1 = i$.next();
                CacheEventListener cacheEventListenerClone = (CacheEventListener)cacheEventListener.clone();
                copy.registeredEventListeners.registerListener(cacheEventListenerClone);
            }
        }
        copy.registeredCacheExtensions = new CopyOnWriteArrayList<CacheExtension>();
        for (CacheExtension registeredCacheExtension : this.registeredCacheExtensions) {
            copy.registerCacheExtension(registeredCacheExtension.clone(copy));
        }
        copy.registeredCacheLoaders = new CopyOnWriteArrayList<CacheLoader>();
        for (CacheLoader registeredCacheLoader : this.registeredCacheLoaders) {
            copy.registerCacheLoader(registeredCacheLoader.clone(copy));
        }
        if (this.registeredCacheWriter != null) {
            copy.registerCacheWriter(this.registeredCacheWriter.clone(copy));
        }
        if (this.bootstrapCacheLoader != null) {
            BootstrapCacheLoader bootstrapCacheLoaderClone = (BootstrapCacheLoader)this.bootstrapCacheLoader.clone();
            copy.setBootstrapCacheLoader(bootstrapCacheLoaderClone);
        }
        return copy;
    }

    final Store getStore() throws IllegalStateException {
        this.checkStatus();
        return this.compoundStore;
    }

    public final Object getStoreMBean() {
        return this.getStore().getMBean();
    }

    @Override
    public final RegisteredEventListeners getCacheEventNotificationService() {
        return this.registeredEventListeners;
    }

    @Override
    public final boolean isElementInMemory(Serializable key) {
        return this.isElementInMemory((Object)key);
    }

    @Override
    public final boolean isElementInMemory(Object key) {
        this.checkStatus();
        return this.compoundStore.containsKeyInMemory(key);
    }

    public final boolean isElementOffHeap(Object key) {
        this.checkStatus();
        return this.compoundStore.containsKeyOffHeap(key);
    }

    @Override
    public final boolean isElementOnDisk(Serializable key) {
        return this.isElementOnDisk((Object)key);
    }

    @Override
    public final boolean isElementOnDisk(Object key) {
        this.checkStatus();
        return this.compoundStore.containsKeyOnDisk(key);
    }

    @Override
    public final String getGuid() {
        return this.guid;
    }

    @Override
    public final CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void clearStatistics() throws IllegalStateException {
        this.checkStatus();
        this.liveCacheStatisticsData.clearStatistics();
        this.sampledCacheStatistics.clearStatistics();
        this.registeredEventListeners.clearCounters();
    }

    @Override
    public int getStatisticsAccuracy() {
        return this.getLiveCacheStatistics().getStatisticsAccuracy();
    }

    @Override
    public void setStatisticsAccuracy(int statisticsAccuracy) {
        int oldValue = this.getStatisticsAccuracy();
        if (statisticsAccuracy != oldValue) {
            this.liveCacheStatisticsData.setStatisticsAccuracy(statisticsAccuracy);
            this.firePropertyChange("StatisticsAccuracy", oldValue, statisticsAccuracy);
        }
    }

    @Override
    public void evictExpiredElements() {
        this.checkStatus();
        this.compoundStore.expireElements();
    }

    @Override
    public boolean isKeyInCache(Object key) {
        if (key == null) {
            return false;
        }
        return this.compoundStore.containsKey(key);
    }

    @Override
    public boolean isValueInCache(Object value) {
        for (Object key : this.getKeys()) {
            Serializable elementValue;
            Element element = this.get(key);
            if (element == null || !((elementValue = element.getValue()) == null ? value == null : elementValue.equals(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Statistics getStatistics() throws IllegalStateException {
        int size = this.getSizeBasedOnAccuracy(this.getLiveCacheStatistics().getStatisticsAccuracy());
        return new Statistics(this, this.getLiveCacheStatistics().getStatisticsAccuracy(), this.getLiveCacheStatistics().getCacheHitCount(), this.getLiveCacheStatistics().getOnDiskHitCount(), this.getLiveCacheStatistics().getOffHeapHitCount(), this.getLiveCacheStatistics().getInMemoryHitCount(), this.getLiveCacheStatistics().getCacheMissCount(), this.getLiveCacheStatistics().getOnDiskMissCount(), this.getLiveCacheStatistics().getOffHeapMissCount(), this.getLiveCacheStatistics().getInMemoryMissCount(), size, this.getAverageGetTime(), this.getLiveCacheStatistics().getEvictedCount(), this.getMemoryStoreSize(), this.getOffHeapStoreSize(), this.getDiskStoreSize(), this.getSearchesPerSecond(), this.getAverageSearchTime(), this.getLiveCacheStatistics().getWriterQueueLength());
    }

    @Override
    public long getAverageSearchTime() {
        return this.sampledCacheStatistics.getAverageSearchTime();
    }

    @Override
    public long getSearchesPerSecond() {
        return this.sampledCacheStatistics.getSearchesPerSecond();
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        CacheManager oldValue = this.getCacheManager();
        if (oldValue != null) {
            oldValue.getCacheRejoinAction().unregister(this);
        }
        this.cacheManager = cacheManager;
        cacheManager.getCacheRejoinAction().register(this);
        this.firePropertyChange("CacheManager", oldValue, cacheManager);
    }

    @Override
    public BootstrapCacheLoader getBootstrapCacheLoader() {
        return this.bootstrapCacheLoader;
    }

    @Override
    public void setBootstrapCacheLoader(BootstrapCacheLoader bootstrapCacheLoader) throws CacheException {
        if (!this.cacheStatus.isUninitialized()) {
            throw new CacheException("A bootstrap cache loader can only be set before the cache is initialized. " + this.configuration.getName());
        }
        BootstrapCacheLoader oldValue = this.getBootstrapCacheLoader();
        this.bootstrapCacheLoader = bootstrapCacheLoader;
        this.firePropertyChange("BootstrapCacheLoader", oldValue, bootstrapCacheLoader);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Ehcache)) {
            return false;
        }
        Ehcache other = (Ehcache)object;
        return this.guid.equals(other.getGuid());
    }

    public int hashCode() {
        return this.guid.hashCode();
    }

    private String createGuid() {
        StringBuilder buffer = new StringBuilder().append(localhost).append("-").append(UUID.randomUUID());
        return buffer.toString();
    }

    @Override
    public void registerCacheExtension(CacheExtension cacheExtension) {
        this.registeredCacheExtensions.add(cacheExtension);
    }

    @Override
    public List<CacheExtension> getRegisteredCacheExtensions() {
        return this.registeredCacheExtensions;
    }

    @Override
    public void unregisterCacheExtension(CacheExtension cacheExtension) {
        cacheExtension.dispose();
        this.registeredCacheExtensions.remove(cacheExtension);
    }

    @Override
    public float getAverageGetTime() {
        return this.getLiveCacheStatistics().getAverageGetTimeMillis();
    }

    @Override
    public void setCacheExceptionHandler(CacheExceptionHandler cacheExceptionHandler) {
        CacheExceptionHandler oldValue = this.getCacheExceptionHandler();
        this.cacheExceptionHandler = cacheExceptionHandler;
        this.firePropertyChange("CacheExceptionHandler", oldValue, cacheExceptionHandler);
    }

    @Override
    public CacheExceptionHandler getCacheExceptionHandler() {
        return this.cacheExceptionHandler;
    }

    @Override
    public void registerCacheLoader(CacheLoader cacheLoader) {
        this.registeredCacheLoaders.add(cacheLoader);
    }

    @Override
    public void unregisterCacheLoader(CacheLoader cacheLoader) {
        this.registeredCacheLoaders.remove(cacheLoader);
    }

    @Override
    public List<CacheLoader> getRegisteredCacheLoaders() {
        return this.registeredCacheLoaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCacheWriter(CacheWriter cacheWriter) {
        Cache cache = this;
        synchronized (cache) {
            this.registeredCacheWriter = cacheWriter;
            if (this.cacheStatus.isAlive()) {
                this.initialiseRegisteredCacheWriter();
            }
        }
        this.initialiseCacheWriterManager(false);
    }

    @Override
    public void unregisterCacheWriter() {
        if (this.cacheWriterManagerInitFlag.get()) {
            throw new CacheException("Cache: " + this.configuration.getName() + " has its cache writer being unregistered " + "after it was already initialised.");
        }
        this.registeredCacheWriter = null;
    }

    @Override
    public CacheWriter getRegisteredCacheWriter() {
        return this.registeredCacheWriter;
    }

    @Override
    public void registerDynamicAttributesExtractor(DynamicAttributesExtractor extractor) {
        this.configuration.setDynamicAttributesExtractor(extractor);
    }

    Future asynchronousPut(final Object key, final CacheLoader specificLoader, final Object argument) {
        return this.getExecutorService().submit(new Runnable(){

            @Override
            public void run() throws CacheException {
                try {
                    Object value;
                    boolean existsOnRun = Cache.this.isKeyInCache(key);
                    if (!existsOnRun && (value = Cache.this.loadValueUsingLoader(key, specificLoader, argument)) != null) {
                        Cache.this.put(new Element(key, value), false);
                    }
                }
                catch (RuntimeException e2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Problem during load. Load will not be completed. Cause was " + e2.getCause(), e2);
                    }
                    throw new CacheException("Problem during load. Load will not be completed. Cause was " + e2.getCause(), e2);
                }
            }
        });
    }

    Future<AtomicReference<Object>> asynchronousLoad(final Object key, final CacheLoader specificLoader, final Object argument) {
        final AtomicReference result = new AtomicReference();
        return this.getExecutorService().submit(new Runnable(){

            @Override
            public void run() throws CacheException {
                try {
                    Object value;
                    boolean existsOnRun = Cache.this.isKeyInCache(key);
                    if (!existsOnRun && (value = Cache.this.loadValueUsingLoader(key, specificLoader, argument)) != null) {
                        result.set(value);
                    }
                }
                catch (RuntimeException e2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Problem during load. Load will not be completed. Cause was " + e2.getCause(), e2);
                    }
                    throw new CacheException("Problem during load. Load will not be completed. Cause was " + e2.getCause(), e2);
                }
            }
        }, result);
    }

    private Object loadValueUsingLoader(Object key, CacheLoader specificLoader, Object argument) {
        Object value = null;
        if (specificLoader != null) {
            value = argument == null ? specificLoader.load(key) : specificLoader.load(key, argument);
        } else if (!this.registeredCacheLoaders.isEmpty()) {
            value = this.loadWithRegisteredLoaders(argument, key);
        }
        return value;
    }

    private Object loadWithRegisteredLoaders(Object argument, Object key) throws CacheException {
        Object value = null;
        if (argument == null) {
            CacheLoader registeredCacheLoader;
            Iterator<CacheLoader> i$ = this.registeredCacheLoaders.iterator();
            while (i$.hasNext() && (value = (registeredCacheLoader = i$.next()).load(key)) == null) {
            }
        } else {
            CacheLoader registeredCacheLoader;
            Iterator<CacheLoader> i$ = this.registeredCacheLoaders.iterator();
            while (i$.hasNext() && (value = (registeredCacheLoader = i$.next()).load(key, argument)) == null) {
            }
        }
        return value;
    }

    Future asynchronousLoadAll(final Collection keys, final Object argument) {
        return this.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        HashSet<Object> nonLoadedKeys = new HashSet<Object>();
                        for (Object key : keys) {
                            if (Cache.this.isKeyInCache(key)) continue;
                            nonLoadedKeys.add(key);
                        }
                        Map map = Cache.this.loadWithRegisteredLoaders(argument, nonLoadedKeys);
                        for (Map.Entry e2 : map.entrySet()) {
                            Cache.this.put(new Element(e2.getKey(), e2.getValue()));
                        }
                    }
                    catch (Throwable e3) {
                        if (!LOG.isErrorEnabled()) break block4;
                        LOG.error("Problem during load. Load will not be completed. Cause was " + e3.getCause(), e3);
                    }
                }
            }
        });
    }

    Map loadWithRegisteredLoaders(Object argument, Set<Object> nonLoadedKeys) {
        HashMap result = new HashMap();
        for (CacheLoader registeredCacheLoader : this.registeredCacheLoaders) {
            if (nonLoadedKeys.isEmpty()) break;
            Map resultForThisCacheLoader = null;
            resultForThisCacheLoader = argument == null ? registeredCacheLoader.loadAll(nonLoadedKeys) : registeredCacheLoader.loadAll(nonLoadedKeys, argument);
            if (resultForThisCacheLoader == null) continue;
            nonLoadedKeys.removeAll(resultForThisCacheLoader.keySet());
            result.putAll(resultForThisCacheLoader);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService getExecutorService() {
        if (this.executorService == null) {
            Cache cache = this;
            synchronized (cache) {
                this.executorService = VmUtils.isInGoogleAppEngine() ? new AbstractExecutorService(){

                    @Override
                    public void execute(Runnable command) {
                        command.run();
                    }

                    @Override
                    public List<Runnable> shutdownNow() {
                        return Collections.emptyList();
                    }

                    @Override
                    public void shutdown() {
                    }

                    @Override
                    public boolean isTerminated() {
                        return this.isShutdown();
                    }

                    @Override
                    public boolean isShutdown() {
                        return false;
                    }

                    @Override
                    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                        return true;
                    }
                } : new ThreadPoolExecutor(1, EXECUTOR_MAXIMUM_POOL_SIZE, 60000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("Cache Executor Service"));
            }
        }
        return this.executorService;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisabled(boolean disabled) {
        if (this.allowDisable) {
            boolean oldValue = this.isDisabled();
            if (oldValue != disabled) {
                Cache cache = this;
                synchronized (cache) {
                    this.disabled = disabled;
                }
                this.firePropertyChange("Disabled", oldValue, disabled);
            }
        } else {
            throw new CacheException("Dynamic cache features are disabled");
        }
    }

    public Policy getMemoryStoreEvictionPolicy() {
        this.checkStatus();
        return this.compoundStore.getInMemoryEvictionPolicy();
    }

    public void setMemoryStoreEvictionPolicy(Policy policy) {
        this.checkStatus();
        Policy oldValue = this.getMemoryStoreEvictionPolicy();
        this.compoundStore.setInMemoryEvictionPolicy(policy);
        this.firePropertyChange("MemoryStoreEvictionPolicy", oldValue, policy);
    }

    @Override
    public LiveCacheStatistics getLiveCacheStatistics() throws IllegalStateException {
        this.checkStatus();
        return this.liveCacheStatisticsData;
    }

    private LiveCacheStatistics getLiveCacheStatisticsNoCheck() {
        return this.liveCacheStatisticsData;
    }

    @Override
    public void registerCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.checkStatus();
        this.liveCacheStatisticsData.registerCacheUsageListener(cacheUsageListener);
    }

    @Override
    public void removeCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.checkStatus();
        this.liveCacheStatisticsData.removeCacheUsageListener(cacheUsageListener);
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.getLiveCacheStatistics().isStatisticsEnabled();
    }

    @Override
    public void setStatisticsEnabled(boolean enableStatistics) {
        boolean oldValue = this.isStatisticsEnabled();
        if (oldValue != enableStatistics) {
            this.liveCacheStatisticsData.setStatisticsEnabled(enableStatistics);
            if (!enableStatistics) {
                this.setSampledStatisticsEnabled(false);
            }
            this.firePropertyChange("StatisticsEnabled", oldValue, enableStatistics);
        }
    }

    @Override
    public SampledCacheStatistics getSampledCacheStatistics() {
        return this.sampledCacheStatistics;
    }

    public CacheStatisticsSampler getCacheStatisticsSampler() {
        return this.sampledCacheStatistics;
    }

    @Override
    public void setSampledStatisticsEnabled(boolean enableStatistics) {
        if (this.cacheManager == null) {
            throw new IllegalStateException("You must add the cache to a CacheManager before enabling/disabling sampled statistics.");
        }
        boolean oldValue = this.isSampledStatisticsEnabled();
        if (oldValue != enableStatistics) {
            if (enableStatistics) {
                ManagementRESTServiceConfiguration mgmtRESTConfigSvc = this.cacheManager.getConfiguration().getManagementRESTService();
                if (mgmtRESTConfigSvc != null && mgmtRESTConfigSvc.isEnabled()) {
                    this.sampledCacheStatistics.enableSampledStatistics(this.cacheManager.getTimer(), mgmtRESTConfigSvc.makeSampledCounterConfig(), mgmtRESTConfigSvc.makeSampledGetRateCounterConfig(), mgmtRESTConfigSvc.makeSampledSearchRateCounterConfig());
                } else {
                    this.sampledCacheStatistics.enableSampledStatistics(this.cacheManager.getTimer());
                }
                this.setStatisticsEnabled(true);
            } else {
                this.sampledCacheStatistics.disableSampledStatistics();
            }
            this.firePropertyChange("SampledStatisticsEnabled", oldValue, enableStatistics);
        }
    }

    @Override
    public boolean isSampledStatisticsEnabled() {
        return this.sampledCacheStatistics.isSampledStatisticsEnabled();
    }

    @Override
    public Object getInternalContext() {
        this.checkStatus();
        return this.compoundStore.getInternalContext();
    }

    @Override
    public void disableDynamicFeatures() {
        this.configuration.freezeConfiguration();
        this.allowDisable = false;
    }

    @Override
    @Deprecated
    public boolean isClusterCoherent() {
        return !this.isClusterBulkLoadEnabled();
    }

    @Override
    @Deprecated
    public boolean isNodeCoherent() {
        return !this.isNodeBulkLoadEnabled();
    }

    @Override
    @Deprecated
    public void setNodeCoherent(boolean coherent) {
        this.setNodeBulkLoadEnabled(!coherent);
    }

    @Override
    @Deprecated
    public void waitUntilClusterCoherent() {
        this.waitUntilClusterBulkLoadComplete();
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null && this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null && this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport pcs;
        Cache cache = this;
        synchronized (cache) {
            pcs = this.propertyChangeSupport;
        }
        if (pcs != null && (oldValue != null || newValue != null)) {
            pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        return this.putIfAbsent(element, false);
    }

    @Override
    public Element putIfAbsent(Element element, boolean doNotNotifyCacheReplicators) throws NullPointerException {
        this.checkStatus();
        this.checkCASOperationSupported(doNotNotifyCacheReplicators);
        if (element.getObjectKey() == null) {
            throw new NullPointerException();
        }
        if (this.disabled) {
            return null;
        }
        this.getQuiet(element.getObjectKey());
        element.resetAccessStatistics();
        this.applyDefaultsToElementWithoutLifespanSet(element);
        this.backOffIfDiskSpoolFull();
        element.updateUpdateStatistics();
        Element result = this.compoundStore.putIfAbsent(element);
        if (result == null) {
            this.notifyPutInternalListeners(element, doNotNotifyCacheReplicators, false);
        }
        return result;
    }

    @Override
    public boolean removeElement(Element element) throws NullPointerException {
        this.checkStatus();
        this.checkCASOperationSupported();
        if (element.getObjectKey() == null) {
            throw new NullPointerException();
        }
        if (this.disabled) {
            return false;
        }
        this.getQuiet(element.getObjectKey());
        Element result = this.compoundStore.removeElement(element, this.elementValueComparator);
        this.notifyRemoveInternalListeners(element.getObjectKey(), false, true, false, result);
        return result != null;
    }

    @Override
    public boolean replace(Element old, Element element) throws NullPointerException, IllegalArgumentException {
        this.checkStatus();
        this.checkCASOperationSupported();
        if (old.getObjectKey() == null || element.getObjectKey() == null) {
            throw new NullPointerException();
        }
        if (!old.getObjectKey().equals(element.getObjectKey())) {
            throw new IllegalArgumentException("The keys for the element arguments to replace must be equal");
        }
        if (this.disabled) {
            return false;
        }
        this.getQuiet(old.getObjectKey());
        element.resetAccessStatistics();
        this.applyDefaultsToElementWithoutLifespanSet(element);
        this.backOffIfDiskSpoolFull();
        boolean result = this.compoundStore.replace(old, element, this.elementValueComparator);
        if (result) {
            element.updateUpdateStatistics();
            this.notifyPutInternalListeners(element, false, true);
        }
        return result;
    }

    @Override
    public Element replace(Element element) throws NullPointerException {
        this.checkStatus();
        this.checkCASOperationSupported();
        if (element.getObjectKey() == null) {
            throw new NullPointerException();
        }
        if (this.disabled) {
            return null;
        }
        this.getQuiet(element.getObjectKey());
        element.resetAccessStatistics();
        this.applyDefaultsToElementWithoutLifespanSet(element);
        this.backOffIfDiskSpoolFull();
        Element result = this.compoundStore.replace(element);
        if (result != null) {
            element.updateUpdateStatistics();
            this.notifyPutInternalListeners(element, false, true);
        }
        return result;
    }

    private void checkCASOperationSupported() {
        this.checkCASOperationSupported(false);
    }

    private void checkCASOperationSupported(boolean doNotNotifyCacheReplicators) {
        if (!doNotNotifyCacheReplicators && this.registeredEventListeners.hasCacheReplicators()) {
            throw new CacheException("You have configured the cache with a replication scheme that cannot properly support CAS operation guarantees.");
        }
    }

    @Override
    public void clusterCoherent(boolean clusterCoherent) {
        this.firePropertyChange("ClusterCoherent", !clusterCoherent, clusterCoherent);
    }

    @Override
    public <T> Attribute<T> getSearchAttribute(String attributeName) throws CacheException {
        this.checkStatus();
        Attribute searchAttribute = this.compoundStore.getSearchAttribute(attributeName);
        if (searchAttribute == null) {
            String msg = attributeName.equals(Query.KEY.getAttributeName()) ? "Key search attribute is disabled for cache [" + this.getName() + "]. It can be enabled with <searchable keys=\"true\"..." : (attributeName.equals(Query.VALUE.getAttributeName()) ? "Value search attribute is disabled for cache [" + this.getName() + "]. It can be enabled with <searchable values=\"true\"..." : "No such search attribute [" + attributeName + "] defined for this cache [" + this.getName() + "]");
            throw new CacheException(msg);
        }
        return searchAttribute;
    }

    @Override
    public Query createQuery() {
        if (!this.isSearchable()) {
            throw new CacheException("This cache is not configured for search");
        }
        return new CacheQuery(this);
    }

    Results executeQuery(StoreQuery query) throws SearchException {
        this.validateSearchQuery(query);
        if (this.isStatisticsEnabled()) {
            long start = System.currentTimeMillis();
            Results results = this.compoundStore.executeQuery(query);
            this.sampledCacheStatistics.notifyCacheSearch(System.currentTimeMillis() - start);
            return results;
        }
        return this.compoundStore.executeQuery(query);
    }

    @Override
    public boolean isSearchable() {
        return this.configuration.isSearchable();
    }

    void clusterRejoinStarted() {
        try {
            this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().dispose();
        }
        catch (Exception e2) {
            LOG.debug("Ignoring exception while disposing old store on rejoin - " + e2.getMessage(), e2);
        }
        this.cacheStatus.clusterRejoinInProgress();
    }

    void clusterRejoinComplete() {
        this.initialise();
        if (this.cacheWriterManagerInitFlag.compareAndSet(true, false)) {
            this.initialiseCacheWriterManager(this.registeredCacheWriter != null);
        }
        this.cacheStatus.clusterRejoinComplete();
        if (this.compoundStore instanceof RejoinAwareNonstopStore) {
            ((RejoinAwareNonstopStore)this.compoundStore).clusterRejoined();
        }
    }

    protected Sync getLockForKey(Object key) {
        this.checkStatus();
        return this.lockProvider.getSyncForKey(key);
    }

    private void acquireLockOnKey(Object key, LockType lockType) {
        Sync s2 = this.getLockForKey(key);
        s2.lock(lockType);
    }

    private void releaseLockOnKey(Object key, LockType lockType) {
        Sync s2 = this.getLockForKey(key);
        s2.unlock(lockType);
    }

    @Override
    public void acquireReadLockOnKey(Object key) {
        this.acquireLockOnKey(key, LockType.READ);
    }

    @Override
    public void acquireWriteLockOnKey(Object key) {
        this.acquireLockOnKey(key, LockType.WRITE);
    }

    @Override
    public boolean tryReadLockOnKey(Object key, long timeout) throws InterruptedException {
        Sync s2 = this.getLockForKey(key);
        return s2.tryLock(LockType.READ, timeout);
    }

    @Override
    public boolean tryWriteLockOnKey(Object key, long timeout) throws InterruptedException {
        Sync s2 = this.getLockForKey(key);
        return s2.tryLock(LockType.WRITE, timeout);
    }

    @Override
    public void releaseReadLockOnKey(Object key) {
        this.releaseLockOnKey(key, LockType.READ);
    }

    @Override
    public void releaseWriteLockOnKey(Object key) {
        this.releaseLockOnKey(key, LockType.WRITE);
    }

    @Override
    public boolean isReadLockedByCurrentThread(Object key) throws UnsupportedOperationException {
        return this.getLockForKey(key).isHeldByCurrentThread(LockType.READ);
    }

    @Override
    public boolean isWriteLockedByCurrentThread(Object key) {
        return this.getLockForKey(key).isHeldByCurrentThread(LockType.WRITE);
    }

    @Override
    public boolean isClusterBulkLoadEnabled() throws UnsupportedOperationException, TerracottaNotRunningException {
        this.checkStatus();
        return !this.compoundStore.isClusterCoherent();
    }

    @Override
    public boolean isNodeBulkLoadEnabled() throws UnsupportedOperationException, TerracottaNotRunningException {
        this.checkStatus();
        return !this.compoundStore.isNodeCoherent();
    }

    @Override
    public void setNodeBulkLoadEnabled(boolean enabledBulkLoad) throws UnsupportedOperationException, TerracottaNotRunningException {
        boolean oldValue = this.isNodeBulkLoadEnabled();
        if (oldValue != enabledBulkLoad) {
            this.compoundStore.setNodeCoherent(!enabledBulkLoad);
            this.nonstopActiveDelegateHolder.nodeBulkLoadChanged(enabledBulkLoad);
            this.firePropertyChange("NodeCoherent", oldValue, enabledBulkLoad);
        }
    }

    @Override
    public void waitUntilClusterBulkLoadComplete() throws UnsupportedOperationException, TerracottaNotRunningException {
        this.checkStatus();
        try {
            this.compoundStore.waitUntilClusterCoherent();
        }
        catch (InterruptedException e2) {
            throw new CacheException(e2);
        }
    }

    @Override
    public void unpinAll() {
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        this.compoundStore.unpinAll();
    }

    @Override
    public boolean isPinned(Object key) {
        this.checkStatus();
        if (this.disabled || key == null) {
            return false;
        }
        return this.compoundStore.isPinned(key);
    }

    @Override
    public void setPinned(Object key, boolean pinned) {
        this.checkStatus();
        if (this.disabled || key == null) {
            return;
        }
        this.compoundStore.setPinned(key, pinned);
    }

    protected NonstopActiveDelegateHolder getNonstopActiveDelegateHolder() {
        return this.nonstopActiveDelegateHolder;
    }

    @Override
    public void recalculateSize(Object key) {
        this.checkStatus();
        this.compoundStore.recalculateSize(key);
    }

    private void validateSearchQuery(StoreQuery query) throws SearchException {
        if (!query.requestsKeys() && !query.requestsValues() && query.requestedAttributes().isEmpty() && query.getAggregatorInstances().isEmpty()) {
            String msg = "No results specified. Please specify one or more of includeKeys(), includeValues(), includeAggregator() or includeAttribute()";
            throw new SearchException(msg);
        }
        Set<Attribute<Attribute<?>>> groupBy = query.groupByAttributes();
        if (!groupBy.isEmpty()) {
            if (groupBy.contains(Query.KEY)) {
                throw new SearchException("Explicit grouping by element key not supported.");
            }
            if (groupBy.contains(Query.VALUE)) {
                throw new SearchException("Grouping by element value not supported.");
            }
            if (!groupBy.containsAll(query.requestedAttributes())) {
                throw new SearchException("Some of the requested attributes not used in group by clause.");
            }
            for (StoreQuery.Ordering order : query.getOrdering()) {
                if (groupBy.contains(order.getAttribute())) continue;
                throw new SearchException("All ordering attributes must be present in group by clause.");
            }
            if (query.requestsValues() || query.requestsKeys()) {
                throw new SearchException("It is not possible to include keys or values with group by queries.");
            }
        }
    }

    static {
        EXECUTOR_MAXIMUM_POOL_SIZE = Math.min(10, Runtime.getRuntime().availableProcessors());
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e2) {
            LOG.error("Unable to set localhost. This prevents creation of a GUID. Cause was: " + e2.getMessage(), e2);
        }
        catch (NoClassDefFoundError e3) {
            LOG.debug("InetAddress is being blocked by your runtime environment. e.g. Google App Engine. Ehcache will work as a local cache.");
        }
    }

    private static class NonstopActiveDelegateHolderImpl
    implements NonstopActiveDelegateHolder {
        private final Cache cache;
        private volatile NonstopStoreImpl nonstopStore;
        private volatile TerracottaStore underlyingTerracottaStore;
        private volatile NonstopExecutorService nonstopExecutorService;
        private volatile CacheLockProvider underlyingCacheLockProvider;
        private volatile boolean nodeBulkLoadEnabled;
        private volatile CacheEventListener cacheEventReplicator;

        public NonstopActiveDelegateHolderImpl(Cache cache) {
            this.cache = cache;
        }

        public void nodeBulkLoadChanged(boolean enabled) {
            this.nodeBulkLoadEnabled = enabled;
        }

        @Override
        public RejoinAwareNonstopStore getNonstopStore() {
            if (this.nonstopStore != null) {
                return this.nonstopStore;
            }
            this.initializeNonstopStore();
            return this.nonstopStore;
        }

        private synchronized void initializeNonstopStore() {
            if (this.nonstopStore == null) {
                if (!this.cache.getCacheConfiguration().isTerracottaClustered()) {
                    throw new AssertionError((Object)"NonstopStore supported for Terracotta clustered caches only");
                }
                if (!this.cache.getCacheConfiguration().getTerracottaConfiguration().isNonstopEnabled()) {
                    throw new AssertionError((Object)"Nonstop is not enabled");
                }
                this.nonstopStore = new NonstopStoreImpl(this, this.cache.getCacheCluster(), this.cache.getCacheConfiguration().getTerracottaConfiguration().getNonstopConfiguration(), this.cache.getCacheConfiguration().getTransactionalMode(), this.cache.getTransactionManagerLookup());
            }
        }

        @Override
        public synchronized void terracottaStoreInitialized(TerracottaStore newTerracottaStore) {
            this.underlyingTerracottaStore = newTerracottaStore;
            if (this.nodeBulkLoadEnabled) {
                LOG.debug("Enabling bulk-load for " + this.cache.getName());
                this.underlyingTerracottaStore.setNodeCoherent(false);
            }
            this.nonstopExecutorService = this.cache.getCacheManager().getNonstopExecutorService();
            Object context = this.underlyingTerracottaStore.getInternalContext();
            if (!(context instanceof CacheLockProvider)) {
                throw new AssertionError((Object)("TerracottaStore.getInternalContext() is not correct - " + (context == null ? "NULL" : context.getClass().getName())));
            }
            this.underlyingCacheLockProvider = (CacheLockProvider)context;
            this.cacheEventReplicator = this.cache.getCacheManager().getClusteredInstanceFactory(this.cache).createEventReplicator(this.cache);
        }

        @Override
        public TerracottaStore getUnderlyingTerracottaStore() {
            return this.underlyingTerracottaStore;
        }

        @Override
        public NonstopExecutorService getNonstopExecutorService() {
            return this.nonstopExecutorService;
        }

        @Override
        public CacheLockProvider getUnderlyingCacheLockProvider() {
            return this.underlyingCacheLockProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CacheEventListener getCacheEventReplicator() {
            if (this.cacheEventReplicator != null) {
                return this.cacheEventReplicator;
            }
            NonstopActiveDelegateHolderImpl nonstopActiveDelegateHolderImpl = this;
            synchronized (nonstopActiveDelegateHolderImpl) {
                if (this.cacheEventReplicator == null) {
                    this.cacheEventReplicator = this.cache.getCacheManager().getClusteredInstanceFactory(this.cache).createEventReplicator(this.cache);
                }
                return this.cacheEventReplicator;
            }
        }
    }

    private static class CacheStatus {
        private volatile Status status = Status.STATUS_UNINITIALISED;
        private final AtomicBoolean clusterRejoinInProgress = new AtomicBoolean(false);

        private CacheStatus() {
        }

        private void clusterRejoinComplete() {
            this.clusterRejoinInProgress.set(false);
        }

        public void checkAlive(CacheConfiguration configuration) {
            Status readStatus = this.status;
            if (readStatus != Status.STATUS_ALIVE) {
                throw new IllegalStateException("The " + configuration.getName() + " Cache is not alive (" + readStatus + ")");
            }
        }

        private void clusterRejoinInProgress() {
            this.clusterRejoinInProgress.set(true);
        }

        public boolean canInitialize() {
            return this.status == Status.STATUS_UNINITIALISED || this.clusterRejoinInProgress.get();
        }

        public void changeState(Status newState) {
            this.status = newState;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isAlive() {
            return this.status == Status.STATUS_ALIVE;
        }

        public boolean isShutdown() {
            return this.status == Status.STATUS_SHUTDOWN;
        }

        public boolean isUninitialized() {
            return this.status == Status.STATUS_UNINITIALISED;
        }
    }
}

