/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate.management.impl;

import java.awt.Color;

public abstract class CacheRegionUtils {
    public static final Color HIT_COLOR = Color.green;
    public static final Color MISS_COLOR = Color.red;
    public static final Color PUT_COLOR = Color.blue;
    public static final Color HIT_FILL_COLOR = HIT_COLOR.brighter().brighter().brighter();
    public static final Color MISS_FILL_COLOR = MISS_COLOR.brighter().brighter().brighter();
    public static final Color PUT_FILL_COLOR = PUT_COLOR.brighter().brighter().brighter();
    public static final Color HIT_DRAW_COLOR = HIT_COLOR.darker();
    public static final Color MISS_DRAW_COLOR = MISS_COLOR.darker();
    public static final Color PUT_DRAW_COLOR = PUT_COLOR.darker();

    public static String determineShortName(String fullName) {
        String result = fullName;
        if (fullName != null) {
            String[] comps = fullName.split("\\.");
            if (comps.length == 1) {
                return fullName;
            }
            boolean truncate = true;
            for (int i2 = 0; i2 < comps.length; ++i2) {
                String comp = comps[i2];
                char c2 = comp.charAt(0);
                if (truncate && Character.isUpperCase(c2)) {
                    truncate = false;
                }
                if (!truncate) continue;
                comps[i2] = Character.toString(c2);
            }
            result = CacheRegionUtils.join(comps, '.');
        }
        return result;
    }

    private static String join(String[] elements, char c2) {
        if (elements == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s2 : elements) {
            sb.append(s2).append(c2);
        }
        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }
}

