/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.ManagementRESTServiceConfiguration;
import net.sf.ehcache.management.ResourceClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementServerLoader {
    private static final String PRIVATE_CLASSPATH = "rest-management-private-classpath";
    private static final Map<String, Object> MGMT_SVR_BY_BIND = new HashMap<String, Object>();
    private static final ResourceClassLoader RESOURCE_CLASS_LOADER;
    private static final Logger LOG;

    public static void register(CacheManager cacheManager, ManagementRESTServiceConfiguration managementRESTServiceConfiguration) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(RESOURCE_CLASS_LOADER);
            Class<?> managementServerImplClass = RESOURCE_CLASS_LOADER.loadClass("net.sf.ehcache.management.ManagementServerImpl");
            Object managementServerImpl = null;
            if (!MGMT_SVR_BY_BIND.containsKey(managementRESTServiceConfiguration.getBind())) {
                if (!MGMT_SVR_BY_BIND.isEmpty()) {
                    String alreadyBound = MGMT_SVR_BY_BIND.keySet().iterator().next();
                    managementRESTServiceConfiguration.setBind(alreadyBound);
                    LOG.warn("You can not have several Ehcache management rest agents running in the same ClassLoader; CacheManager " + cacheManager.getName() + " will be registered to the already running Ehcache management rest agent listening on port " + alreadyBound + ", the configuration will not be changed");
                } else {
                    ManagementServerLoader.startRestAgent(managementRESTServiceConfiguration, managementServerImplClass);
                }
            } else {
                LOG.warn("A previous CacheManager already instanciated the Ehcache Management rest agent, on port " + managementRESTServiceConfiguration.getBind() + ", the configuration will not be changed for " + cacheManager.getName());
            }
            managementServerImpl = MGMT_SVR_BY_BIND.get(managementRESTServiceConfiguration.getBind());
            Method registerMethod = managementServerImplClass.getMethod("register", cacheManager.getClass());
            registerMethod.invoke(managementServerImpl, cacheManager);
        }
        catch (Exception e2) {
            if (e2.getCause() instanceof ClassNotFoundException) {
                throw new RuntimeException("Failed to initialize the ManagementRESTService - Did you include ehcache-rest-agent on the classpath?", e2);
            }
            throw new RuntimeException("Failed to instantiate ManagementServer.", e2);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static void startRestAgent(ManagementRESTServiceConfiguration managementRESTServiceConfiguration, Class<?> managementServerImplClass) throws Exception {
        Constructor<?> managementServerImplClassConstructor = managementServerImplClass.getConstructor(managementRESTServiceConfiguration.getClass());
        Object managementServerImpl = managementServerImplClassConstructor.newInstance(managementRESTServiceConfiguration);
        Method startMethod = managementServerImplClass.getMethod("start", new Class[0]);
        startMethod.invoke(managementServerImpl, new Object[0]);
        MGMT_SVR_BY_BIND.put(managementRESTServiceConfiguration.getBind(), managementServerImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(String registeredMgmtSvrBind, CacheManager cacheManager) {
        Object managementServerImpl = MGMT_SVR_BY_BIND.get(registeredMgmtSvrBind);
        boolean removeMgmtSvr = false;
        try {
            Class<?> managementServerImplClass = RESOURCE_CLASS_LOADER.loadClass("net.sf.ehcache.management.ManagementServerImpl");
            Method registerMethod = managementServerImplClass.getMethod("unregister", cacheManager.getClass());
            registerMethod.invoke(managementServerImpl, cacheManager);
            Method hasRegisteredMethod = managementServerImplClass.getMethod("hasRegistered", new Class[0]);
            Boolean hasRegistered = (Boolean)hasRegisteredMethod.invoke(managementServerImpl, new Object[0]);
            if (!hasRegistered.booleanValue()) {
                removeMgmtSvr = true;
                Method stopMethod = managementServerImplClass.getMethod("stop", new Class[0]);
                stopMethod.invoke(managementServerImpl, new Object[0]);
            }
        }
        catch (Exception e2) {
            LOG.warn("Failed to shutdown the ManagementRESTService", e2);
        }
        finally {
            if (removeMgmtSvr) {
                MGMT_SVR_BY_BIND.remove(registeredMgmtSvrBind);
            }
        }
    }

    static {
        LOG = LoggerFactory.getLogger(ManagementServerLoader.class);
        RESOURCE_CLASS_LOADER = new ResourceClassLoader(PRIVATE_CLASSPATH, CacheManager.class.getClassLoader());
    }
}

