/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.sampled;

import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheWriterConfiguration;
import net.sf.ehcache.management.sampled.CacheManagerSampler;
import net.sf.ehcache.management.sampled.Utils;
import net.sf.ehcache.statistics.LiveCacheStatistics;
import net.sf.ehcache.statistics.sampled.SampledCacheStatistics;
import net.sf.ehcache.writer.writebehind.WriteBehindManager;

public class CacheManagerSamplerImpl
implements CacheManagerSampler {
    private final CacheManager cacheManager;

    public CacheManagerSamplerImpl(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void clearAll() {
        this.cacheManager.clearAll();
    }

    @Override
    public String[] getCacheNames() throws IllegalStateException {
        return this.cacheManager.getCacheNames();
    }

    @Override
    public String getStatus() {
        return this.cacheManager.getStatus().toString();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Map<String, long[]> getCacheMetrics() {
        HashMap<String, long[]> result = new HashMap<String, long[]>();
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result.put(cacheName, new long[]{stats.getCacheHitMostRecentSample(), stats.getCacheMissNotFoundMostRecentSample() + stats.getCacheMissExpiredMostRecentSample(), stats.getCacheElementPutMostRecentSample()});
        }
        return result;
    }

    @Override
    public long getCacheHitRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheHitMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheInMemoryHitRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheHitInMemoryMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheOffHeapHitRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheHitOffHeapMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheOnDiskHitRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheHitOnDiskMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheMissRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheMissNotFoundMostRecentSample() + stats.getCacheMissExpiredMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheInMemoryMissRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheMissInMemoryMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheOffHeapMissRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheMissOffHeapMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheOnDiskMissRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheMissOnDiskMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCachePutRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementPutMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheUpdateRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementUpdatedMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheRemoveRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementRemovedMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheEvictionRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementEvictedMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheExpirationRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementExpiredMostRecentSample();
        }
        return result;
    }

    @Override
    public float getCacheAverageGetTime() {
        float result = 0.0f;
        int instances = 0;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            result += cache.getAverageGetTime();
            ++instances;
        }
        return instances > 0 ? result / (float)instances : 0.0f;
    }

    @Override
    public long getCacheSearchRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getSearchesPerSecond();
        }
        return result;
    }

    @Override
    public long getCacheAverageSearchTime() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getAverageSearchTime();
        }
        return result;
    }

    @Override
    public boolean getHasWriteBehindWriter() {
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null || !(cache.getWriterManager() instanceof WriteBehindManager) || cache.getRegisteredCacheWriter() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getWriterQueueLength() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            LiveCacheStatistics stats = cache.getLiveCacheStatistics();
            result += Math.max(stats.getWriterQueueLength(), 0L);
        }
        return result;
    }

    @Override
    public int getWriterMaxQueueSize() {
        int result = 0;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            CacheWriterConfiguration writerConfig = cache.getCacheConfiguration().getCacheWriterConfiguration();
            result += writerConfig.getWriteBehindMaxQueueSize() * writerConfig.getWriteBehindConcurrency();
        }
        return result;
    }

    @Override
    public long getMaxBytesLocalDisk() {
        return this.cacheManager.getConfiguration().getMaxBytesLocalDisk();
    }

    @Override
    public String getMaxBytesLocalDiskAsString() {
        return this.cacheManager.getConfiguration().getMaxBytesLocalDiskAsString();
    }

    @Override
    public void setMaxBytesLocalDisk(long maxBytes) {
        try {
            this.cacheManager.getConfiguration().setMaxBytesLocalDisk(maxBytes);
        }
        catch (RuntimeException e2) {
            throw Utils.newPlainException(e2);
        }
    }

    @Override
    public void setMaxBytesLocalDiskAsString(String maxBytes) {
        try {
            this.cacheManager.getConfiguration().setMaxBytesLocalDisk(maxBytes);
        }
        catch (RuntimeException e2) {
            throw Utils.newPlainException(e2);
        }
    }

    @Override
    public long getMaxBytesLocalHeap() {
        return this.cacheManager.getConfiguration().getMaxBytesLocalHeap();
    }

    @Override
    public String getMaxBytesLocalHeapAsString() {
        return this.cacheManager.getConfiguration().getMaxBytesLocalHeapAsString();
    }

    @Override
    public void setMaxBytesLocalHeap(long maxBytes) {
        try {
            this.cacheManager.getConfiguration().setMaxBytesLocalHeap(maxBytes);
        }
        catch (RuntimeException e2) {
            throw Utils.newPlainException(e2);
        }
    }

    @Override
    public void setMaxBytesLocalHeapAsString(String maxBytes) {
        try {
            this.cacheManager.getConfiguration().setMaxBytesLocalHeap(maxBytes);
        }
        catch (RuntimeException e2) {
            throw Utils.newPlainException(e2);
        }
    }

    @Override
    public long getMaxBytesLocalOffHeap() {
        return this.cacheManager.getConfiguration().getMaxBytesLocalOffHeap();
    }

    @Override
    public String getMaxBytesLocalOffHeapAsString() {
        return this.cacheManager.getConfiguration().getMaxBytesLocalOffHeapAsString();
    }

    @Override
    public String getName() {
        return this.cacheManager.getName();
    }

    @Override
    public String getClusterUUID() {
        return this.cacheManager.getClusterUUID();
    }

    @Override
    public void clearStatistics() {
        for (String cacheName : this.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) continue;
            cache.clearStatistics();
        }
    }

    @Override
    public void enableStatistics() {
        for (String cacheName : this.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) continue;
            cache.setSampledStatisticsEnabled(true);
        }
    }

    @Override
    public void disableStatistics() {
        for (String cacheName : this.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) continue;
            cache.setStatisticsEnabled(false);
        }
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        if (enabled) {
            this.enableStatistics();
        } else {
            this.disableStatistics();
        }
    }

    @Override
    public boolean isStatisticsEnabled() {
        for (String cacheName : this.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null || cache.isSampledStatisticsEnabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String generateActiveConfigDeclaration() {
        return this.cacheManager.getActiveConfigurationText();
    }

    @Override
    public String generateActiveConfigDeclaration(String cacheName) {
        return this.cacheManager.getActiveConfigurationText(cacheName);
    }

    @Override
    public boolean getTransactional() {
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null || !cache.getCacheConfiguration().getTransactionalMode().isTransactional()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getSearchable() {
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null || cache.getCacheConfiguration().getSearchable() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getTransactionCommittedCount() {
        return this.cacheManager.getTransactionController().getTransactionCommittedCount();
    }

    @Override
    public long getTransactionCommitRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheXaCommitsMostRecentSample();
        }
        return result;
    }

    @Override
    public long getTransactionRolledBackCount() {
        return this.cacheManager.getTransactionController().getTransactionRolledBackCount();
    }

    @Override
    public long getTransactionRollbackRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheXaRollbacksMostRecentSample();
        }
        return result;
    }

    @Override
    public long getTransactionTimedOutCount() {
        return this.cacheManager.getTransactionController().getTransactionTimedOutCount();
    }

    @Override
    public boolean isEnabled() throws CacheException {
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null || !cache.isDisabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            cache.setDisabled(!enabled);
        }
    }
}

