/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.statistics;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.statistics.CacheUsageListener;
import net.sf.ehcache.statistics.LiveCacheStatistics;
import net.sf.ehcache.statistics.LiveCacheStatisticsData;
import net.sf.ehcache.writer.CacheWriterManager;
import net.sf.ehcache.writer.writebehind.WriteBehindManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveCacheStatisticsImpl
implements LiveCacheStatistics,
LiveCacheStatisticsData {
    private static final Logger LOG = LoggerFactory.getLogger(LiveCacheStatisticsImpl.class.getName());
    private static final int MIN_MAX_DEFAULT_VALUE = -1;
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int HIT_RATIO_MULTIPLIER = 100;
    private final AtomicBoolean statisticsEnabled = new AtomicBoolean(true);
    private final AtomicLong cacheHitInMemoryCount = new AtomicLong();
    private final AtomicLong cacheHitOffHeapCount = new AtomicLong();
    private final AtomicLong cacheHitOnDiskCount = new AtomicLong();
    private final AtomicLong cacheMissNotFound = new AtomicLong();
    private final AtomicLong cacheMissInMemoryCount = new AtomicLong();
    private final AtomicLong cacheMissOffHeapCount = new AtomicLong();
    private final AtomicLong cacheMissOnDiskCount = new AtomicLong();
    private final AtomicLong cacheMissExpired = new AtomicLong();
    private final AtomicLong cacheElementEvictedCount = new AtomicLong();
    private final AtomicLong totalGetTimeTakenNanos = new AtomicLong();
    private final AtomicLong cacheElementRemoved = new AtomicLong();
    private final AtomicLong cacheElementExpired = new AtomicLong();
    private final AtomicLong cacheElementPut = new AtomicLong();
    private final AtomicLong cacheElementUpdated = new AtomicLong();
    private final AtomicInteger statisticsAccuracy = new AtomicInteger();
    private final AtomicLong minGetTimeNanos = new AtomicLong(-1L);
    private final AtomicLong maxGetTimeNanos = new AtomicLong(-1L);
    private final AtomicLong xaCommitCount = new AtomicLong();
    private final AtomicLong xaRollbackCount = new AtomicLong();
    private final AtomicLong xaRecoveredCount = new AtomicLong();
    private final List<CacheUsageListener> listeners = new CopyOnWriteArrayList<CacheUsageListener>();
    private final Ehcache cache;

    public LiveCacheStatisticsImpl(Ehcache cache) {
        this.cache = cache;
    }

    @Override
    public void clearStatistics() {
        this.cacheHitInMemoryCount.set(0L);
        this.cacheHitOffHeapCount.set(0L);
        this.cacheHitOnDiskCount.set(0L);
        this.cacheMissExpired.set(0L);
        this.cacheMissNotFound.set(0L);
        this.cacheMissInMemoryCount.set(0L);
        this.cacheMissOffHeapCount.set(0L);
        this.cacheMissOnDiskCount.set(0L);
        this.cacheElementEvictedCount.set(0L);
        this.totalGetTimeTakenNanos.set(0L);
        this.cacheElementRemoved.set(0L);
        this.cacheElementExpired.set(0L);
        this.cacheElementPut.set(0L);
        this.cacheElementUpdated.set(0L);
        this.minGetTimeNanos.set(-1L);
        this.maxGetTimeNanos.set(-1L);
        this.xaCommitCount.set(0L);
        this.xaRollbackCount.set(0L);
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyStatisticsCleared();
        }
    }

    @Override
    public void xaCommit() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.xaCommitCount.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyXaCommit();
        }
    }

    @Override
    public void xaRollback() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.xaRollbackCount.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyXaRollback();
        }
    }

    @Override
    public void xaRecovered(int count) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.xaRecoveredCount.addAndGet(count);
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled.get();
    }

    @Override
    public void setStatisticsEnabled(boolean enableStatistics) {
        if (enableStatistics) {
            this.clearStatistics();
        }
        this.statisticsEnabled.set(enableStatistics);
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyStatisticsEnabledChanged(enableStatistics);
        }
    }

    @Override
    public void addGetTimeNanos(long nanos) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.totalGetTimeTakenNanos.addAndGet(nanos);
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyGetTimeNanos(nanos);
            l2.notifyTimeTakenForGet(nanos / 1000000L);
        }
        if (this.minGetTimeNanos.get() == -1L || nanos < this.minGetTimeNanos.get()) {
            this.minGetTimeNanos.set(nanos);
        }
        if (this.maxGetTimeNanos.get() == -1L || nanos > this.maxGetTimeNanos.get() && nanos > 0L) {
            this.maxGetTimeNanos.set(nanos);
        }
    }

    @Override
    public void addGetTimeMillis(long millis) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.totalGetTimeTakenNanos.addAndGet(millis);
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyTimeTakenForGet(millis);
        }
        if (this.minGetTimeNanos.get() == -1L || millis < this.minGetTimeNanos.get()) {
            this.minGetTimeNanos.set(millis);
        }
        if (this.maxGetTimeNanos.get() == -1L || millis > this.maxGetTimeNanos.get() && millis > 0L) {
            this.maxGetTimeNanos.set(millis);
        }
    }

    @Override
    public void cacheHitInMemory() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheHitInMemoryCount.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyCacheHitInMemory();
        }
    }

    @Override
    public void cacheHitOffHeap() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheHitOffHeapCount.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyCacheHitOffHeap();
        }
    }

    @Override
    public void cacheHitOnDisk() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheHitOnDiskCount.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyCacheHitOnDisk();
        }
    }

    @Override
    public void cacheMissExpired() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheMissExpired.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyCacheMissedWithExpired();
        }
    }

    @Override
    public void cacheMissNotFound() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheMissNotFound.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyCacheMissedWithNotFound();
        }
    }

    @Override
    public void cacheMissInMemory() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheMissInMemoryCount.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyCacheMissInMemory();
        }
    }

    @Override
    public void cacheMissOffHeap() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheMissOffHeapCount.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyCacheMissOffHeap();
        }
    }

    @Override
    public void cacheMissOnDisk() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheMissOnDiskCount.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyCacheMissOnDisk();
        }
    }

    @Override
    public void setStatisticsAccuracy(int statisticsAccuracy) {
        if (!Statistics.isValidStatisticsAccuracy(statisticsAccuracy)) {
            throw new IllegalArgumentException("Invalid statistics accuracy value: " + statisticsAccuracy);
        }
        this.statisticsAccuracy.set(statisticsAccuracy);
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyStatisticsAccuracyChanged(statisticsAccuracy);
        }
    }

    @Override
    public void dispose() {
        for (CacheUsageListener l2 : this.listeners) {
            l2.dispose();
        }
    }

    @Override
    public void notifyElementEvicted(Ehcache cache, Element element) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementEvictedCount.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyCacheElementEvicted();
        }
    }

    @Override
    public void notifyElementExpired(Ehcache cache, Element element) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementExpired.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyCacheElementExpired();
        }
    }

    @Override
    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementPut.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyCacheElementPut();
        }
    }

    @Override
    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementRemoved.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyCacheElementRemoved();
        }
    }

    @Override
    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementUpdated.incrementAndGet();
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyCacheElementUpdated();
        }
    }

    @Override
    public void notifyRemoveAll(Ehcache cache) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        for (CacheUsageListener l2 : this.listeners) {
            l2.notifyRemoveAll();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        super.clone();
        throw new CloneNotSupportedException();
    }

    @Override
    public float getAverageGetTimeMillis() {
        return (float)this.getAverageGetTimeNanos() / 1000000.0f;
    }

    @Override
    public long getAverageGetTimeNanos() {
        long accessCount = this.getCacheHitCount() + this.getCacheMissCount();
        if (accessCount == 0L) {
            return 0L;
        }
        return this.totalGetTimeTakenNanos.get() / accessCount;
    }

    @Override
    public void registerCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        if (!this.isStatisticsEnabled()) {
            LOG.warn("Registering a CacheUsageListener on {} whose statistics are currently disabled.  No events will be fired until statistics are enabled.", (Object)this.cache.getName());
        }
        this.listeners.add(cacheUsageListener);
    }

    @Override
    public void removeCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.listeners.remove(cacheUsageListener);
    }

    @Override
    public long getCacheHitCount() {
        return this.cacheHitInMemoryCount.get() + this.cacheHitOffHeapCount.get() + this.cacheHitOnDiskCount.get();
    }

    @Override
    public long getCacheMissCount() {
        return this.cacheMissNotFound.get() + this.cacheMissExpired.get();
    }

    @Override
    public long getInMemoryMissCount() {
        return this.cacheMissInMemoryCount.get();
    }

    @Override
    public long getOffHeapMissCount() {
        return this.cacheMissOffHeapCount.get();
    }

    @Override
    public long getOnDiskMissCount() {
        return this.cacheMissOnDiskCount.get();
    }

    @Override
    public long getCacheMissCountExpired() {
        return this.cacheMissExpired.get();
    }

    @Override
    public int getCacheHitRatio() {
        long hits = this.getCacheHitCount();
        long accesses = hits + this.getCacheMissCount();
        return (int)(accesses == 0L ? 0.0 : (double)hits / (double)accesses * 100.0);
    }

    @Override
    public long getEvictedCount() {
        return this.cacheElementEvictedCount.get();
    }

    @Override
    public long getInMemoryHitCount() {
        return this.cacheHitInMemoryCount.get();
    }

    @Override
    public long getOffHeapHitCount() {
        return this.cacheHitOffHeapCount.get();
    }

    @Override
    public long getOnDiskHitCount() {
        return this.cacheHitOnDiskCount.get();
    }

    @Override
    public long getSize() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.getSizeBasedOnAccuracy(this.statisticsAccuracy.get());
    }

    @Override
    @Deprecated
    public long getInMemorySize() {
        return this.getLocalHeapSize();
    }

    @Override
    @Deprecated
    public long getOffHeapSize() {
        return this.getLocalOffHeapSize();
    }

    @Override
    @Deprecated
    public long getOnDiskSize() {
        return this.getLocalDiskSize();
    }

    @Override
    public long getLocalHeapSize() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.getMemoryStoreSize();
    }

    @Override
    public long getLocalOffHeapSize() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.getOffHeapStoreSize();
    }

    @Override
    public long getLocalDiskSize() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.getDiskStoreSize();
    }

    @Override
    public long getLocalDiskSizeInBytes() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.calculateOnDiskSize();
    }

    @Override
    public long getLocalHeapSizeInBytes() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.calculateInMemorySize();
    }

    @Override
    public long getLocalOffHeapSizeInBytes() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.calculateOffHeapSize();
    }

    @Override
    public String getCacheName() {
        return this.cache.getName();
    }

    @Override
    public int getStatisticsAccuracy() {
        return this.statisticsAccuracy.get();
    }

    @Override
    public long getExpiredCount() {
        return this.cacheElementExpired.get();
    }

    @Override
    public long getPutCount() {
        return this.cacheElementPut.get();
    }

    @Override
    public long getRemovedCount() {
        return this.cacheElementRemoved.get();
    }

    @Override
    public long getUpdateCount() {
        return this.cacheElementUpdated.get();
    }

    @Override
    public String getStatisticsAccuracyDescription() {
        int value = this.statisticsAccuracy.get();
        if (value == 0) {
            return "None";
        }
        if (value == 1) {
            return "Best Effort";
        }
        return "Guaranteed";
    }

    @Override
    public long getMaxGetTimeMillis() {
        return this.maxGetTimeNanos.get() / 1000000L;
    }

    @Override
    public long getMinGetTimeMillis() {
        return this.minGetTimeNanos.get() / 1000000L;
    }

    @Override
    public long getMaxGetTimeNanos() {
        return this.maxGetTimeNanos.get();
    }

    @Override
    public long getMinGetTimeNanos() {
        return this.minGetTimeNanos.get();
    }

    @Override
    public long getXaCommitCount() {
        return this.xaCommitCount.get();
    }

    @Override
    public long getXaRollbackCount() {
        return this.xaRollbackCount.get();
    }

    @Override
    public long getXaRecoveredCount() {
        return this.xaRecoveredCount.get();
    }

    @Override
    public long getWriterQueueLength() {
        CacheWriterManager writerManager = this.cache.getWriterManager();
        if (writerManager instanceof WriteBehindManager) {
            return ((WriteBehindManager)writerManager).getQueueSize();
        }
        return 0L;
    }
}

